#include "UG_IO_LIB.h"

INT_ ugc_startup
 (int argc,
  char *argv[],
  char Input_File_Name[],
  char Output_File_Name[],
  INT_ *Bnd_Only_Flag, 
  INT_ *Mode_Flag,
  INT_ *No_Quad_Flag, 
  INT_ *Renumber_ID_Flag,
  INT_ *Separate_by_ID_Flag,
  INT_ *Set_Vol_ID_Flag,
  INT_ *Surf_Quad_Flag,
  INT_ *Surf_Tria_Flag,
  INT_ *Vol_Hex_Flag,
  INT_ *Vol_Pent_5_Flag,
  INT_ *Vol_Pent_6_Flag,
  INT_ *Vol_Tet_Flag,
  INT_ *Number_of_Rm_Surf_IDs,
  INT_1D ** Rm_Surf_ID)

{

/*
 * Set input and output file names, list program help, and set parameter
 * structure.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ugc_startup.c,v 1.18 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_Param_Struct *Param_Struct_Ptr = NULL;

  char *str_ptr = NULL;

  INT_1D *List = NULL;

  INT_ i, Get_Flag, Set_Flag;

  INT_ Error_Flag = 0;
  INT_ Help_Flag = 0;
  INT_ Help_UG_IO_Flag = 0;

  // set input and output file names and remove from argument vector

  strcpy (Input_File_Name, "");
  strcpy (Output_File_Name, "");

  i = 1;

  Get_Flag = 0;

  while (i < argc && Get_Flag < 2)
  {
    str_ptr = strstr (argv[i], "-");

    if (str_ptr == NULL || strcmp (str_ptr, argv[i]))
    {
      if (Get_Flag == 0)
      {
        Get_Flag = 1;

        strcpy (Input_File_Name, argv[i]);

        strcpy (argv[i], "");
      }
      else
      {
        Get_Flag = 2;

        strcpy (Output_File_Name, argv[i]);

        strcpy (argv[i], "");
      }
    }

    ++i;
  }

  // register and set param structure function

  ug_set_prog_param_function2 (ugc_initialize_param);

  // set param structure from arguments

  Error_Flag = ug_set_prog_param (argv, argc, 0, 0, 0, &Param_Struct_Ptr);

  // get help flags

  if (Error_Flag == 0)
  {
    Get_Flag = ug_get_int_param ("Help_Flag", &Help_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Help_UG_IO_Flag", &Help_UG_IO_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Mode_Flag", Mode_Flag, Param_Struct_Ptr);
  }

  // list program help

  if (argc == 1)
    Help_Flag = -1;

  if (Help_Flag == 3) Help_Flag = 1;
  if (Help_Flag == 4) Help_Flag = 2;

  if (Error_Flag == 0)
    ug_write_prog_info (Help_Flag, argv, argc,
                        "[input_file] [output_file]",
                        "Convert standard UG_IO file types.");

  if (Error_Flag == 0)
    Error_Flag = ug_io_write_param_info (3-(*Mode_Flag), (*Mode_Flag)-2, 1, 0, 1, 1,
                                         Help_UG_IO_Flag);

  if (Error_Flag == 0 && (Help_Flag || Help_UG_IO_Flag))
    Error_Flag = -1;

  // set input and output file names in param structure

  if (Error_Flag == 0)
  {
    Set_Flag = ug_set_char_param ("Input_File_Name", Input_File_Name, Param_Struct_Ptr);
    Set_Flag = ug_set_char_param ("Output_File_Name", Output_File_Name, Param_Struct_Ptr);

  // get input parameters

    Get_Flag = ug_get_char_param ("Input_File_Name", Input_File_Name, Param_Struct_Ptr);
    Get_Flag = ug_get_char_param ("Output_File_Name", Output_File_Name, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Bnd_Only_Flag", Bnd_Only_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Mode_Flag", Mode_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("No_Quad_Flag", No_Quad_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Renumber_ID_Flag", Renumber_ID_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Separate_by_ID_Flag", Separate_by_ID_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Set_Vol_ID_Flag", Set_Vol_ID_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Surf_Quad_Flag", Surf_Quad_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Surf_Tria_Flag", Surf_Tria_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Vol_Hex_Flag", Vol_Hex_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Vol_Pent_5_Flag", Vol_Pent_5_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Vol_Pent_6_Flag", Vol_Pent_6_Flag, Param_Struct_Ptr);
    Get_Flag = ug_get_int_param ("Vol_Tet_Flag", Vol_Tet_Flag, Param_Struct_Ptr);

    *Number_of_Rm_Surf_IDs = 0;

    Get_Flag = ug_get_int_param_vector ("Rm_Surf_IDs", Number_of_Rm_Surf_IDs, &List, Param_Struct_Ptr);

    if (Get_Flag == 1 && *Number_of_Rm_Surf_IDs)
    {
      *Rm_Surf_ID = (INT_1D *) ug_malloc (&Error_Flag, (*Number_of_Rm_Surf_IDs) * sizeof (INT_1D));

      if (Error_Flag)
      {
        ug_error_message ("*** ERROR 100619 : unable to allocate space for list of IDs to remove ***");
      }
      else
        ug_copy_int (0, (*Number_of_Rm_Surf_IDs)-1, List, *Rm_Surf_ID);
    }
    else
    {
      *Number_of_Rm_Surf_IDs = 0;

      *Rm_Surf_ID = NULL;
    }
  }

  // free param structure

  ug_free_param (Param_Struct_Ptr);

  return (Error_Flag);

}
