#include "UG_IO_LIB.h"

INT_ ugc_initialize_param
 (UG_Param_Struct * UGC_Param_Struct_Ptr)

{

/*
 * Set the name, flag, default value, minimum allowable value, maximum allowable
 * value, and description for all UGC executable parameters.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ugc_initialize_param.c,v 1.20 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ierr = 0;

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("NULL", "", "", "", "", 0, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-2d", "-2", 
     "Convert a 2D planar grid file.",
     "Only applicable for 2D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Mode_Flag=2", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-b", "", 
     "Read in only the boundary grid.",
     "If the input grid file is 3D and contains a volume grid then \
only the boundary surface portion is kept for output. ; \
If the input grid file is 2D and contains a planar grid then \
only the boundary edge portion is kept for output. ; \
Only applicable for 2D planar or 3D volume grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Bnd_Only_Flag=1", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-br", "", 
     "Read in only the boundary surface grid and separate.",
     "If the input grid file contains a volume grid then \
only the surface portion is kept for output. \
Re-order the surface grid such that it is sorted into groups by \
surface ID, and duplicate all nodes that are shared by faces with \
different surface IDs. ; \
Only applicable for 3D surface or volume grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Bnd_Only_Flag=1 Separate_by_ID_Flag=1", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-idr", "", 
     "Renumber input surface face IDs consecutively 1,2,3...",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Renumber_ID_Flag=1", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-no_quad", "-nq",
     "Convert quads to trias.",
     "Only applicable for 2D planar or 3D surface grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "No_Quad_Flag=1", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-vol_id", "", 
     "Allocate, read, set, and write volume ID.",
     "Only applicable for 3D volume grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Set_Vol_ID_Flag=1", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_quad", "", 
     "Delete boundary quad-faces in output file.",
     "Only applicable for 3D grid files. ; \
Do rmt set this option directly using the Param_Name=Value mode.",
     "Surf_Quad_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_tria", "", 
     "Delete boundary tria-faces in output file.",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Surf_Tria_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_hex", "", 
     "Delete hex-elements in output file.",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Vol_Hex_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_pyramid", "", 
     "Delete pyramid-elements in output file.",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Vol_Pent_5_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_prism", "", 
     "Delete prism-elements in output file.",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Vol_Pent_6_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_tet", "", 
     "Delete tet-elements in output file.",
     "Only applicable for 3D grid files. ; \
Do not set this option directly using the Param_Name=Value mode.",
     "Vol_Tet_Flag=0", 1, 2, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-ifile", "-i", 
     "Specify input grid, node, or function file to convert.",
     "The input and output files must be of the same kind, \
i.e. grid, node, or function. ; \
Note that the input and output file names may be set using either both of the \
-ifile (or -i) and -ofile (or -o) option flags or by specifying both of the \
input and output file names directly without a parameter option flag. ; \
For example ; \
; ^ \
-i input_file -o output_file ; \
; ^ \
or ; \
; ^ \
input_file output_file ; \
; ^ \
Do not set this option directly using the Param_Name=Value mode.",
     "Input_File_Name=", 1, 3, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-ofile", "-o", 
     "Specify output grid, node, or function file to convert.",
     "The input and output files must be of the same kind, \
i.e. grid, node, or function. ; \
Note that the input and output file names may be set using either both of the \
-ifile (or -i) and -ofile (or -o) option flags or by specifying both of the \
input and output file names directly without a parameter option flag. \
For example ; \
; ^ \
-i input_file -o output_file ; \
; ^ \
or ; \
; ^ \
input_file output_file ; \
; ^ \
Do not set this option directly using the Param_Name=Value mode.",
     "Output_File_Name=", 1, 3, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("-rm_ids", "",
     "List of surface IDs to remove from the output grid.",
     "If the -rm_ids parameter vector is set \
then the boundary surface faces with the specified IDs will be removed \
from the output grid. Given -rm_ids id_1,id_2,...,id_n \
then remove all faces with surface IDs id_1 id_2 ... id_n. \
Commas are required between the surface IDs in the list. \
If only one ID is specified then it must be terminated with a comma. ; \
Only applicable for 3D grid files.",
     "Rm_Surf_IDs=", 1, 3, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Rm_Surf_IDs", "",
     "List of surface IDs to remove from the output grid.",
     "If the Rm_Surf_IDs parameter vector is set \
then the boundary surface faces with the specified IDs will be removed \
from the output grid. ; \
Only applicable for 3D grid files.",
     4, 1, 0, 0, 0, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("Input_File_Name", "", 
     "", "", "", 5, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_char_param_struct ("Output_File_Name", "", 
     "", "", "", 5, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Bnd_Only_Flag", "", 
     "", "", 5, 0, 0, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Mode_Flag", "", 
     "", "", 5, 0, 3, 2, 3, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("No_Quad_Flag", "", 
     "", "", 5, 0, 0, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Renumber_ID_Flag", "", 
     "", "", 5, 0, 0, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Separate_by_ID_Flag", "", 
     "", "", 5, 0, 0, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Set_Vol_ID_Flag", "", 
     "", "", 5, 0, 0, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Surf_Quad_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Surf_Tria_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Vol_Hex_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Vol_Pent_5_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Vol_Pent_6_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_set_int_param_struct ("Vol_Tet_Flag", "", 
     "", "", 5, 0, 1, 0, 1, UGC_Param_Struct_Ptr);

  if (ierr) return (ierr);

  ug_set_param_def (UGC_Param_Struct_Ptr);

  return (0);

}
