#include "UG_IO_LIB.h"

INT_ ug_io_write_tetgen
 (char Case_Name[],
  INT_ Number_of_Nodes,
  INT_ Number_of_Surf_Trias,
  INT_ Number_of_Vol_Tets,
  INT_1D * Surf_ID_Flag,
  INT_3D * Surf_Tria_Connectivity,
  INT_4D * Vol_Tet_Connectivity,
  DOUBLE_3D * Coordinates)

{

/*
 * Write grid data to TetGen volume or surface grid files.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_tetgen.c,v 1.2 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Grid_File = NULL;

  CHAR_UG_MAX Grid_File_Name;

  INT_ Index, Write_Flag;

  strcpy (Grid_File_Name, "");
  strcat (Grid_File_Name, Case_Name);
  strcat (Grid_File_Name, ".node");

  Grid_File = ug_fopen (Grid_File_Name, "w");

  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR : error opening TETGEN .node grid file ***");
    return (1);
  }

  Write_Flag = fprintf (Grid_File, "%i 3 0 0\n", (int) Number_of_Nodes);

  for (Index = 1; Index <= Number_of_Nodes; ++Index)
  {
    Write_Flag = fprintf (Grid_File, "%i %g %g %g\n", (int) Index,
                          Coordinates[Index][0],
                          Coordinates[Index][1],
                          Coordinates[Index][2]);

    if (Write_Flag <= 0)
    {
      ug_error_message ("*** ERROR : error writing TETGEN .node grid file ***");
      return (1);
    }
  }

  ug_fclose (Grid_File);

  Grid_File = NULL;

  if (Number_of_Vol_Tets)
  {
    strcpy (Grid_File_Name, "");
    strcat (Grid_File_Name, Case_Name);
    strcat (Grid_File_Name, ".ele");

    Grid_File = ug_fopen (Grid_File_Name, "w");

    if (Grid_File == NULL)
    {
      ug_error_message ("*** ERROR : error opening TETGEN .ele grid file ***");
      return (1);
    }

    Write_Flag = fprintf (Grid_File, "%i 4 0\n", (int) Number_of_Vol_Tets);

    for (Index = 1; Index <= Number_of_Vol_Tets; ++Index)
    {
      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i\n", (int) Index,
                            (int) Vol_Tet_Connectivity[Index][0],
                            (int) Vol_Tet_Connectivity[Index][1],
                            (int) Vol_Tet_Connectivity[Index][2],
                            (int) Vol_Tet_Connectivity[Index][3]);

      if (Write_Flag <= 0)
      {
        ug_error_message ("*** ERROR : error writing TETGEN .ele grid file ***");
        return (1);
      }
    }

    ug_fclose (Grid_File);

    Grid_File = NULL;
  }

  strcpy (Grid_File_Name, "");
  strcat (Grid_File_Name, Case_Name);
  strcat (Grid_File_Name, ".face");

  Grid_File = ug_fopen (Grid_File_Name, "w");
  
  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR : unable to open TETGEN .face grid file ***");
    return (1);
  }

  Write_Flag = fprintf (Grid_File, "%i 0\n", (int) Number_of_Surf_Trias);
  
  for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
  {
    if (Surf_ID_Flag != NULL)
      Write_Flag = fprintf (Grid_File, "%i %i %i %i\n", (int) Index,
                            (int) Surf_Tria_Connectivity[Index][0],
                            (int) Surf_Tria_Connectivity[Index][1],
                            (int) Surf_Tria_Connectivity[Index][2]);
    else
      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i\n", (int) Index,
                            (int) Surf_Tria_Connectivity[Index][0],
                            (int) Surf_Tria_Connectivity[Index][1],
                            (int) Surf_Tria_Connectivity[Index][2],
                            (int) Surf_ID_Flag[Index]);

    if (Write_Flag <= 0)
    {
      ug_error_message ("*** ERROR : error writing TETGEN .face grid file ***");
      return (1);
    }
  }

  ug_fclose (Grid_File);

  Grid_File = NULL;

  return (0);

}
