#include "UG_IO_LIB.h"

INT_ ug_io_write_poly
 (FILE * Grid_File,
  INT_ *Number_of_Bnd_Nodes,
  INT_ Number_of_Nodes,
  INT_ Number_of_Surf_Quads,
  INT_ Number_of_Surf_Trias,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_3D * Surf_Tria_Connectivity,
  DOUBLE_3D * Coordinates)

{

/*
 * Write grid data to a POLY surface grid file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_poly.c,v 1.14 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *Node_Index_Map = NULL;

  DOUBLE_1D *Initial_Normal_Spacing = NULL;
  DOUBLE_1D *BL_Thickness = NULL;

  INT_ Error_Flag, Index, Node_Index, Node_Index1, Node_Index2, Node_Index3,
       Node_Index4, Number_of_Surf_Faces, Surf_Node_Index, Write_Flag;

  Error_Flag = ug3_bnd_nodes (0, Number_of_Bnd_Nodes, Number_of_Nodes,
                              Number_of_Surf_Trias, Number_of_Surf_Quads,
                              Surf_Tria_Connectivity, Surf_Quad_Connectivity,
                              &Node_Index_Map,
                              BL_Thickness, Initial_Normal_Spacing,
                              Coordinates);

  if (Error_Flag > 0)
    return (Error_Flag);

  Number_of_Surf_Faces = Number_of_Surf_Trias + Number_of_Surf_Quads;

  Write_Flag = fprintf (Grid_File, "#POLY FILE GENERATED BY UG_IO\n");

  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "#Node List\n");
  Write_Flag = fprintf (Grid_File, "%i 3 0 0\n", (int) *Number_of_Bnd_Nodes);

  for (Node_Index = 1; Node_Index <= Number_of_Nodes; ++Node_Index)
  {
    Surf_Node_Index = Node_Index_Map[Node_Index];

    if (Surf_Node_Index > 0)
      Write_Flag = fprintf (Grid_File, "%i %.15g %.15g %.15g 0\n",
                            (int) Surf_Node_Index,
                            Coordinates[Node_Index][0],
                            Coordinates[Node_Index][1],
                            Coordinates[Node_Index][2]);
  }

  if (Write_Flag < 0)
  {
    ug_free (Node_Index_Map);
    ug_error_message ("*** ERROR : error writing POLY grid file ***");
    return (1);
  }

  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "#Face List\n");
  Write_Flag = fprintf (Grid_File, "%i 1\n", (int) Number_of_Surf_Faces);

  if (Write_Flag < 0)
  {
    ug_free (Node_Index_Map);
    ug_error_message ("*** ERROR : error writing POLY grid file ***");
    return (1);
  }

  for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
  {
    Node_Index1 = Surf_Tria_Connectivity[Index][0];
    Node_Index2 = Surf_Tria_Connectivity[Index][1];
    Node_Index3 = Surf_Tria_Connectivity[Index][2];

    Write_Flag = fprintf (Grid_File, "1 0 %i\n", (int) Surf_ID_Flag[Index]);
    Write_Flag = fprintf (Grid_File, "3 %i %i %i\n",
                          (int) Node_Index1, (int) Node_Index2, (int) Node_Index3);
  }

  if (Write_Flag < 0)
  {
    ug_free (Node_Index_Map);
    ug_error_message ("*** ERROR : error writing POLY grid file ***");
    return (1);
  }

  for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
  {
    Node_Index1 = Surf_Quad_Connectivity[Index][0];
    Node_Index2 = Surf_Quad_Connectivity[Index][1];
    Node_Index3 = Surf_Quad_Connectivity[Index][2];
    Node_Index4 = Surf_Quad_Connectivity[Index][3];

    Write_Flag = fprintf (Grid_File, "1 0 %i\n", 
                          (int) Surf_ID_Flag[Number_of_Surf_Trias+Index]);
    Write_Flag = fprintf (Grid_File, "4 %i %i %i %i\n",
                          (int) Node_Index1, (int) Node_Index2, (int) Node_Index3, (int) Node_Index4);
  }

  if (Write_Flag < 0)
  {
    ug_free (Node_Index_Map);
    ug_error_message ("*** ERROR : error writing POLY grid file ***");
    return (1);
  }

  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "#Hole List\n");
  Write_Flag = fprintf (Grid_File, "0\n");

  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "#Region List\n");
  Write_Flag = fprintf (Grid_File, "0\n");

  if (Write_Flag < 0)
  {
    ug_free (Node_Index_Map);
    ug_error_message ("*** ERROR : error writing POLY grid file ***");
    return (1);
  }

  ug_free (Node_Index_Map);

  return (0);

}
