#include "UG_IO_LIB.h"

static void ug_io_write_param_info_
 (INT_ Write_Flag,
  char *Param_Suffix,
  char *Param_Info,
  char *Param_Doc);

INT_ ug_io_write_param_info
 (INT_ Write_2D_Types,
  INT_ Write_3D_Types,
  INT_ Write_Func_Types,
  INT_ Write_Geom_Types,
  INT_ Write_Grid_Types,
  INT_ Write_Node_Types,
  INT_ Write_Flag)

{

/*
 * Write information on all UG_IO parameters to standard output.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_param_info.c,v 1.31 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_IO_Param_Struct *UG_IO_Param_Struct_Ptr=NULL;

  INT_ ierr, File_Type_Format_Flag_, Format_Option, Index, Input_Option,
       INT64_Option, Mode_Option, Output_Option;

  if (Write_Flag == 0)
    return (0);

  ierr = ug_io_malloc_param (&UG_IO_Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug_io_initialize_param (Write_2D_Types, Write_3D_Types,
                                   Write_Func_Types, Write_Geom_Types,
                                   Write_Grid_Types, Write_Node_Types,
                                   UG_IO_Param_Struct_Ptr);

  if (ierr)
    return (ierr);

  ug_message (" ");
  ug_message ("________________________________________________________________________________");
  ug_message (" ");
  ug_message ("UG_IO File Names");
  ug_message ("________________________________________________________________________________");
  ug_message (" ");
  ug_message ("UG_IO file names are specified as");
  ug_message (" ");
  ug_message ("   case_name[.format].type[.compression]");
  ug_message (" ");
  ug_message ("where [ ] encloses an optional suffix and where");
  ug_message (" ");
  ug_message ("   case_name is the required file case name");
  ug_message ("   .format is the optional file format suffix");
  ug_message ("   .type is the required file type suffix");
  ug_message ("   .compression is the optional file compression suffix");

  if (Write_Flag == 1)
  {
    ug_message (" ");
    ug_message ("Format Suffix          Description");
    ug_message ("____________________   _____________________________________________________");
  }
  else
  {
    ug_message (" ");
    ug_message ("File Format Suffix and Description");
    ug_message ("________________________________________________________________________________");
    ug_message (" ");
  }

  for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Formats; ++Index)
  {
    ug_io_write_param_info_ (Write_Flag,
     (char *) (UG_IO_Param_Struct_Ptr->File_Format_Suffix[Index]),
     (char *) (UG_IO_Param_Struct_Ptr->File_Format_Info[Index]),
     (char *) (UG_IO_Param_Struct_Ptr->File_Format_Doc[Index]));

    if (Write_Flag == 2)
      ug_message (" ");
  }

  if (Write_Flag == 1)
  {
    ug_message (" ");
    ug_message ("Type Suffix            Description");
    ug_message ("____________________   _________________________________________________________");
  }
  else
  {
    ug_message (" ");
    ug_message ("File Type Suffix and Description");
    ug_message ("________________________________________________________________________________");
    ug_message (" ");
  }

  for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Types; ++Index)
  {
    File_Type_Format_Flag_ = UG_IO_Param_Struct_Ptr->File_Type_Format_Flag[Index];

    INT64_Option = File_Type_Format_Flag_ / 16;

    if (sizeof (INT_) == sizeof (int) || INT64_Option)
    {
      ug_io_write_param_info_ (Write_Flag,
       (char *) (UG_IO_Param_Struct_Ptr->File_Type_Suffix[Index]),
       (char *) (UG_IO_Param_Struct_Ptr->File_Type_Info[Index]),
       (char *) (UG_IO_Param_Struct_Ptr->File_Type_Doc[Index]));

      if (Write_Flag == 2)
      {
        Format_Option = (File_Type_Format_Flag_ - INT64_Option * 16) / 8;
        Mode_Option = (File_Type_Format_Flag_ - INT64_Option * 16 - Format_Option * 8) / 4;
        Output_Option = (File_Type_Format_Flag_
                       - INT64_Option * 16 - Format_Option * 8 - Mode_Option * 4) / 2;
        Input_Option = File_Type_Format_Flag_
                     - INT64_Option * 16 - Format_Option * 8 - Mode_Option * 4
                     - Output_Option * 2;

        if (Format_Option == 0)
          ug_parse_text_string (0, "This file type uses a fixed file format \
and the [.format] File Format Suffix is not applicable.");

        if (Mode_Option == 1)
          ug_parse_text_string (0, "This file type can use socket or TMP \
file mode if a C binary double file format is also used.");

        if (Input_Option == 0)
          ug_parse_text_string (0, "This file type may only be used for output files.");

        if (Output_Option == 0)
          ug_parse_text_string (0, "This file type may only be used for input files.");

        ug_message (" ");
      }
    }
  }

  if (Write_Flag == 1)
  {
    ug_message (" ");
    ug_message ("Compression Suffix     Description");
    ug_message ("____________________   _____________________________________________________");
  }
  else
  {
    ug_message (" ");
    ug_message ("File Compression Suffix and Description");
    ug_message ("________________________________________________________________________________");
    ug_message (" ");
  }

  for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Compressions; ++Index)
  {
    ug_io_write_param_info_ (Write_Flag,
     (char *) (UG_IO_Param_Struct_Ptr->File_Compression_Suffix[Index]),
     (char *) (UG_IO_Param_Struct_Ptr->File_Compression_Info[Index]),
     (char *) (UG_IO_Param_Struct_Ptr->File_Compression_Doc[Index]));

    if (Write_Flag == 2)
      ug_message (" ");
  }

  return (0);

}

static void ug_io_write_param_info_
 (INT_ Write_Flag,
  char *Param_Suffix,
  char *Param_Info,
  char *Param_Doc)

{

/*
 * Write information on a given UG_IO file parameter to standard output.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_param_info.c,v 1.31 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_81 Text_String;

  INT_ i, n;

  if (Write_Flag == 1)
  {
    snprintf (Text_String, sizeof(Text_String), "%-20s : ", Param_Suffix);
    strncat (Text_String, Param_Info, 80-23-1);
    ug_message (Text_String);
  }

  else
  {
    snprintf (Text_String, sizeof(Text_String), "%-s", Param_Suffix);
    ug_message (Text_String);

    n = (INT_) strlen (Text_String);
    n = MAX (n, 3);

    strcpy (Text_String, "");

    for (i = 1; i <= n; ++i)
    {
      strcat (Text_String, "-");
    }

    ug_message (Text_String);

    ug_parse_text_string (0, Param_Info);
    ug_parse_text_string (0, Param_Doc);
  }

  return;
}
