#include "UG_IO_LIB.h"

INT_ ug_io_write_node
 (FILE * Node_Data_File,
  INT_ File_Type_Flag,
  INT_ Number_of_Nodes,
  DOUBLE_3D * Coordinates,
  DOUBLE_1D * Spacing,
  DOUBLE_6D * Metric)

{

/*
 * Write node data to a 3D SNODE source node or MNODE metric source node data
 * file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_node.c,v 1.13 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Node_Index, Write_Flag;

  Write_Flag = 0;

  if (File_Type_Flag == 1)
  {
    if (Spacing == NULL)
    {
      ug_error_message ("*** ERROR : SNODE source node data file must have input spacing function data ***");
      return (1);
    }

    for (Node_Index = 1; Node_Index <= Number_of_Nodes; ++Node_Index)
    {
      Write_Flag = fprintf (Node_Data_File, "%.15g %.15g %.15g %.15g\n",
                            Coordinates[Node_Index][0],
                            Coordinates[Node_Index][1],
                            Coordinates[Node_Index][2],
                            Spacing[Node_Index]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing SNODE source node data file ***");
      return (1);
    }
  }

  else if (File_Type_Flag == 2)
  {
    if (Spacing == NULL)
    {
      ug_error_message ("*** ERROR : MNODE metric source node data file must have input metric data ***");
      return (1);
    }

    for (Node_Index = 1; Node_Index <= Number_of_Nodes; ++Node_Index)
    {
      Write_Flag = fprintf (Node_Data_File, "%.15g %.15g %.15g %.15g %.15g %.15g %.15g %.15g %.15g\n",
                            Coordinates[Node_Index][0],
                            Coordinates[Node_Index][1],
                            Coordinates[Node_Index][2],
                            Metric[Node_Index][0],
                            Metric[Node_Index][1],
                            Metric[Node_Index][2],
                            Metric[Node_Index][3],
                            Metric[Node_Index][4],
                            Metric[Node_Index][5]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing MNODE metric source node data file ***");
      return (1);
    }
  }

  return (0);

}
