#include "UG_IO_LIB.h"

INT_ ug_io_write_nas
 (FILE * Grid_File,
  INT_ Number_of_BL_Vol_Tets,
  INT_ Number_of_Nodes,
  INT_ Number_of_Surf_Quads,
  INT_ Number_of_Surf_Trias,
  INT_ Number_of_Vol_Hexs,
  INT_ Number_of_Vol_Pents_5,
  INT_ Number_of_Vol_Pents_6,
  INT_ Number_of_Vol_Tets,
  INT_1D * Surf_Grid_BC_Flag,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_1D * Surf_Reconnection_Flag,
  INT_3D * Surf_Tria_Connectivity,
  INT_8D * Vol_Hex_Connectivity,
  INT_1D * Vol_ID_Flag,
  INT_5D * Vol_Pent_5_Connectivity,
  INT_6D * Vol_Pent_6_Connectivity,
  INT_4D * Vol_Tet_Connectivity,
  DOUBLE_3D * Coordinates,
  DOUBLE_1D * Initial_Normal_Spacing,
  DOUBLE_1D * BL_Thickness)

{

/*
 * Write grid data to a NASTRAN volume or surface grid file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_nas.c,v 1.23 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_21 Label;
  CHAR_41 Char_Map;

  INT_ Char_Index, Coordinate_System, Current_Char_Value, File_Index, Index,
       Label_Index, Last_Char_Value, Number_of_Bnd_Nodes, Number_of_Label_Chars,
       Number_of_Map_Chars, Number_of_Surf_Faces, Number_of_Vol_Elems,
       Remainder, Vol_ID, Vol_Index, Write_Flag;

  Vol_ID = 0;

  File_Index = 0;

  Number_of_Label_Chars = 6;

  Number_of_Map_Chars = 36;

  strcpy (Char_Map, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");

  Last_Char_Value = 1;

  for (Label_Index = 1; Label_Index < Number_of_Label_Chars; ++Label_Index)
  {
    Last_Char_Value = Number_of_Map_Chars * Last_Char_Value;
  }

  Number_of_Bnd_Nodes = 0;

  for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
  {
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Tria_Connectivity[Index][0]);
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Tria_Connectivity[Index][1]);
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Tria_Connectivity[Index][2]);
  }

  for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
  {
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Quad_Connectivity[Index][0]);
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Quad_Connectivity[Index][1]);
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Quad_Connectivity[Index][2]);
    Number_of_Bnd_Nodes = MAX (Number_of_Bnd_Nodes,
                               Surf_Quad_Connectivity[Index][3]);
  }

  Write_Flag = fprintf (Grid_File, "$\n");
  Write_Flag = fprintf (Grid_File, "$       NASTRAN INPUT DECK GENERATED BY UG_IO\n");
  Write_Flag = fprintf (Grid_File, "$\n");

  Write_Flag = fprintf (Grid_File, "BEGIN BULK\n");

  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_BL_Vol_Tets %i\n",
                        (int) Number_of_BL_Vol_Tets);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Bnd_Nodes %i\n",
                        (int) Number_of_Bnd_Nodes);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Nodes %i\n",
                        (int) Number_of_Nodes);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Surf_Quads %i\n",
                        (int) Number_of_Surf_Quads);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Surf_Trias %i\n",
                        (int) Number_of_Surf_Trias);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Vol_Hexs %i\n",
                        (int) Number_of_Vol_Hexs);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Vol_Pents_5 %i\n",
                        (int) Number_of_Vol_Pents_5);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Vol_Pents_6 %i\n",
                        (int) Number_of_Vol_Pents_6);
  Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
  Write_Flag = fprintf (Grid_File, "$Number_of_Vol_Tets %i\n",
                        (int) Number_of_Vol_Tets);
  Write_Flag = fprintf (Grid_File, "$\n");

  Write_Flag = fprintf (Grid_File, "$CORD   Data\n");
  Write_Flag = fprintf (Grid_File, "$GRID   Data\n");

  Coordinate_System = 0;

  for (Index = 1; Index <= Number_of_Nodes; ++Index)
  {
    strcpy (Label, "*C");

    Current_Char_Value = Last_Char_Value;

    Remainder = Index;

    Label_Index = 0;

    for (Label_Index = 0; Label_Index < Number_of_Label_Chars; ++Label_Index)
    {
      Char_Index = Remainder / Current_Char_Value;

      strncat (Label, &Char_Map[Char_Index], 1);

      Remainder = Remainder - Char_Index * Current_Char_Value;

      Current_Char_Value = Current_Char_Value / Number_of_Map_Chars;
    }

    Write_Flag = fprintf (Grid_File,
                          "GRID*   %-16i%-16i%16.8e%16.8e%s\n",
                          (int) Index,
                          (int) Coordinate_System,
                          Coordinates[Index][0],
                          Coordinates[Index][1],
                          Label);

    Write_Flag = fprintf (Grid_File,
                          "%s%16.8e\n", 
                          Label,
                          Coordinates[Index][2]);
  }

  if (Write_Flag < 0)
  {
    ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
    return (1);
  }

  if (Number_of_Surf_Trias > 0)
  {
    Write_Flag = fprintf (Grid_File, "$CTRIA3 Data\n");

    for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
    {
      ++File_Index;

      Write_Flag = fprintf (Grid_File,
                            "CTRIA3  %-8i%-8i%-8i%-8i%-8i\n",
                            (int) File_Index,
                            (int) Surf_ID_Flag[Index],
                            (int) Surf_Tria_Connectivity[Index][0],
                            (int) Surf_Tria_Connectivity[Index][1],
                            (int) Surf_Tria_Connectivity[Index][2]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  if (Number_of_Surf_Quads > 0)
  {
    Write_Flag = fprintf (Grid_File, "$CQUAD4 Data\n");

    for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
    {
      ++File_Index;

      Write_Flag = fprintf (Grid_File,
                            "CQUAD4  %-8i%-8i%-8i%-8i%-8i%-8i\n",
                            (int) File_Index,
                            (int) Surf_ID_Flag[Index+Number_of_Surf_Trias],
                            (int) Surf_Quad_Connectivity[Index][0],
                            (int) Surf_Quad_Connectivity[Index][1],
                            (int) Surf_Quad_Connectivity[Index][2],
                            (int) Surf_Quad_Connectivity[Index][3]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  if (Number_of_Vol_Tets > 0)
  {

    Write_Flag = fprintf (Grid_File, "$CTETRA Data\n");

    for (Index = 1; Index <= Number_of_Vol_Tets; ++Index)
    {
      ++File_Index;

      if (Vol_ID_Flag != NULL)
        Vol_ID = Vol_ID_Flag[Index];

      Write_Flag = fprintf (Grid_File,
                            "CTETRA  %-8i%-8i%-8i%-8i%-8i%-8i\n",
                            (int) File_Index,
                            (int) Vol_ID,
                            (int) Vol_Tet_Connectivity[Index][0],
                            (int) Vol_Tet_Connectivity[Index][1],
                            (int) Vol_Tet_Connectivity[Index][2],
                            (int) Vol_Tet_Connectivity[Index][3]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  if (Number_of_Vol_Pents_5 > 0)
  {
    Vol_Index = Number_of_Vol_Tets;

    Write_Flag = fprintf (Grid_File, "$CPENTA Data\n");

    for (Index = 1; Index <= Number_of_Vol_Pents_5; ++Index)
    {
      ++File_Index;

      if (Vol_ID_Flag != NULL)
        Vol_ID = Vol_ID_Flag[++Vol_Index];

      Write_Flag = fprintf (Grid_File,
                            "CPENTA  %-8i%-8i%-8i%-8i%-8i%-8i%-8i%-8i\n",
                            (int) File_Index,
                            (int) Vol_ID,
                            (int) Vol_Pent_5_Connectivity[Index][0],
                            (int) Vol_Pent_5_Connectivity[Index][1],
                            (int) Vol_Pent_5_Connectivity[Index][2],
                            (int) Vol_Pent_5_Connectivity[Index][3],
                            (int) Vol_Pent_5_Connectivity[Index][4],
                            (int) Vol_Pent_5_Connectivity[Index][4]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  if (Number_of_Vol_Pents_6 > 0)
  {
    Vol_Index = Number_of_Vol_Tets + Number_of_Vol_Pents_5;

    Write_Flag = fprintf (Grid_File, "$CPENTA Data\n");

    for (Index = 1; Index <= Number_of_Vol_Pents_6; ++Index)
    {
      ++File_Index;

      if (Vol_ID_Flag != NULL)
        Vol_ID = Vol_ID_Flag[++Vol_Index];

      Write_Flag = fprintf (Grid_File,
                            "CPENTA  %-8i%-8i%-8i%-8i%-8i%-8i%-8i%-8i\n",
                            (int) File_Index,
                            (int) Vol_ID,
                            (int) Vol_Pent_6_Connectivity[Index][0],
                            (int) Vol_Pent_6_Connectivity[Index][1],
                            (int) Vol_Pent_6_Connectivity[Index][2],
                            (int) Vol_Pent_6_Connectivity[Index][3],
                            (int) Vol_Pent_6_Connectivity[Index][4],
                            (int) Vol_Pent_6_Connectivity[Index][5]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  if (Number_of_Vol_Hexs > 0)
  {
    Vol_Index = Number_of_Vol_Tets + Number_of_Vol_Pents_5
              + Number_of_Vol_Pents_6;

    Write_Flag = fprintf (Grid_File, "$CHEXA  Data\n");

    for (Index = 1; Index <= Number_of_Vol_Hexs; ++Index)
    {
      ++File_Index;

      strcpy (Label, "*H");

      Current_Char_Value = Last_Char_Value;

      Remainder = Index;

      Label_Index = 0;

      for (Label_Index = 0; Label_Index < Number_of_Label_Chars; ++Label_Index)
      {
        Char_Index = Remainder / Current_Char_Value;

        strncat (Label, &Char_Map[Char_Index], 1);

        Remainder = Remainder - Char_Index * Current_Char_Value;

        Current_Char_Value = Current_Char_Value / Number_of_Map_Chars;
      }

      if (Vol_ID_Flag != NULL)
        Vol_ID = Vol_ID_Flag[++Vol_Index];

      Write_Flag = fprintf (Grid_File,
                            "CHEXA   %-8i%-8i%-8i%-8i%-8i%-8i%-8i%-8i%s\n",
                            (int) File_Index,
                            (int) Vol_ID,
                            (int) Vol_Hex_Connectivity[Index][0],
                            (int) Vol_Hex_Connectivity[Index][1],
                            (int) Vol_Hex_Connectivity[Index][2],
                            (int) Vol_Hex_Connectivity[Index][3],
                            (int) Vol_Hex_Connectivity[Index][4],
                            (int) Vol_Hex_Connectivity[Index][5],
                            Label);

      Write_Flag = fprintf (Grid_File,
                            "%s%-8i%-8i\n",
                            Label,
                            (int) Vol_Hex_Connectivity[Index][6],
                            (int) Vol_Hex_Connectivity[Index][7]);
    }

    if (Write_Flag < 0)
    {
      ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
      return (1);
    }
  }

  Number_of_Surf_Faces = Number_of_Surf_Trias + Number_of_Surf_Quads;

  Number_of_Vol_Elems = Number_of_Vol_Hexs + Number_of_Vol_Pents_5
                      + Number_of_Vol_Pents_6 + Number_of_Vol_Tets;

  if (Number_of_Surf_Faces > 0)
  {
    if (Number_of_Vol_Elems == 0)
    {
      Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
      Write_Flag = fprintf (Grid_File, "$Initial_Normal_Spacing Data\n");

      if (Initial_Normal_Spacing != NULL)
      {
        for (Index = 1; Index <= Number_of_Bnd_Nodes; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "$ %.15g\n",
                                Initial_Normal_Spacing[Index]);
        }
      }
      else
      {
        for (Index = 1; Index <= Number_of_Bnd_Nodes; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "$ 0.0\n");
        }
      }

      Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
      Write_Flag = fprintf (Grid_File, "$BL_Thickness Data\n");

      if (BL_Thickness != NULL)
      {
        for (Index = 1; Index <= Number_of_Bnd_Nodes; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "$ %.15g\n", BL_Thickness[Index]);
        }
      }
      else
      {
        for (Index = 1; Index <= Number_of_Bnd_Nodes; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "$ 0.0\n");
        }
      }
    }

    Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
    Write_Flag = fprintf (Grid_File, "$Surf_Grid_BC_Flag Data\n");

    if (Surf_Grid_BC_Flag != NULL)
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "$ %i\n",
                              (int) Surf_Grid_BC_Flag[Index]);
      }
    }
    else
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "$ -1\n");
      }
    }

    Write_Flag = fprintf (Grid_File, "$UG_IO_ Data\n");
    Write_Flag = fprintf (Grid_File, "$Surf_Reconnection_Flag Data\n");

    if (Surf_Reconnection_Flag != NULL)
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "$ %i\n",
                              (int) Surf_Reconnection_Flag[Index]);
      }
    }
    else
    {
      for (Index = 1; Index <= Number_of_Surf_Faces; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "$ 0\n");
      }
    }
  }

  Write_Flag = fprintf (Grid_File, "ENDDATA\n");

  if (Write_Flag < 0)
  {
    ug_error_message ("*** ERROR : error writing NASTRAN grid file ***");
    return (1);
  }

  return (0);

}
