#include "UG_IO_LIB.h"

INT_ ug_io_write_func_file
 (char Func_File_Name[],
  INT_ Message_Flag,
  INT_ NDim,
  INT_ Number_of_Nodes,
  INT_ Number_of_U_Scalars,
  INT_ Number_of_U_Vectors,
  INT_ Number_of_U_Matrixes,
  INT_ Number_of_U_Metrics,
  CHAR_21 * U_Scalar_Labels,
  CHAR_21 * U_Vector_Labels,
  CHAR_21 * U_Matrix_Labels,
  CHAR_21 * U_Metric_Labels,
  DOUBLE_1D * U_Scalars,
  DOUBLE_1D * U_Vectors,
  DOUBLE_1D * U_Matrixes,
  DOUBLE_1D * U_Metrics)

{

/*
 * Write function data to a standard UG function file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_func_file.c,v 1.45 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Func_File;

  CHAR_UG_MAX Case_Name, File_Name, Name_Text, Text;
  CHAR_21 File_Compression_Suffix_, File_Format_Suffix_, File_Mode_Suffix_, File_Type_Suffix_;

  INT_ Close_Flag, Error_Flag, File_Data_Type_, File_Format_, File_Mode_,
       File_Name_Length, File_Type_Format_Flag_, Index;
  INT_ SFUNC_Flag = 1;

  // get file info

  Error_Flag = ug_io_file_info (Func_File_Name, Case_Name, 
                                File_Compression_Suffix_, File_Format_Suffix_,
                                File_Mode_Suffix_, File_Type_Suffix_,
                                0, NDim, &File_Data_Type_,
                                &File_Format_, &File_Mode_,
                                &File_Type_Format_Flag_);

  // exit for error

  if (Error_Flag) 
    return (Error_Flag);

  // exit if not a function file
  
  if ((NDim == 2 && File_Data_Type_ != UG_IO_2D_FUNCTION_DATA) ||
      (NDim == 3 && File_Data_Type_ != UG_IO_FUNCTION_DATA))
    return (-1);

  // use abs of file format

  File_Format_ = ug_abs (File_Format_);

  // output header

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : OUTPUT FUNCTION FIELD");
    ug_message (" ");
    ug_message ("UG_IO    : Writing Data");
    ug_message (" ");

    ug_cpu_message ("");
  }

  // backup file

  if (File_Mode_ == UG_FIO_STANDARD_FILE_MODE)
    ug_backup_file (Func_File_Name);

  // set file name without compression suffix

  File_Name_Length = (INT_) strlen (Func_File_Name)
                   - (INT_) strlen (File_Compression_Suffix_);

  strcpy (File_Name, "");
  strncat (File_Name, Func_File_Name, File_Name_Length);

  // open file and set close flag

  if (File_Mode_ == UG_FIO_TMP_FILE_MODE)
    Func_File = ug_fopen (File_Name, "tmp");
  else
    Func_File = ug_fopen (File_Name, "w");

  if (Func_File == NULL)
  {
    ug_error_message ("*** ERROR 614 : unable to open output function file ***");
    return (614);
  }

  Close_Flag = 1;

  // write function file

  if (strcmp (File_Type_Suffix_, ".efunc") == 0 ||
      strcmp (File_Type_Suffix_, ".ufunc") == 0)
  {
    SFUNC_Flag = 0;

    Number_of_U_Matrixes = 0;
    Number_of_U_Metrics = 0;

    U_Matrix_Labels = NULL;
    U_Metric_Labels = NULL;

    U_Matrixes = NULL;
    U_Metrics = NULL;
  }

  if (strcmp (File_Type_Suffix_, ".ufunc") == 0 ||
      strcmp (File_Type_Suffix_, ".sfunc") == 0)
    Error_Flag = ug3_write_sfunc (Func_File, File_Format_, NDim,
                                  Number_of_Nodes,
                                  Number_of_U_Scalars, Number_of_U_Vectors,
                                  Number_of_U_Matrixes, Number_of_U_Metrics,
                                  SFUNC_Flag, 
                                  U_Scalar_Labels, U_Vector_Labels,
                                  U_Matrix_Labels, U_Metric_Labels,
                                  U_Scalars, (DOUBLE_1D *) U_Vectors,
                                  (DOUBLE_1D *) U_Matrixes, (DOUBLE_1D *) U_Metrics);

  else if (NDim == 3 && strcmp (File_Type_Suffix_, ".efunc") == 0)
  {
    Close_Flag = ug_fclose (Func_File);

    Error_Flag = ug_io_write_efunc (Case_Name, 
                                    U_Scalar_Labels, U_Vector_Labels,
                                    Number_of_Nodes,
                                    Number_of_U_Scalars, Number_of_U_Vectors,
                                    U_Scalars, (DOUBLE_3D *) U_Vectors);

    Close_Flag = 0;
  } 

  else if (strcmp (File_Type_Suffix_, ".sol") == 0 ||
           strcmp (File_Type_Suffix_, ".solb") == 0)
  {
    Close_Flag = ug_fclose (Func_File);

    Error_Flag = ug3_write_sol (File_Name, 
                                NDim, Number_of_Nodes,
                                Number_of_U_Scalars, Number_of_U_Vectors,
                                Number_of_U_Matrixes, Number_of_U_Metrics,
                                U_Scalars, U_Vectors,
                                U_Matrixes, U_Metrics);

    Close_Flag = 0;
  } 

  else
  { 
    Error_Flag = 1;
    ug_error_message ("*** ERROR 614 : unknown output function file type ***");
  }

  // close file

  if (Close_Flag)
    Close_Flag = ug_fclose (Func_File);

  if (Error_Flag)
    return (614);

  // output function data information

  if (Message_Flag >= 1)
  { 
    strcpy (Name_Text, "");
    strncat (Name_Text, Func_File_Name, ((INT_) strlen (Name_Text))-32);
    snprintf (Text, sizeof(Text), "UG_IO    : Function File Name= %s", Name_Text);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "UG_IO    : Scalar Variables  =%10i", (int) Number_of_U_Scalars);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Vector Variables  =%10i", (int) Number_of_U_Vectors);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Matrix Variables  =%10i", (int) Number_of_U_Matrixes);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Metric Variables  =%10i", (int) Number_of_U_Metrics);
    ug_message (Text);

    if (U_Scalar_Labels)
    {
      for (Index = 0; Index < Number_of_U_Scalars; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : Scalar Label %-4i = %s", (int) Index, U_Scalar_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Vector_Labels)
    {
      for (Index = 0; Index < Number_of_U_Vectors; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : Vector Label %-4i = %s", (int) Index, U_Vector_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Matrix_Labels)
    {
      for (Index = 0; Index < Number_of_U_Matrixes; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : Matrix Label %-4i = %s", (int) Index, U_Matrix_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Metric_Labels)
    {
      for (Index = 0; Index < Number_of_U_Metrics; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : Metric Label %-4i = %s", (int) Index, U_Metric_Labels[Index]);
        ug_message (Text);
      }
    }

    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  // compress file

  ug_compress_file (1, File_Compression_Suffix_, File_Name);

  return (0);

}
