#include "UG_IO_LIB.h"

INT_ ug_io_write_2d_node_file
 (char Node_Data_File_Name[],
  INT_ Message_Flag,
  INT_ Number_of_Nodes,
  DOUBLE_2D * Coordinates,
  DOUBLE_1D * Spacing,
  DOUBLE_3D * Metric)

{

/*
 * Write 2D node data to a standard UG 2D node data file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_2d_node_file.c,v 1.32 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Node_Data_File;

  CHAR_UG_MAX Case_Name, File_Name, Name_Text, Text;
  CHAR_21 File_Compression_Suffix_, File_Format_Suffix_, File_Mode_Suffix_,
          File_Type_Suffix_;

  INT_ Error_Flag, File_Data_Type_, File_Format_, File_Mode_, File_Name_Length, 
       File_Type_Flag, File_Type_Format_Flag_;

  // get file info

  Error_Flag = ug_io_file_info (Node_Data_File_Name, Case_Name, 
                                File_Compression_Suffix_, File_Format_Suffix_,
                                File_Mode_Suffix_, File_Type_Suffix_,
                                0, 2, &File_Data_Type_,
                                &File_Format_, &File_Mode_,
                                &File_Type_Format_Flag_);

  // exit for error

  if (Error_Flag) 
    return (Error_Flag);

  // exit if not a node file
  
  if (File_Data_Type_ != UG_IO_2D_NODE_DATA)
    return (-1);

  // use abs of file format

  File_Format_ = ug_abs (File_Format_);

  // output header

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : OUTPUT 2D NODE DATA");
    ug_message (" ");
    ug_message ("UG_IO    : Writing Data");
    ug_message (" ");

    ug_cpu_message ("");
  }

  // backup file

  Error_Flag = ug_backup_file (Node_Data_File_Name);

  // set file name without compression suffix

  File_Name_Length = (INT_) strlen (Node_Data_File_Name)
                   - (INT_) strlen (File_Compression_Suffix_);

  strcpy (File_Name, "");
  strncat (File_Name, Node_Data_File_Name, File_Name_Length);

  // set correct file type flag
  // snode has no metric
  // mnode includes metric

  File_Type_Flag = (strcmp (File_Type_Suffix_, ".snode2d") == 0) ? 1:
                   (strcmp (File_Type_Suffix_, ".mnode2d") == 0) ? 2: 0;

  // exit on error

  if (File_Type_Flag == 0)
  { 
    ug_error_message ("*** ERROR 613 : unknown output 2D node data file type ***");
    return (613);
  }

  // open file

  Node_Data_File = ug_fopen (File_Name, "w");

  if (Node_Data_File == NULL)
  {
    ug_error_message ("*** ERROR 613 : unable to open output 2D node data file ***");
    return (613);
  }

  // write node file

  Error_Flag = ug_io_write_2d_node (Node_Data_File, 
                                    File_Type_Flag, Number_of_Nodes,
                                    Coordinates, Spacing, Metric);

  // close file

  ug_fclose (Node_Data_File);

  // exit on error

  if (Error_Flag > 0)
    return (613);

  // output node data information

  if (Message_Flag >= 1)
  { 
    strcpy (Name_Text, "");
    strncat (Name_Text, Node_Data_File_Name, ((INT_) strlen (Name_Text))-32);
    snprintf (Text, sizeof(Text), "UG_IO    : NodeData File Name= %s", Name_Text);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Nodes             =%10i", (int) Number_of_Nodes);
    ug_message (Text);
    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  // compress file

  ug_compress_file (1, File_Compression_Suffix_, File_Name);

  return (0);

}
