#include "UG_IO_LIB.h"

INT_ ug_io_write_2d_grid_file
 (char Grid_File_Name[],
  INT_ Message_Flag,
  INT_ Number_of_Bnd_Edges,
  INT_ Number_of_Nodes,
  INT_ Number_of_Quads,
  INT_ Number_of_Trias,
  INT_2D * Bnd_Edge_Connectivity,
  INT_1D * Bnd_Edge_Grid_BC_Flag,
  INT_1D * Bnd_Edge_ID_Flag,
  INT_4D * Quad_Connectivity,
  INT_3D * Tria_Connectivity,
  DOUBLE_2D * Coordinates,
  DOUBLE_1D * Initial_Normal_Spacing,
  DOUBLE_1D * BL_Thickness)

{

/*
 * Write 2D grid data to a standard UG 2D grid file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_write_2d_grid_file.c,v 1.47 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Grid_File;

  CHAR_UG_MAX Case_Name, File_Name, Name_Text, Text;
  CHAR_21 File_Compression_Suffix_, File_Format_Suffix_, File_Mode_Suffix_,
          File_Type_Suffix_;

  INT_1D *Face_ID_Flag = NULL;

  INT_ Close_Flag, Error_Flag, File_Data_Type_, File_Format_, File_Mode_,
       File_Name_Length, File_Type_Format_Flag_;

  // get file info

  Error_Flag = ug_io_file_info (Grid_File_Name, Case_Name, 
                                File_Compression_Suffix_, File_Format_Suffix_,
                                File_Mode_Suffix_, File_Type_Suffix_,
                                0, 2, &File_Data_Type_,
                                &File_Format_, &File_Mode_,
                                &File_Type_Format_Flag_);

  // exit for error

  if (Error_Flag) 
    return (Error_Flag);

  // exit if not a 2D boundary edge or 2D grid file

  if (File_Data_Type_ != UG_IO_2D_EDGE_GRID && File_Data_Type_ != UG_IO_2D_GRID)
    return (-1);

  // use abs of file format

  File_Format_ = ug_abs (File_Format_);

  // output header

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : OUTPUT GRID");
    ug_message (" ");
    ug_message ("UG_IO    : Writing Data");
    ug_message (" ");

    ug_cpu_message ("");
  }

  // backup file

  ug_backup_file (Grid_File_Name);

  // set file name without compression suffix

  File_Name_Length = (INT_) strlen (Grid_File_Name)
                   - (INT_) strlen (File_Compression_Suffix_);

  strcpy (File_Name, "");
  strncat (File_Name, Grid_File_Name, File_Name_Length);

  // open file and set close flag

  Grid_File = ug_fopen (File_Name, "w");

  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR 612 : unable to open output grid file ***");
    return (612);
  }

  Close_Flag = 1;

  // write grid file

  if (strcmp (File_Type_Suffix_, ".ugrid") == 0)
  {
    Error_Flag = ug2_write_ugrid (Grid_File, File_Format_,
                                  Number_of_Nodes,
                                  Number_of_Quads, Number_of_Trias,
                                  Quad_Connectivity, Tria_Connectivity,
                                  Coordinates);

    if (Error_Flag == 0)
      Error_Flag = ug2_write_gdata (Grid_File, File_Format_,
                                    Number_of_Bnd_Edges, Number_of_Nodes,
                                    Number_of_Quads, Number_of_Trias,
                                    Bnd_Edge_Connectivity,
                                    Bnd_Edge_Grid_BC_Flag, Bnd_Edge_ID_Flag,
                                    Initial_Normal_Spacing, BL_Thickness);
  }

  else if (strcmp (File_Type_Suffix_, ".mesh") == 0 ||
           strcmp (File_Type_Suffix_, ".meshb") == 0)
  {
    Close_Flag = ug_fclose (Grid_File);

    Error_Flag = ug2_write_mesh (File_Name, 
                                 Number_of_Nodes,
                                 Number_of_Bnd_Edges,
                                 Number_of_Quads,
                                 Number_of_Trias,
                                 Bnd_Edge_ID_Flag,
                                 Bnd_Edge_Connectivity,
                                 Face_ID_Flag,
                                 Quad_Connectivity,
                                 Tria_Connectivity,
                                 Coordinates);

    Close_Flag = 0;
  }

  else
  { 
    Error_Flag = 612;
    ug_error_message ("*** ERROR 612 : unknown output grid file type ***");
  }

  // close file

  if (Close_Flag == 1)
    Close_Flag = ug_fclose (Grid_File);

  // exit on error

  if (Error_Flag > 0)
    return (612);

  // output grid information

  if (Message_Flag >= 1)
  { 
    strcpy (Name_Text, "");
    strncat (Name_Text, Grid_File_Name, ((INT_) strlen (Name_Text))-32);
    snprintf (Text, sizeof(Text), "UG_IO    : Grid File Name    = %s", Name_Text);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Boundary Edges    =%10i", (int) Number_of_Bnd_Edges);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Nodes             =%10i", (int) Number_of_Nodes);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Quad Faces        =%10i", (int) Number_of_Quads);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG_IO    : Tria Faces        =%10i", (int) Number_of_Trias);
    ug_message (Text);

    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  // compress file

  Error_Flag = ug_compress_file (1, File_Compression_Suffix_, File_Name);
  
  return (0);

}
