#include "UG_IO_LIB.h"

INT_ ug_io_set_file_type_param_struct
 (char File_Type_Suffix_[],
  char File_Type_Info_[],
  char File_Type_Doc_[],
  INT_ File_Data_Type_,
  INT_ Input_Option,
  INT_ Output_Option,
  INT_ Mode_Option,
  INT_ Format_Option,
  INT_ INT64_Option,
  UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given File Type.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_set_file_type_param_struct.c,v 1.6 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag, Index;

  Index = UG_IO_Param_Struct_Ptr->Number_of_File_Types;

  UG_IO_Param_Struct_Ptr->Number_of_File_Types = Index + 1;

  if (Index >= UG_IO_Param_Struct_Ptr->Max_File_Types)
  {
    Error_Flag = ug_io_realloc_param (UG_IO_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_IO_Param_Struct_Ptr->File_Type_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (File_Type_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100611 : unable to allocate space for UG_IO parameters ***");
    return (100611);
  }

  strcpy (UG_IO_Param_Struct_Ptr->File_Type_Suffix[Index], File_Type_Suffix_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Type_Info[Index], File_Type_Info_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Type_Doc[Index], File_Type_Doc_);
  UG_IO_Param_Struct_Ptr->File_Data_Type[Index] = File_Data_Type_;
  UG_IO_Param_Struct_Ptr->File_Type_Format_Flag[Index] = Input_Option 
                                                       + Output_Option * 2
                                                       + Mode_Option * 4 
                                                       + Format_Option * 8
                                                       + INT64_Option * 16;

  return (0);
}
