#include "UG_IO_LIB.h"

INT_ ug_io_set_file_mode_param_struct
 (char File_Mode_Suffix_[],
  char File_Mode_Info_[],
  char File_Mode_Doc_[],
  INT_ File_Mode_,
  UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given File Mode.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_set_file_mode_param_struct.c,v 1.5 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag, Index;

  Index = UG_IO_Param_Struct_Ptr->Number_of_File_Modes;

  UG_IO_Param_Struct_Ptr->Number_of_File_Modes = Index + 1;

  if (Index >= UG_IO_Param_Struct_Ptr->Max_File_Modes)
  {
    Error_Flag = ug_io_realloc_param (UG_IO_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_IO_Param_Struct_Ptr->File_Mode_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (File_Mode_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100613 : unable to allocate space for UG_IO parameters ***");
    return (100613);
  }

  strcpy (UG_IO_Param_Struct_Ptr->File_Mode_Suffix[Index], File_Mode_Suffix_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Mode_Info[Index], File_Mode_Info_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Mode_Doc[Index], File_Mode_Doc_);
  UG_IO_Param_Struct_Ptr->File_Mode[Index] = File_Mode_;

  return (0);
}
