#include "UG_IO_LIB.h"

INT_ ug_io_set_file_format_param_struct
 (char File_Format_Suffix_[],
  char File_Format_Info_[],
  char File_Format_Doc_[],
  INT_ File_Format_,
  UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Set and initialize param structure for a given File Format.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_set_file_format_param_struct.c,v 1.5 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag, Index;

  Index = UG_IO_Param_Struct_Ptr->Number_of_File_Formats;

  UG_IO_Param_Struct_Ptr->Number_of_File_Formats = Index + 1;

  if (Index >= UG_IO_Param_Struct_Ptr->Max_File_Formats)
  {
    Error_Flag = ug_io_realloc_param (UG_IO_Param_Struct_Ptr);

    if (Error_Flag > 0)
      return (Error_Flag);
  }

  Error_Flag = 0;

  UG_IO_Param_Struct_Ptr->File_Format_Doc[Index] = (char *) ug_malloc (&Error_Flag, (strlen (File_Format_Doc_)+1) * (sizeof (char)));

  if (Error_Flag)
  {
    ug_error_message ("*** ERROR 100612 : unable to allocate space for UG_IO parameters ***");
    return (100612);
  }

  strcpy (UG_IO_Param_Struct_Ptr->File_Format_Suffix[Index], File_Format_Suffix_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Format_Info[Index], File_Format_Info_);
  strcpy (UG_IO_Param_Struct_Ptr->File_Format_Doc[Index], File_Format_Doc_);
  UG_IO_Param_Struct_Ptr->File_Format[Index] = File_Format_;

  return (0);
}
