#include "UG_IO_LIB.h"

INT_ ug_io_rm_faces_elems
 (INT_ Number_of_Rm_Surf_IDs,
  INT_ *Number_of_Nodes,
  INT_ *Number_of_Surf_Quads,
  INT_ *Number_of_Surf_Trias,
  INT_ *Number_of_Vol_Hexs,
  INT_ *Number_of_Vol_Pents_5,
  INT_ *Number_of_Vol_Pents_6,
  INT_ *Number_of_Vol_Tets,
  INT_ Surf_Quad_Flag,
  INT_ Surf_Tria_Flag,
  INT_ Vol_Hex_Flag,
  INT_ Vol_Pent_5_Flag,
  INT_ Vol_Pent_6_Flag,
  INT_ Vol_Tet_Flag,
  INT_1D * Rm_Surf_ID,
  INT_1D * Surf_Grid_BC_Flag,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_1D * Surf_Reconnection_Flag,
  INT_3D * Surf_Tria_Connectivity,
  INT_8D * Vol_Hex_Connectivity,
  INT_1D * Vol_ID_Flag,
  INT_5D * Vol_Pent_5_Connectivity,
  INT_6D * Vol_Pent_6_Connectivity,
  INT_4D * Vol_Tet_Connectivity,
  DOUBLE_3D * Coordinates,
  DOUBLE_1D * Initial_Normal_Spacing,
  DOUBLE_1D * BL_Thickness)

{

/*
 * Remove faces of a given Surf_ID, Surf_Tria and/or Surf_Quad faces, and 
 * Vol_Hex, Vol_Pent_5, Vol_Pent_6, and/or Vol_Tet elements.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_rm_faces_elems.c,v 1.6 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *Map = NULL;

  INT_ Dim, Entries, Loc, 
       New_Node, New_Surf_Face, New_Surf_Tria, New_Surf_Quad,
       New_Vol_Elem, 
       Node, Face_Node, Surf_Face, Surf_Tria, Surf_Quad,
       Elem_Node, Vol_Elem, Vol_Hex, Vol_Pent_5, Vol_Pent_6, Vol_Tet;
  INT_ Error_Flag = 0;

  Entries = MAX (*Number_of_Nodes, (*Number_of_Surf_Trias)+(*Number_of_Surf_Quads));

  Map = (INT_1D *) ug_malloc (&Error_Flag, (Entries+1) * sizeof (INT_1D));

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100620 : unable to allocate space for temporary map ***");
    ug_free (Map);
    return (1);
  }

  if (Number_of_Rm_Surf_IDs && Surf_ID_Flag)
  {
    for (Surf_Face = 1; Surf_Face <= (*Number_of_Surf_Trias)+(*Number_of_Surf_Quads); ++Surf_Face)
    {
      Map[Surf_Face] = 1;
    }

    for (Loc = 0; Loc < Number_of_Rm_Surf_IDs; ++Loc)
    {
      Surf_Face = 0;

      for (Surf_Tria = 1; Surf_Tria <= *Number_of_Surf_Trias; ++Surf_Tria)
      {
        ++Surf_Face;

        if (Surf_ID_Flag[Surf_Face] == Rm_Surf_ID[Loc])
          Map[Surf_Face] = 0;
      }
    }

    for (Loc = 0; Loc < Number_of_Rm_Surf_IDs; ++Loc)
    {
      Surf_Face = *Number_of_Surf_Trias;

      for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
      {
        ++Surf_Face;

        if (Surf_ID_Flag[Surf_Face] == Rm_Surf_ID[Loc])
          Map[Surf_Face] = 0;
      }
    }

    New_Surf_Face = 0;

    Surf_Face = 0;

    for (Surf_Tria = 1; Surf_Tria <= *Number_of_Surf_Trias; ++Surf_Tria)
    {
      ++Surf_Face;

      if (Map[Surf_Face])
      {
        ++New_Surf_Face;

        Map[Surf_Face] = New_Surf_Face;
      }
    }

    New_Surf_Tria = New_Surf_Face;

    Surf_Face = *Number_of_Surf_Trias;

    for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
    {
      ++Surf_Face;

      if (Map[Surf_Face])
      {
        ++New_Surf_Face;

        Map[Surf_Face] = New_Surf_Face;
      }
    }

    New_Surf_Quad = New_Surf_Face-New_Surf_Tria;

    Surf_Face = 0;

    for (Surf_Tria = 1; Surf_Tria <= *Number_of_Surf_Trias; ++Surf_Tria)
    {
      ++Surf_Face;

      New_Surf_Face = Map[Surf_Face];

      if (New_Surf_Face)
      {
        New_Surf_Tria = New_Surf_Face;

        Surf_ID_Flag[New_Surf_Face] = Surf_ID_Flag[Surf_Face];

        if (Surf_Grid_BC_Flag)
          Surf_Grid_BC_Flag[New_Surf_Face] = Surf_Grid_BC_Flag[Surf_Face];

        if (Surf_Reconnection_Flag)
          Surf_Reconnection_Flag[New_Surf_Face] = Surf_Reconnection_Flag[Surf_Face];

        for (Face_Node = 0; Face_Node < 3; ++Face_Node)
        {
          Surf_Tria_Connectivity[New_Surf_Tria][Face_Node] = Surf_Tria_Connectivity[Surf_Tria][Face_Node];
        }
      }
    }

    for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
    {
      ++Surf_Face;

      New_Surf_Face = Map[Surf_Face];

      if (New_Surf_Face)
      {
        New_Surf_Quad = New_Surf_Face-New_Surf_Tria;

        Surf_ID_Flag[New_Surf_Face] = Surf_ID_Flag[Surf_Face];

        if (Surf_Grid_BC_Flag)
          Surf_Grid_BC_Flag[New_Surf_Face] = Surf_Grid_BC_Flag[Surf_Face];

        if (Surf_Reconnection_Flag)
          Surf_Reconnection_Flag[New_Surf_Face] = Surf_Reconnection_Flag[Surf_Face];

        for (Face_Node = 0; Face_Node < 4; ++Face_Node)
        {
          Surf_Quad_Connectivity[New_Surf_Quad][Face_Node] = Surf_Quad_Connectivity[Surf_Quad][Face_Node];
        }
      }
    }

    *Number_of_Surf_Trias = New_Surf_Tria;
    *Number_of_Surf_Quads = New_Surf_Quad;
  }

  for (Node = 1; Node <= *Number_of_Nodes; ++Node)
  {
    Map[Node] = 0;
  }

  if (Surf_Tria_Flag)
  {
    for (Surf_Tria = 1; Surf_Tria <= *Number_of_Surf_Trias; ++Surf_Tria)
    {
      for (Face_Node = 0; Face_Node < 3; ++Face_Node)
      {
        Node = Surf_Tria_Connectivity[Surf_Tria][Face_Node];

        Map[Node] = 1;
      }
    }

    New_Surf_Tria = *Number_of_Surf_Trias;
  }
  else
    New_Surf_Tria = 0;

  if (Surf_Quad_Flag)
  {
    for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
    {
      for (Face_Node = 0; Face_Node < 4; ++Face_Node)
      {
        Node = Surf_Quad_Connectivity[Surf_Quad][Face_Node];

        Map[Node] = 1;
      }
    }

    New_Surf_Quad = *Number_of_Surf_Quads;

    if (Surf_Tria_Flag == 0)
    {
      for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
      {
        if (Surf_Grid_BC_Flag)
          Surf_Grid_BC_Flag[Surf_Quad] = Surf_Grid_BC_Flag[*Number_of_Surf_Trias+Surf_Quad];

        if (Surf_ID_Flag)
          Surf_ID_Flag[Surf_Quad] = Surf_ID_Flag[*Number_of_Surf_Trias+Surf_Quad];

        if (Surf_Reconnection_Flag)
          Surf_Reconnection_Flag[Surf_Quad] = Surf_Reconnection_Flag[*Number_of_Surf_Trias+Surf_Quad];
      }
    }
  }
  else
    New_Surf_Quad = 0;

  *Number_of_Surf_Trias = New_Surf_Tria;
  *Number_of_Surf_Quads = New_Surf_Quad;

  New_Vol_Elem = 0;

  Vol_Elem = 0;

  if (Vol_Tet_Flag)
  {
    for (Vol_Tet = 1; Vol_Tet <= *Number_of_Vol_Tets; ++Vol_Tet)
    {
      ++New_Vol_Elem;

      ++Vol_Elem;

      for (Elem_Node = 0; Elem_Node < 4; ++Elem_Node)
      {
        Node = Vol_Tet_Connectivity[Vol_Tet][Elem_Node];

        Map[Node] = 1;
      }
    }

    Vol_Elem = *Number_of_Vol_Tets;
  }
  else
    *Number_of_Vol_Tets = 0;

  if (Vol_Pent_5_Flag)
  {
    for (Vol_Pent_5 = 1; Vol_Pent_5 <= *Number_of_Vol_Pents_5; ++Vol_Pent_5)
    {
      ++New_Vol_Elem;

      ++Vol_Elem;

      for (Elem_Node = 0; Elem_Node < 5; ++Elem_Node)
      {
        Node = Vol_Pent_5_Connectivity[Vol_Pent_5][Elem_Node];

        Map[Node] = 1;
      }

      if (Vol_ID_Flag)
        Vol_ID_Flag[New_Vol_Elem] = Vol_ID_Flag[Vol_Elem];
    }
  }
  else
    *Number_of_Vol_Pents_5 = 0;

  if (Vol_Pent_6_Flag)
  {
    for (Vol_Pent_6 = 1; Vol_Pent_6 <= *Number_of_Vol_Pents_6; ++Vol_Pent_6)
    {
      ++New_Vol_Elem;

      ++Vol_Elem;

      for (Elem_Node = 0; Elem_Node < 6; ++Elem_Node)
      {
        Node = Vol_Pent_6_Connectivity[Vol_Pent_6][Elem_Node];

        Map[Node] = 1;
      }

      if (Vol_ID_Flag)
        Vol_ID_Flag[New_Vol_Elem] = Vol_ID_Flag[Vol_Elem];
    }
  }
  else
    *Number_of_Vol_Pents_6 = 0;

  if (Vol_Hex_Flag)
  {
    for (Vol_Hex = 1; Vol_Hex <= *Number_of_Vol_Hexs; ++Vol_Hex)
    {
      ++New_Vol_Elem;

      ++Vol_Elem;

      for (Elem_Node = 0; Elem_Node < 8; ++Elem_Node)
      {
        Node = Vol_Hex_Connectivity[Vol_Hex][Elem_Node];

        Map[Node] = 1;
      }

      if (Vol_ID_Flag)
        Vol_ID_Flag[New_Vol_Elem] = Vol_ID_Flag[Vol_Elem];
    }
  }
  else
    *Number_of_Vol_Hexs = 0;

  New_Node = 0;

  for (Node = 1; Node <= *Number_of_Nodes; ++Node)
  {
    if (Map[Node])
    {
      ++New_Node;

      Map[Node] = New_Node;

      for (Dim = 0; Dim < 3; ++Dim)
      {
        Coordinates[New_Node][Dim] = Coordinates[Node][Dim];
      }

      if (Initial_Normal_Spacing)
        Initial_Normal_Spacing[New_Node] = Initial_Normal_Spacing[Node];

      if (BL_Thickness)
        BL_Thickness[New_Node] = BL_Thickness[Node];
    }
  }

  *Number_of_Nodes = New_Node;

  for (Surf_Tria = 1; Surf_Tria <= *Number_of_Surf_Trias; ++Surf_Tria)
  {
    for (Face_Node = 0; Face_Node < 3; ++Face_Node)
    {
      Node = Surf_Tria_Connectivity[Surf_Tria][Face_Node];

      Surf_Tria_Connectivity[Surf_Tria][Face_Node] = Map[Node];
    }
  }

  for (Surf_Quad = 1; Surf_Quad <= *Number_of_Surf_Quads; ++Surf_Quad)
  {
    for (Face_Node = 0; Face_Node < 4; ++Face_Node)
    {
      Node = Surf_Quad_Connectivity[Surf_Quad][Face_Node];

      Surf_Quad_Connectivity[Surf_Quad][Face_Node] = Map[Node];
    }
  }

  for (Vol_Tet = 1; Vol_Tet <= *Number_of_Vol_Tets; ++Vol_Tet)
  {
    for (Elem_Node = 0; Elem_Node < 4; ++Elem_Node)
    {
      Node = Vol_Tet_Connectivity[Vol_Tet][Elem_Node];

      Vol_Tet_Connectivity[Vol_Tet][Elem_Node] = Map[Node];
    }
  }

  for (Vol_Pent_5 = 1; Vol_Pent_5 <= *Number_of_Vol_Pents_5; ++Vol_Pent_5)
  {
    for (Elem_Node = 0; Elem_Node < 5; ++Elem_Node)
    {
      Node = Vol_Pent_5_Connectivity[Vol_Pent_5][Elem_Node];

      Vol_Pent_5_Connectivity[Vol_Pent_5][Elem_Node] = Map[Node];
    }
  }

  for (Vol_Pent_6 = 1; Vol_Pent_6 <= *Number_of_Vol_Pents_6; ++Vol_Pent_6)
  {
    for (Elem_Node = 0; Elem_Node < 6; ++Elem_Node)
    {
      Node = Vol_Pent_6_Connectivity[Vol_Pent_6][Elem_Node];

      Vol_Pent_6_Connectivity[Vol_Pent_6][Elem_Node] = Map[Node];
    }
  }

  for (Vol_Hex = 1; Vol_Hex <= *Number_of_Vol_Hexs; ++Vol_Hex)
  {
    for (Elem_Node = 0; Elem_Node < 8; ++Elem_Node)
    {
      Node = Vol_Hex_Connectivity[Vol_Hex][Elem_Node];

      Vol_Hex_Connectivity[Vol_Hex][Elem_Node] = Map[Node];
    }
  }

  ug_free (Map);

  return (0);

}
