#include "UG_IO_LIB.h"

INT_ ug_io_realloc_param
 (UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Realloc UG_IO parameter structure arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_realloc_param.c,v 1.4 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Max_File_Compressions, Max_File_Formats, Max_File_Modes, Max_File_Types;

  INT_ Error_Flag = 0;

  double c;
  double crealloc = 1.25;

  Max_File_Types = UG_IO_Param_Struct_Ptr->Max_File_Types;

  if (UG_IO_Param_Struct_Ptr->Number_of_File_Types > Max_File_Types)
  {
    c = crealloc * ((double) Max_File_Types);

    Max_File_Types = NINT (c);

    UG_IO_Param_Struct_Ptr->Max_File_Types = Max_File_Types;

    UG_IO_Param_Struct_Ptr->File_Data_Type = (INT_1D *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Data_Type,
                                          Max_File_Types * sizeof (INT_1D));
    UG_IO_Param_Struct_Ptr->File_Type_Format_Flag = (INT_1D *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Type_Format_Flag,
                                          Max_File_Types * sizeof (INT_1D));
    UG_IO_Param_Struct_Ptr->File_Type_Info = (CHAR_81 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Type_Info,
                                          Max_File_Types * sizeof (CHAR_81));
    UG_IO_Param_Struct_Ptr->File_Type_Doc = (char **)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Type_Doc,
                                          Max_File_Types * sizeof (char *));
    UG_IO_Param_Struct_Ptr->File_Type_Suffix = (CHAR_21 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Type_Suffix,
                                          Max_File_Types * sizeof (CHAR_21));
  }

  Max_File_Formats = UG_IO_Param_Struct_Ptr->Max_File_Formats;

  if (UG_IO_Param_Struct_Ptr->Number_of_File_Formats > Max_File_Formats)
  {
    c = crealloc * ((double) Max_File_Formats);

    Max_File_Formats = NINT (c);

    UG_IO_Param_Struct_Ptr->Max_File_Formats = Max_File_Formats;

    UG_IO_Param_Struct_Ptr->File_Format = (INT_1D *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Format,
                                          Max_File_Formats * sizeof (INT_1D));
    UG_IO_Param_Struct_Ptr->File_Format_Info = (CHAR_81 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Format_Info,
                                          Max_File_Formats * sizeof (CHAR_81));
    UG_IO_Param_Struct_Ptr->File_Format_Doc = (char **)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Format_Doc,
                                          Max_File_Formats * sizeof (char *));
    UG_IO_Param_Struct_Ptr->File_Format_Suffix = (CHAR_21 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Format_Suffix,
                                          Max_File_Formats * sizeof (CHAR_21));
  }

  Max_File_Modes = UG_IO_Param_Struct_Ptr->Max_File_Modes;

  if (UG_IO_Param_Struct_Ptr->Number_of_File_Modes > Max_File_Modes)
  {
    c = crealloc * ((double) Max_File_Modes);

    Max_File_Modes = NINT (c);

    UG_IO_Param_Struct_Ptr->Max_File_Formats = Max_File_Formats;

    UG_IO_Param_Struct_Ptr->File_Mode = (INT_1D *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Mode,
                                          Max_File_Modes * sizeof (INT_1D));
    UG_IO_Param_Struct_Ptr->File_Mode_Info = (CHAR_81 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Mode_Info,
                                          Max_File_Modes * sizeof (CHAR_81));
    UG_IO_Param_Struct_Ptr->File_Mode_Doc = (char **)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Mode_Doc,
                                          Max_File_Modes * sizeof (char *));
    UG_IO_Param_Struct_Ptr->File_Mode_Suffix = (CHAR_21 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Mode_Suffix,
                                          Max_File_Modes * sizeof (CHAR_21));
  }

  Max_File_Compressions = UG_IO_Param_Struct_Ptr->Max_File_Compressions;

  if (UG_IO_Param_Struct_Ptr->Number_of_File_Compressions > Max_File_Compressions)
  {
    c = crealloc * ((double) Max_File_Compressions);

    Max_File_Compressions = NINT (c);

    UG_IO_Param_Struct_Ptr->Max_File_Formats = Max_File_Formats;

    UG_IO_Param_Struct_Ptr->File_Compression_Info = (CHAR_81 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Compression_Info,
                                          Max_File_Compressions * sizeof (CHAR_81));
    UG_IO_Param_Struct_Ptr->File_Compression_Doc = (char **)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Compression_Doc,
                                          Max_File_Compressions * sizeof (char *));
    UG_IO_Param_Struct_Ptr->File_Compression_Suffix = (CHAR_21 *)
                                          ug_realloc (&Error_Flag,
                                          UG_IO_Param_Struct_Ptr->File_Compression_Suffix,
                                          Max_File_Compressions * sizeof (CHAR_21));
  }

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100614 : unable to reallocate space for UG_IO parameter structure ***");
    return (100614);
  }

  return (0);

}
