#include "UG_IO_LIB.h"

INT_ ug_io_read_tetgen
 (char Case_Name[],
  INT_ Read_Task_Flag,
  INT_ *Number_of_Nodes,
  INT_ *Number_of_Surf_Trias,
  INT_ *Number_of_Vol_Tets,
  INT_1D * Surf_ID_Flag,
  INT_3D * Surf_Tria_Connectivity,
  INT_4D * Vol_Tet_Connectivity,
  DOUBLE_3D * Coordinates)

{

/*
 * Read grid data from TetGen volume or surface grid files.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_read_tetgen.c,v 1.17 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Grid_File;

  CHAR_UG_MAX Grid_File_Name;

  INT_ Index, Read_Flag;

  int i0 = 0;
  int i1 = 0;
  int i2 = 0;
  int i3 = 0;
  int i4 = 0;

  strcpy (Grid_File_Name, "");
  strcat (Grid_File_Name, Case_Name);
  strcat (Grid_File_Name, ".node");

  Grid_File = ug_fopen (Grid_File_Name, "r");
  
  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR : unable to open TETGEN .node grid file ***");
    return (1);
  }

  Read_Flag = fscanf (Grid_File, "%i %i %i %i", &i1, &i2, &i3, &i4);

  *Number_of_Nodes = (INT_) i1;

  if (Read_Task_Flag == 2)
  {
    for (Index = 1; Index <= *Number_of_Nodes; ++Index)
    {
      Read_Flag = fscanf (Grid_File, "%i %lg %lg %lg",
                          &i0,
                          &Coordinates[Index][0],
                          &Coordinates[Index][1],
                          &Coordinates[Index][2]);

      if (Read_Flag != 4)
      {
        ug_error_message ("*** ERROR : error reading TETGEN .node grid file ***");
        return (1);
      }
    }
  }

  ug_fclose (Grid_File);

  strcpy (Grid_File_Name, "");
  strcat (Grid_File_Name, Case_Name);
  strcat (Grid_File_Name, ".ele");

  Grid_File = ug_fopen (Grid_File_Name, "r");
  
  if (Grid_File != NULL)
  {
    Read_Flag = fscanf (Grid_File, "%i %i %i", &i1, &i2, &i3);

    *Number_of_Vol_Tets = (INT_) i1;

    if (Read_Task_Flag == 2)
    {
      for (Index = 1; Index <= *Number_of_Vol_Tets; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%i %i %i %i %i", &i0, &i1, &i2, &i3, &i4);

        Vol_Tet_Connectivity[Index][0] = (INT_) i1;
        Vol_Tet_Connectivity[Index][1] = (INT_) i2;
        Vol_Tet_Connectivity[Index][2] = (INT_) i3;
        Vol_Tet_Connectivity[Index][3] = (INT_) i4;

        if (Read_Flag != 5)
        {
          ug_error_message ("*** ERROR : error reading TETGEN .ele grid file ***");
          return (1);
        }
      }
    }

    ug_fclose (Grid_File);
  }
  else
    *Number_of_Vol_Tets = 0;

  strcpy (Grid_File_Name, "");
  strcat (Grid_File_Name, Case_Name);
  strcat (Grid_File_Name, ".face");

  Grid_File = ug_fopen (Grid_File_Name, "r");
  
  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR : unable to open TETGEN .face grid file ***");
    return (1);
  }

  Read_Flag = fscanf (Grid_File, "%i %i", &i1, &i2);

  *Number_of_Surf_Trias = (INT_) i1;

  if (Read_Task_Flag == 2)
  {
    Index = 1;

    while (Index <= *Number_of_Surf_Trias && Read_Flag == 5)
    {
      Read_Flag = fscanf (Grid_File, "%i %i %i %i %i", &i0, &i1, &i2, &i3, &i4);

      Surf_Tria_Connectivity[Index][0] = (INT_) i1;
      Surf_Tria_Connectivity[Index][1] = (INT_) i2;
      Surf_Tria_Connectivity[Index][2] = (INT_) i3;

      if (Surf_ID_Flag != NULL)
        Surf_ID_Flag[Index] = (INT_) i4;

      ++Index;
    }

    ug_rewind (Grid_File);

    if (Read_Flag != 5)
    {
      Read_Flag = fscanf (Grid_File, "%i %i", &i1, &i2);

      for (Index = 1; Index <= *Number_of_Surf_Trias; ++Index)
      {
        Read_Flag = fscanf (Grid_File, "%i %i %i %i", &i0, &i1, &i2, &i3);

        Surf_Tria_Connectivity[Index][0] = (INT_) i1;
        Surf_Tria_Connectivity[Index][1] = (INT_) i2;
        Surf_Tria_Connectivity[Index][2] = (INT_) i3;

        if (Surf_ID_Flag != NULL)
          Surf_ID_Flag[Index] = 1;

        if (Read_Flag != 4)
        {
          ug_error_message ("*** ERROR : error reading TETGEN .face grid file ***");
          return (1);
        }
      }
    }
  }

  ug_fclose (Grid_File);

  return (0);

}
