#include "UG_IO_LIB.h"

INT_ ug_io_read_tags_file
 (int *argc,
  char ***argv,
  char Case_Name[],
  INT_ Message_Flag)

{

/*
 * Read surface grid BC and normal spacing data from a standard UG tags data
 * file.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_read_tags_file.c,v 1.33 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX File_Name, Label, Name_Text, Text;

  char *Text_;

  FILE * Tags_Data_File;

  INT_1D *BC_IDs = NULL;
  INT_1D *Number_of_BLs = NULL;
  INT_1D *Grid_BC_Flag = NULL;
  INT_1D *Rec_Flag = NULL;
  DOUBLE_1D *BL_Initial_Normal_Spacing = NULL;
  DOUBLE_1D *BL_Thickness = NULL;

  INT_ ierr, Length;

  int BC_BL_Flag, BC_Fixed_Flag, BC_ID_Index, BC_Rebuild_Flag, BC_Rec_Flag,
      BC_Source_Flag, BC_Transp_Flag, BC_Transp_Delete_Flag, Grid_BC_Flag_,
      Number_of_BC_IDs, Number_of_BLs_, Read_Flag, Surf_ID_Flag_;

  double BL_Initial_Normal_Spacing_, BL_Thickness_;

  strcpy (File_Name, Case_Name);
  strcat (File_Name, ".tags");

  Tags_Data_File = ug_fopen (File_Name, "r");

  if (Tags_Data_File == NULL)
    return (-1);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : INPUT TAGS DATA");
    ug_message (" ");
    ug_message ("UG_IO    : Reading Data");
    ug_message (" ");

    ug_cpu_message ("");

    strcpy (Name_Text, "");
    strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-32);

    snprintf (Text, sizeof(Text), "UG_IO    : TagsData File Name= %s", Name_Text);
    ug_message (Text);
  }

  BC_ID_Index = 0;

  do
  {
    Text_ = &Text[0];

    Text_ = fgets (Text_, (int) UG_MAX_CHAR_STRING_LENGTH, Tags_Data_File);

    if (Text_ != NULL)
    {
      Length = (INT_) strlen (Text_);

      if (Length > 1)
      {
        if (strncmp (Text_, "#", 1) != 0)
        {
          Read_Flag = sscanf (Text_, "%s %s %s %s %s %s %s %s %s %s %s %s",
                              Label, Label, Label, Label, Label, Label,
                              Label, Label, Label, Label, Label, Label);

          if (Read_Flag >= 10)
            ++BC_ID_Index;
        }
      }
    }
  }
  while (Text_ != NULL);

  if (BC_ID_Index == 0)
  {
    if (Message_Flag >= 1)
      ug_message ("UG_IO    : No Data Set");

    return (0);
  }

  Number_of_BC_IDs = BC_ID_Index;

  ug_rewind (Tags_Data_File);

  ierr = 0;

  BC_IDs = (INT_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (INT_1D));
  BL_Initial_Normal_Spacing = (DOUBLE_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (DOUBLE_1D));
  BL_Thickness = (DOUBLE_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (DOUBLE_1D));
  Grid_BC_Flag = (INT_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (INT_1D));
  Number_of_BLs = (INT_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (INT_1D));
  Rec_Flag = (INT_1D *) ug_malloc (&ierr, (Number_of_BC_IDs+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_free (BC_IDs);
    ug_free (BL_Initial_Normal_Spacing);
    ug_free (BL_Thickness);
    ug_free (Grid_BC_Flag);
    ug_free (Number_of_BLs);
    ug_free (Rec_Flag);
    ug_error_message ("*** ERROR 100600 : unable to allocate space for TAGS data ***");
    return (100600);
  }

  BC_ID_Index = 0;

  do
  {
    Text_ = &Text[0];

    Text_ = fgets (Text_, (int) UG_MAX_CHAR_STRING_LENGTH, Tags_Data_File);

    Read_Flag = 0;

    if (Text_ != NULL)
    {
      Length = (INT_) strlen (Text_);

      if (Length > 1)
      {
        if (strncmp (Text_, "#", 1) != 0)
          Read_Flag = 1;
      }
    }

    if (Read_Flag)
    {
      Read_Flag = sscanf (Text_, "%s %s %s %s %s %s %s %s %s %s %s %s",
                          Label, Label, Label, Label, Label, Label,
                          Label, Label, Label, Label, Label, Label);

      if (Read_Flag == 12)
        Read_Flag = sscanf (Text_, "%i %s %i %i %i %i %i %i %i %lg %lg %i",
                            &Surf_ID_Flag_, Label,
                            &BC_BL_Flag, &BC_Rec_Flag, &BC_Rebuild_Flag,
                            &BC_Fixed_Flag, &BC_Source_Flag, &BC_Transp_Flag,
                            &BC_Transp_Delete_Flag,
                            &BL_Initial_Normal_Spacing_, &BL_Thickness_,
                            &Number_of_BLs_);

      else if (Read_Flag == 11)
      {
        Read_Flag = sscanf (Text_, "%i %s %i %i %i %i %i %i %i %lg %lg",
                            &Surf_ID_Flag_, Label,
                            &BC_BL_Flag, &BC_Rec_Flag, &BC_Rebuild_Flag,
                            &BC_Fixed_Flag, &BC_Source_Flag, &BC_Transp_Flag,
                            &BC_Transp_Delete_Flag,
                            &BL_Initial_Normal_Spacing_, &BL_Thickness_);

        Number_of_BLs_ = 0;

        Read_Flag = Read_Flag + 1;
      }

      else if (Read_Flag == 10)
      {
        Read_Flag = sscanf (Text_, "%i %s %i %i %i %i %i %i %lg %lg",
                            &Surf_ID_Flag_, Label,
                            &BC_BL_Flag, &BC_Rec_Flag, &BC_Rebuild_Flag,
                            &BC_Source_Flag, &BC_Transp_Flag,
                            &BC_Transp_Delete_Flag,
                            &BL_Initial_Normal_Spacing_, &BL_Thickness_);

        BC_Fixed_Flag = (BC_Rec_Flag == 0 && BC_Rebuild_Flag == 1) ? 1: 0;

        Number_of_BLs_ = 0;

        Read_Flag = Read_Flag + 2;
      }

      if (Read_Flag != 12)
      {
        ug_free (BC_IDs);
        ug_free (BL_Initial_Normal_Spacing);
        ug_free (BL_Thickness);
        ug_free (Grid_BC_Flag);
        ug_free (Number_of_BLs);
        ug_free (Rec_Flag);
        ug_error_message ("*** ERROR 638 : error reading TAGS data file ***");
        return (638);
      }

      Grid_BC_Flag_ = (BC_Transp_Delete_Flag) ? TRANSP_INTRNL_UG3_GBC:
                      (BC_Transp_Flag && ! BC_Rebuild_Flag) ? TRANSP_UG3_GBC:
                      (BC_Transp_Flag && BC_Rebuild_Flag) ? TRANSP_BL_INT_UG3_GBC:
                      (BC_Source_Flag) ? TRANSP_SRC_UG3_GBC:
                      (BC_Fixed_Flag) ? FIXED_BL_INT_UG3_GBC:
                      (BC_Rebuild_Flag) ? BL_INT_UG3_GBC: STD_UG3_GBC;

      if (BC_BL_Flag)
        Grid_BC_Flag_ = -Grid_BC_Flag_;

      BC_IDs[BC_ID_Index] = Surf_ID_Flag_;
      BL_Initial_Normal_Spacing[BC_ID_Index] = BL_Initial_Normal_Spacing_;
      BL_Thickness[BC_ID_Index] = BL_Thickness_;
      Grid_BC_Flag[BC_ID_Index] = Grid_BC_Flag_;
      Number_of_BLs[BC_ID_Index] = Number_of_BLs_;
      Rec_Flag[BC_ID_Index] = (BC_Rec_Flag == 1) ? 0: 7;

      ++BC_ID_Index;

      if (Message_Flag >= 1)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : Data Set For ID   =%10i", Surf_ID_Flag_);
        ug_message (Text);
      }
    }
  }
  while (Text_ != NULL);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("BC_IDs", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (Number_of_BC_IDs, BC_IDs, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("BL_DS", argc, argv);

  if (ierr == 0)
    ierr = ug_add_double_vector_arg (Number_of_BC_IDs, BL_Initial_Normal_Spacing, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("BL_DEL", argc, argv);

  if (ierr == 0)
    ierr = ug_add_double_vector_arg (Number_of_BC_IDs, BL_Thickness, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("Number_of_BLs", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (Number_of_BC_IDs, Number_of_BLs, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("Grid_BC_Flag", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (Number_of_BC_IDs, Grid_BC_Flag, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("Rec_Flag", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (Number_of_BC_IDs, Rec_Flag, argc, argv);

  ug_free (BC_IDs);
  ug_free (BL_Initial_Normal_Spacing);
  ug_free (BL_Thickness);
  ug_free (Grid_BC_Flag);
  ug_free (Number_of_BLs);
  ug_free (Rec_Flag);

  if (ierr)
    return (ierr);

  ierr = ug_fclose (Tags_Data_File);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  return (0);

}
