#include "UG_IO_LIB.h"

INT_ ug_io_read_snsdata_file
 (int *argc,
  char ***argv,
  char Case_Name[],
  INT_ Message_Flag)

{

/*
 * Set specified normal spacing (SNS) data for generation of SNS region from an
 * SNS data file.
 *
 * ANBL : ADVANCING-NORMAL BOUNDARY-LAYER UNSTRUCTURED GRID GENERATOR
 * 3D Version : $Id: ug_io_read_snsdata_file.c,v 1.23 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *snsdata_File;

  char *Read_Label;

  CHAR_UG_MAX Line, File_Name, Name_Text, Text;

  INT_ *idig = NULL;

  DOUBLE_1D *sns = NULL;

  INT_ ierr, nidig_, nsns_;

  int EOF_Flag = 0;
  int i = 0;
  int id = 0;
  int idmax = 0;
  int ig = 0;
  int isns = 0;
  int j = 0;
  int jd = 0;
  int jg = 0;
  int k = 0;
  int nid = 0;
  int nidi = 0;
  int nidig = 0;
  int nsns = 0;
  int nsnsi = 0;
  int Read_Flag = 0;

  strcpy (File_Name, Case_Name);
  strcat (File_Name, ".snsdata");

  snsdata_File = ug_fopen (File_Name, "r");

  if (snsdata_File == NULL)
    return (-1);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : READ SPECIFIED NORMAL SPACING DATA");
    ug_message (" ");
    ug_message ("UG_IO    : Reading Data");
    ug_message (" ");

    ug_cpu_message ("");

    strcpy (Name_Text, "");
    strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-32);

    snprintf (Text, sizeof(Text), "UG_IO    : SNS Data File Name= %s", Name_Text);
    ug_message (Text);
  }

//       x       x       x       x       x       x       x       x       x
//       ig      nids    id_1    id_2    ....    id_nids
//       nsns_ig sns_1   sns_2   ...     sns_nsns_ig

  ierr = 0;

  ig = 0;

  nsns = 0;

  nidig = 0;

  do
  {
    nidi = 0;

    Read_Flag = fscanf (snsdata_File, "%i %i", &jg, &nidi);

    if (Read_Flag <= 0)
      Read_Label = fgets (Line, UG_MAX_CHAR_STRING_LENGTH, snsdata_File);
    else if (Read_Flag != 2)
    {
      ug_free (idig);
      ug_free (sns);
      ug_error_message ("*** ERROR 631 : error reading SNS data file ***");
      return (631);
    }
    else
      ++ig;

    if (nidi > 0)
    {
      idig = (INT_ *) ug_realloc (&ierr, idig, (nidig+1+nidi) * sizeof (INT_));

      if (ierr)
      {
        ug_free (idig);
        ug_free (sns);
        ug_error_message ("*** ERROR 100617 : unable to allocate space for SNS data ***");
        return (100617);
      }

      idig[nidig] = (INT_) nidi;

      Read_Flag = 0;

      for (i = nidig+1; i < nidig+1+nidi; ++i)
      {
        Read_Flag = Read_Flag + fscanf (snsdata_File, "%i", &id);

        idig[i] = (INT_) id;
      }

      if (Read_Flag != nidi)
      {
        ug_free (idig);
        ug_free (sns);
        ug_error_message ("*** ERROR 631 : error reading SNS data file ***");
        return (631);
      }

      nidig = nidig + nidi+ 1;

      Read_Flag = 0;

      Read_Flag = Read_Flag + fscanf (snsdata_File, "%i", &nsnsi);

      if (Read_Flag != 1)
      {
        ug_free (idig);
        ug_free (sns);
        ug_error_message ("*** ERROR 631 : error reading SNS data file ***");
        return (631);
      }

      sns = (DOUBLE_1D *) ug_realloc (&ierr, sns,
                                      (nsns+nsnsi) * sizeof (DOUBLE_1D));

      if (ierr)
      {
        ug_free (idig);
        ug_free (sns);
        ug_error_message ("*** ERROR 100616 : unable to allocate space for SNS data ***");
        return (100616);
      }

      Read_Flag = 0;

      for (isns = nsns; isns < nsns+nsnsi; ++isns)
      {
        Read_Flag = Read_Flag + fscanf (snsdata_File, "%lg", &(sns[isns]));
      }

      if (Read_Flag != nsnsi)
      {
        ug_free (idig);
        ug_free (sns);
        ug_error_message ("*** ERROR 631 : error reading SNS data file ***");
        return (631);
      }

      nsns = nsns + nsnsi;

      if (Message_Flag >= 1)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : SNS_IDs#%-10i= %-10i", ig, (int) idig[nidig-nidi]);
        ug_message (Text);

        for (i = nidig-nidi+1; i < nidig; ++i)
        {
          snprintf (Text, sizeof(Text), "UG_IO    :                   = %-10i", (int) idig[i]);
          ug_message (Text);
        }

        snprintf (Text, sizeof(Text), "UG_IO    : SNS#%-10i    = %g", ig, sns[nsns-nsnsi]);
        ug_message (Text);

        for (isns = nsns-nsnsi+1; isns < nsns; ++isns)
        {
          snprintf (Text, sizeof(Text), "UG_IO    :                   = %g", sns[isns]);
          ug_message (Text);
        }
      }
    }

    EOF_Flag = feof (snsdata_File);
  }
  while (EOF_Flag == 0);

  ug_fclose (snsdata_File);

  if (ig == 0 || nidig == 0)
  {
    ug_free (idig);
    ug_free (sns);
    ug_error_message ("*** ERROR 632 : SNS data file contains no readable data ***");
    return (632);
  }

  nidig_ = (INT_) nidig;
  nsns_ = (INT_) nsns;

  if (ierr == 0)
    ierr = ug_add_flag_arg ("SNS_IDs", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (nidig_, idig, argc, argv);

  if (ierr == 0)
  {
    k = 0;

    j = 0;

    nidi = 0;

    for (i = 0; i < nidig; ++i)
    {
      if (k == nidi)
      {
        nidi = (int) idig[i];

        k = 0;

        nid = nid + nidi;
      }
      else
      {
        idig[j] = idig[i];

        ++j;

        ++k;
      }
    }

    nid = j;

    idmax = (int) idig[0];

    for (i = 1; i < nid; ++i)
    {
      id = (int) idig[i];

      idmax = MAX (idmax, id);
    }

    for (j = 0; j < nid; ++j)
    {
      jd = (int) idig[j];

      for (i = j+1; i < nid; ++i)
      {
        id = (int) idig[i];

        if (id == jd)
          idig[i] = (INT_) (idmax+1);
      }
    }

    j = 0;

    for (i = 0; i < nid; ++i)
    {
      id = (int) idig[i];

      if (id <= idmax)
      {
        idig[j] = (INT_) id;

        ++j;
      }
    }

    nid = j;

    if (nid > 0)
    {
      if (Message_Flag >= 1)
      {
        snprintf (Text, sizeof(Text), "UG_IO    : BL_IDs            = %-10i", (int) idig[0]);
        ug_message (Text);

        for (i = 1; i < nid; ++i)
        {
          snprintf (Text, sizeof(Text), "UG_IO    :                   = %-10i", (int) idig[i]);
          ug_message (Text);
        }
      }

      if (ierr == 0)
        ierr = ug_add_flag_arg ("BL_IDs", argc, argv);

      if (ierr == 0)
        ierr = ug_add_int_vector_arg (nidig_, idig, argc, argv);
    }
  }

  if (ierr == 0)
    ierr = ug_add_flag_arg ("SNS", argc, argv);

  if (ierr == 0)
    ierr = ug_add_double_vector_arg (nsns_, sns, argc, argv);

  ug_free (idig);
  ug_free (sns);

  if (ierr)
    return (ierr);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  return (0);

}
