#include "UG_IO_LIB.h"

INT_ ug_io_read_psdata_file
 (int *argc,
  char ***argv,
  char Case_Name[],
  INT_ Message_Flag)

{

/*
 * Set surface IDs and transformation data for periodic surfaces that intersect
 * the BL region from specified periodic surface data file.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_read_psdata_file.c,v 1.24 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *psdata_File;

  char *Read_Label;

  CHAR_UG_MAX Line, File_Name, Name_Text, Text;

  INT_2D *idips = NULL;

  DOUBLE_3X3 *tm = NULL;
  DOUBLE_3D *xps0 = NULL;

  INT_ EOF_Flag, ierr, ipsurf, npsurf, Number_of_Items,
       Read_Flag;
  INT_ nalloc = 10;
  INT_ npsurfd = 0;
  int i0 = 0;
  int i1 = 0;
  int i2 = 0;

  strcpy (File_Name, Case_Name);
  strcat (File_Name, ".psdata");

  psdata_File = ug_fopen (File_Name, "r");

  if (psdata_File == NULL)
    return (-1);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG_IO    : READ PERIODIC SURFACE DATA");
    ug_message (" ");
    ug_message ("UG_IO    : Reading Data");
    ug_message (" ");

    ug_cpu_message ("");

    strcpy (Name_Text, "");
    strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-32);

    snprintf (Text, sizeof(Text), "UG_IO    : PS Data File Name = %s", Name_Text);
    ug_message (Text);
  }

//ipsurf	id1	id2	xps01	xps02	xps03
//				tm11	tm12	tm13
//				tm21	tm22	tm23
//				tm31	tm32	tm33

  ierr = 0;

  ipsurf = -1;

  do
  {
    ++ipsurf;

    npsurf = ipsurf+1;

    if (npsurf > npsurfd)
    {
      npsurfd = npsurfd + nalloc;

      idips = (INT_2D *) ug_realloc (&ierr, idips,
                                     npsurfd * sizeof (INT_2D));
      tm = (DOUBLE_3X3 *) ug_realloc (&ierr, tm,
                                      npsurfd * sizeof (DOUBLE_3X3));
      xps0 = (DOUBLE_3D *) ug_realloc (&ierr, xps0,
                                      npsurfd * sizeof (DOUBLE_3D));

      if (ierr)
      {
        ug_free (idips);
        ug_free (tm);
        ug_free (xps0);
        ug_error_message ("*** ERROR 100618 : unable to allocate space for PS data ***");
        return (100618);
      }
    }

    Number_of_Items = 15;

    Read_Flag = fscanf (psdata_File,
                        "%i %i %i %lg %lg %lg %lg %lg %lg %lg %lg %lg %lg %lg %lg",
                        &i0, &i1, &i2,
                        &(xps0[ipsurf][0]), &(xps0[ipsurf][1]), &(xps0[ipsurf][2]),
                        &(tm[ipsurf][0][0]), &(tm[ipsurf][0][1]), &(tm[ipsurf][0][2]),
                        &(tm[ipsurf][1][0]), &(tm[ipsurf][1][1]), &(tm[ipsurf][1][2]),
                        &(tm[ipsurf][2][0]), &(tm[ipsurf][2][1]), &(tm[ipsurf][2][2]));

    idips[ipsurf][0] = (INT_) i1;
    idips[ipsurf][1] = (INT_) i2;

    if (Read_Flag <= 0)
    {
      --ipsurf;

      npsurf = ipsurf+1;

      Read_Label = fgets (Line, UG_MAX_CHAR_STRING_LENGTH, psdata_File);
    }
    else if (Read_Flag != Number_of_Items)
    {
      ug_free (idips);
      ug_free (tm);
      ug_free (xps0);
      ug_error_message ("*** ERROR 630 : error reading PS data file ***");
      return (630);
    }

    EOF_Flag = feof (psdata_File);
  }
  while (EOF_Flag == 0);

  ug_fclose (psdata_File);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("npsurf", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_arg (npsurf, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("PS_IDs", argc, argv);

  if (ierr == 0)
    ierr = ug_add_int_vector_arg (2*npsurf, (INT_1D *) idips, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("PS_TMs", argc, argv);

  if (ierr == 0)
    ierr = ug_add_double_vector_arg (9*npsurf, (DOUBLE_1D *) tm, argc, argv);

  if (ierr == 0)
    ierr = ug_add_flag_arg ("PS_XPS0s", argc, argv);

  if (ierr == 0)
    ierr = ug_add_double_vector_arg (3*npsurf, (DOUBLE_1D *) xps0, argc, argv);

  if (ierr == 0 && Message_Flag >= 1)
  {
    snprintf (Text, sizeof(Text), "UG_IO    : npsurf            = %-10i", (int) npsurf);
    ug_message (Text);

    for (ipsurf = 0; ipsurf < npsurf; ++ipsurf)
    {
      snprintf (Text, sizeof(Text), "UG_IO    : PS_IDs#%-10i = %-10i",
               (int) (ipsurf+1), (int) idips[ipsurf][0]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %-10i",
               (int) idips[ipsurf][1]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    : PS_TMs#%-10i = %g",
               (int) (ipsurf+1), tm[ipsurf][0][0]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][0][1]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][0][2]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][1][0]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][1][1]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][1][2]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][2][0]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][2][1]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               tm[ipsurf][2][2]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    : PS_XPS0s#%-9i= %g",
               (int) (ipsurf+1), xps0[ipsurf][0]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               xps0[ipsurf][1]);
      ug_message (Text);

      snprintf (Text, sizeof(Text), "UG_IO    :                   = %g",
               xps0[ipsurf][2]);
      ug_message (Text);
    }
  }

  ug_free (idips);
  ug_free (tm);
  ug_free (xps0);

  if (ierr)
    return (ierr);

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_cpu_message ("UG_IO    :");
  }

  return (0);

}
