#include "UG_IO_LIB.h"

INT_ ug_io_read_node
 (FILE * Node_Data_File,
  INT_ File_Type_Flag,
  INT_ Read_Task_Flag,
  INT_ *Number_of_Nodes,
  DOUBLE_3D * Coordinates,
  DOUBLE_1D * Spacing,
  DOUBLE_6D * Metric)

{

/*
 * Read data from a 3D MNODE metric source node or a SNODE source node data
 * file.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_read_node.c,v 1.19 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */


  CHAR_UG_MAX Text;

  char *Text_;

  INT_ Index, Length, Node_Index, Number_of_Read_Items, Read_Flag;

  double dc0, dc1, dc1d6, dc6, dc10, 
         det, det_Max, det_Min, det_Tol,
         M0, M1, M2, M3, M4, M5, 
         Spacing_, Spacing_Max, Spacing_Min, Spacing_Tol,
         Tol, X, Y, Z;

  dc0 = 0.0;
  dc1 = 1.0;
  dc6 = 6.0;
  dc10 = 10.0;
  dc1d6 = dc1 / dc6;

  ug_round_off_error (&Tol);

  Tol = dc10 * Tol;

  if (Read_Task_Flag == 1)
  {
    *Number_of_Nodes = 0;

    do
    {
      Index = 0;

      do
      {
        Length = 0;

        Text_ = &Text[0];

        Text_ = fgets (Text_, (int) UG_MAX_CHAR_STRING_LENGTH, Node_Data_File);

        if (Text_)
        {
          Length = (INT_) strlen (Text_);

          if (Length != 1)
          {
            if (strncmp (Text_, "#", 1) != 0)
              ++Index;
          }
        }
      }
      while (Length > 1 && Text_);

      if (Index > 0)
        *Number_of_Nodes = *Number_of_Nodes + Index;
    }
    while (Text_);

    if (*Number_of_Nodes == 0)
    {
      if (File_Type_Flag == 1)
        ug_error_message ("*** ERROR : no nodes in 3D SNODE source node data file ***");
      else
        ug_error_message ("*** ERROR : no nodes in 3D MNODE metric node data file ***");
      return (1);
    }
  }

  else if (Read_Task_Flag == 2)
  {
    Number_of_Read_Items = (File_Type_Flag == 1) ? 4: 9;

    Node_Index = 0;

    Read_Flag = 1;

    do
    {
      Index = 0;

      do
      {
        Length = 0;

        Text_ = &Text[0];

        Text_ = fgets (Text_, (int) UG_MAX_CHAR_STRING_LENGTH, Node_Data_File);

        if (Text_)
        {
          Length = (INT_) strlen (Text_);

          if (Length != 1)
          {
            if (strncmp (Text_, "#", 1) != 0)
            {
              ++Index;

              ++Node_Index;

              if (File_Type_Flag == 1)
                Read_Flag = sscanf (Text_, "%lg %lg %lg %lg",
                                    &X, &Y, &Z, &Spacing_);
              else
                Read_Flag = sscanf (Text_, "%lg %lg %lg %lg %lg %lg %lg %lg %lg",
                                    &X, &Y, &Z, &M0, &M1, &M2, &M3, &M4, &M5);

              if (Read_Flag != Number_of_Read_Items)
                Read_Flag = 0;

              if (Read_Flag && Node_Index <= *Number_of_Nodes)
              {
                Coordinates[Node_Index][0] = X;
                Coordinates[Node_Index][1] = Y;
                Coordinates[Node_Index][2] = Z;

                if (File_Type_Flag == 1 && Spacing)
                  Spacing[Node_Index] = Spacing_;
                else if (File_Type_Flag == 2 && Metric)
                {
                  Metric[Node_Index][0] = M0;
                  Metric[Node_Index][1] = M1;
                  Metric[Node_Index][2] = M2;
                  Metric[Node_Index][3] = M3;
                  Metric[Node_Index][4] = M4;
                  Metric[Node_Index][5] = M5;
                }
              }
            }
          }
        }
      }
      while (Read_Flag != 0 && Length > 1 && Text_);
    }
    while (Read_Flag != 0 && Text_);

    if (Node_Index != *Number_of_Nodes)
    {
      if (File_Type_Flag == 1)
        ug_error_message ("*** ERROR : error reading 3D SNODE source node data file ***");
      else
        ug_error_message ("*** ERROR : error reading 3D MNODE metric source node data file ***");
      return (1);
    }

    if (File_Type_Flag == 1 && Spacing)
    {
      Node_Index = 1;

      Spacing_ = fabs (Spacing[Node_Index]);

      Spacing_Max = Spacing_;
      Spacing_Min = Spacing_;

      for (Node_Index = 2; Node_Index <= *Number_of_Nodes; ++Node_Index)
      {
        Spacing_ = fabs (Spacing[Node_Index]);

        Spacing_Max = MAX (Spacing_Max, Spacing_);
        Spacing_Min = MIN (Spacing_Min, Spacing_);
      }

      Spacing_Tol = Tol * Spacing_Max;

      if (Spacing_Min < Spacing_Tol || Spacing_Max == dc0)
      {
        ug_error_message ("*** ERROR : zero or near zero spacing function read ***");
        return (1);
      }
    }

    else if (File_Type_Flag == 2 && Metric)
    {
      for (Node_Index = 1; Node_Index <= *Number_of_Nodes; ++Node_Index)
      {
        M0 = Metric[Node_Index][0];
        M1 = Metric[Node_Index][1];
        M2 = Metric[Node_Index][2];
        M3 = Metric[Node_Index][3];
        M4 = Metric[Node_Index][4];
        M5 = Metric[Node_Index][5];

        det = M0 * (M3 * M5 - M4 * M4) 
            - M1 * (M1 * M5 - M2 * M4) 
            + M2 * (M1 * M4 - M2 * M3);

        if (Node_Index == 1)
        {
          det_Max = det;
          det_Min = det;
        }
        else
        {
          det_Max = MAX (det_Max, det);
          det_Min = MIN (det_Min, det);
        }

        if (Spacing)
          Spacing[Node_Index] = pow (det, -dc1d6);
      }

      det_Tol = Tol * det_Max;

      if (det_Min < det_Tol || det_Max <= dc0)
      {
        ug_error_message ("*** ERROR : zero, near zero, or negative metric determinant calculated ***");
        return (1);
      }
    }
  }

  return (0);

}
