#include "UG_IO_LIB.h"

INT_ ug_io_read_bg_data (char BG_Case_Name[],
                         INT_ mmsg,
                         INT_ mmet,
                         INT_ *nelbg,
                         INT_ *nnbg,
                         INT_4D ** ielielbg,
                         INT_4D ** inielbg,
                         DOUBLE_1D ** dfbg,
                         DOUBLE_6D ** metbg,
                         DOUBLE_3D ** xbg)
{

/*
 * Read background grid and function data.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_read_bg_data.c,v 1.10 2025/07/08 06:37:32 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX BG_Grid_File_Name;
  CHAR_UG_MAX BG_Func_File_Name;

  CHAR_21 *usca_labels = NULL;
  CHAR_21 *uvec_labels = NULL;
  CHAR_21 *umat_labels = NULL;
  CHAR_21 *umet_labels = NULL;

  INT_1D *idibe = NULL;
  INT_1D *ibcibf = NULL;
  INT_1D *idibf = NULL;
  INT_1D *irfibf = NULL;
  INT_1D *idiel = NULL;
  INT_2D *inibe = NULL;
  INT_3D *inibf = NULL;
  INT_4D *iniq = NULL;
  INT_5D *inielc5 = NULL;
  INT_6D *inielc6 = NULL;
  INT_8D *inielc8 = NULL;

  DOUBLE_1D *ds = NULL;
  DOUBLE_1D *del = NULL;
  DOUBLE_1D *uvec = NULL;
  DOUBLE_1D *umat = NULL;

  INT_ ierr = 0;
  INT_ inode;
  INT_ mmetbg = 0;
  INT_ nbedge = 0;
  INT_ nblelem = 0;
  INT_ nquad = 0;
  INT_ nbface = 0;
  INT_ nelemc8 = 0;
  INT_ nelemc5 = 0;
  INT_ nelemc6 = 0;
  INT_ nunode = 0;
  INT_ nusca = 0;
  INT_ nuvec = 0;
  INT_ numat = 0;
  INT_ numet = 0;

  double dc1, dc6, dc1d6, det;
  
  dc1 = 1.0;
  dc6 = 6.0;

  dc1d6 = dc1 / dc6;

  // initialize data

  *nelbg = 0;
  *nnbg = 0;

  *ielielbg = NULL;
  *inielbg = NULL;

  *xbg = NULL;
  *dfbg = NULL;
  *metbg = NULL;

  // check for and set a BGDATA type background grid and function data file name

  strcpy (BG_Grid_File_Name, "");
  strcpy (BG_Func_File_Name, "");

  ierr = ug3_check_bgdata_file (BG_Case_Name, BG_Grid_File_Name);

  // read background grid and function data from a BGDATA type file

  if (ierr == 0)
  {
    ierr = ug3_read_bgdata_file (BG_Case_Name, mmsg, &mmetbg, nelbg, nnbg,
                                 ielielbg, inielbg, dfbg, metbg, xbg);

    if (ierr)
      return (ierr);

    if (mmet && mmetbg == 0)
    {
      ug_error_message ("*** ERROR 640 : no metric data in BGDATA file ***");
      return (640);
    }

    return (0);
  }

  // check for and set UG_IO type background grid and function data file names

  strcat (BG_Case_Name, ".back");
  strcpy (BG_Grid_File_Name, "");

  ierr = ug_io_find_file (BG_Case_Name, BG_Grid_File_Name, UG_IO_VOLUME_GRID);

  if (ierr == 0)
    ierr = ug_io_find_file (BG_Case_Name, BG_Func_File_Name, UG_IO_FUNCTION_DATA);

  if (ierr == 0)
  {
    ierr = ug_file_format_check (BG_Grid_File_Name);
    ierr = ug_file_format_check (BG_Func_File_Name);
  }

  if (ierr)
    return (ierr);

  // read background grid and function data from standard UG_IO type files

  ierr = ug_io_read_grid_file (BG_Grid_File_Name,
                               mmsg, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                               &nblelem, nnbg, &nbedge, &nquad, &nbface,
                               &nelemc8, &nelemc5, &nelemc6, nelbg,
                               &idibe, &inibe,
                               &ibcibf, &idibf, &irfibf, &iniq, &inibf,
                               &inielc8, &idiel, &inielc5, &inielc6, inielbg,
                               xbg, &ds, &del);

  ug_io_free_grid (idibe, inibe, ibcibf, idibf, irfibf, iniq, inibf,
                   inielc8, idiel, inielc5, inielc6, NULL,
                   NULL, ds, del);

  if (nelemc8 || nelemc5 || nelemc6)
  {
    ug_error_message ("*** ERROR 641 : background grid file may not contain hex, prism or pyramid elements ***");
    return (641);
  }

  ierr = ug_io_read_func_file (BG_Func_File_Name,
                               mmsg, 3, &nunode, &nusca, &nuvec, &numat, &numet,
                               &usca_labels, &uvec_labels, &umat_labels,
                               &umet_labels,
                               dfbg, &uvec, &umat, (DOUBLE_1D **) metbg);

  ug_io_free_func_flag (usca_labels, uvec_labels, umat_labels, umet_labels);

  ug_free (uvec);
  ug_free (umat);

  if (ierr)
    return (ierr);

  if (nunode != *nnbg)
  {
    ug_error_message ("*** ERROR 642 : background function and grid file contain differing number of nodes ***");
    return (642);
  }

  if (nusca > 1 || nuvec || numat || numet > 1)
  {
    ug_error_message ("*** ERROR 643 : background function file must only contain spacing and/or metric ***");
    return (643);
  }

  if (mmet && numet == 0)
  {
    ug_error_message ("*** ERROR 644 : no metric data in BG function data file ***");
    return (644);
  }

  if (nusca == 0 && numet == 1)
  {
    *dfbg = (DOUBLE_1D *) ug_malloc (&ierr, ((*nnbg)+1) * sizeof (DOUBLE_1D));

    if (ierr)
    {
      ug_error_message ("*** ERROR 100601 : unable to allocate required memory ***");

      ierr = 100601;
    }
  
    for (inode = 1; inode <= *nnbg; ++inode)
    {
      det = (*metbg)[inode][0] * ((*metbg)[inode][3] * (*metbg)[inode][5]
                                - (*metbg)[inode][4] * (*metbg)[inode][4]) 
          - (*metbg)[inode][1] * ((*metbg)[inode][1] * (*metbg)[inode][5]
                                - (*metbg)[inode][2] * (*metbg)[inode][4]) 
          + (*metbg)[inode][2] * ((*metbg)[inode][1] * (*metbg)[inode][4]
                                - (*metbg)[inode][2] * (*metbg)[inode][3]);
 
      (*dfbg)[inode] = pow (det, -dc1d6);
    }
  }

  return (0);
}
