#include "UG_IO_LIB.h"

INT_ ug_io_malloc_node
 (INT_ M_Spacing,
  INT_ M_Metric,
  INT_ Number_of_Nodes,
  DOUBLE_3D ** Coordinates,
  DOUBLE_1D ** Spacing,
  DOUBLE_6D ** Metric)

{

/*
 * Malloc node data arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_malloc_node.c,v 1.10 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag;

  Error_Flag = 0;

  *Coordinates = (DOUBLE_3D *) ug_malloc (&Error_Flag,
                                          (Number_of_Nodes+1)
                                        * sizeof (DOUBLE_3D));

  if (M_Spacing == 1)
    *Spacing = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));
  else
    *Spacing = NULL;

  if (M_Metric == 1)
    *Metric = (DOUBLE_6D *) ug_malloc (&Error_Flag,
                                        (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_6D));
  else
    *Metric = NULL;

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100610 : unable to malloc node data arrays ***");
    return (100610);
  }

  return (0);

}
