#include "UG_IO_LIB.h"

INT_ ug_io_malloc_func_flag
 (INT_ Number_of_U_Scalars,
  INT_ Number_of_U_Vectors,
  INT_ Number_of_U_Matrixes,
  INT_ Number_of_U_Metrics,
  CHAR_21 ** U_Scalar_Labels,
  CHAR_21 ** U_Vector_Labels,
  CHAR_21 ** U_Matrix_Labels,
  CHAR_21 ** U_Metric_Labels)

{

/*
 * Malloc function label and flag arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_malloc_func_flag.c,v 1.10 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag;

  Error_Flag = 0;

  *U_Scalar_Labels = (CHAR_21 *) ug_malloc (&Error_Flag,
                                            Number_of_U_Scalars
                                          * sizeof (CHAR_21));
  *U_Vector_Labels = (CHAR_21 *) ug_malloc (&Error_Flag,
                                            Number_of_U_Vectors
                                          * sizeof (CHAR_21));
  *U_Matrix_Labels = (CHAR_21 *) ug_malloc (&Error_Flag,
                                            Number_of_U_Matrixes
                                          * sizeof (CHAR_21));
  *U_Metric_Labels = (CHAR_21 *) ug_malloc (&Error_Flag,
                                            Number_of_U_Metrics
                                          * sizeof (CHAR_21));

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100608 : unable to malloc function label and flag arrays ***");
    return (100608);
  }

  return (0);

}
