#include "UG_IO_LIB.h"

INT_ ug_io_malloc_func
 (INT_ NDim,
  INT_ Number_of_Nodes,
  INT_ Number_of_U_Scalars,
  INT_ Number_of_U_Vectors,
  INT_ Number_of_U_Matrixes,
  INT_ Number_of_U_Metrics,
  DOUBLE_1D ** U_Scalars,
  DOUBLE_1D ** U_Vectors,
  DOUBLE_1D ** U_Matrixes,
  DOUBLE_1D ** U_Metrics)

{

/*
 * Malloc function data arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_malloc_func.c,v 1.14 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag = 0;

  *U_Scalars = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        Number_of_U_Scalars
                                      * (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));
  *U_Vectors = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        Number_of_U_Vectors
                                      * NDim * (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));
  *U_Matrixes = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        Number_of_U_Matrixes
                                      * NDim*NDim * (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));
  *U_Metrics = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        Number_of_U_Metrics
                                      * 3*(NDim-1) * (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100607 : unable to malloc function data arrays ***");
    return (100607);
  }

  return (0);

}
