#include "UG_IO_LIB.h"

INT_ ug_io_malloc_2d_node
 (INT_ M_Spacing,
  INT_ M_Metric,
  INT_ Number_of_Nodes,
  DOUBLE_2D ** Coordinates,
  DOUBLE_1D ** Spacing,
  DOUBLE_3D ** Metric)

{

/*
 * Malloc 2D node data arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_malloc_2d_node.c,v 1.12 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Error_Flag;

  Error_Flag = 0;

  *Coordinates = (DOUBLE_2D *) ug_malloc (&Error_Flag,
                                          (Number_of_Nodes+1)
                                        * sizeof (DOUBLE_2D));

  if (M_Spacing == 1)
    *Spacing = (DOUBLE_1D *) ug_malloc (&Error_Flag,
                                        (Number_of_Nodes+1)
                                      * sizeof (DOUBLE_1D));
  else
    *Spacing = NULL;

  if (M_Metric == 1)
    *Metric = (DOUBLE_3D *) ug_malloc (&Error_Flag,
                                       (Number_of_Nodes+1)
                                     * sizeof (DOUBLE_3D));
  else
    *Metric = NULL;

  if (Error_Flag > 0)
  {
    ug_error_message ("*** ERROR 100606 : unable to malloc grid data arrays ***");
    return (100606);
  }

  return (0);

}
