#include "UG_IO_LIB.h"

INT_ ug_io_initialize_param
 (INT_ Set_2D_Types,
  INT_ Set_3D_Types,
  INT_ Set_Func_Types,
  INT_ Set_Geom_Types,
  INT_ Set_Grid_Types,
  INT_ Set_Node_Types,
  UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Set the UG_IO file type, format, and compression parameters.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_initialize_param.c,v 1.143 2021/05/27 20:43:22 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Check, check_2d_rmesh, check_2d_wmesh,
       check_rmesh, check_rsol, check_wmesh, check_wsol,
       Input_Option, Output_Option;
  INT_ Error_Flag = 0;

  ug2_check_read_write_mesh (&check_2d_rmesh, &check_2d_wmesh);
  ug3_check_read_write_mesh_sol (&check_rmesh, &check_rsol, &check_wmesh, &check_wsol);

  // set geometry data file types

  if (Set_Geom_Types == 1 && Set_3D_Types == 1)
  {
/*
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".SM",
      "SolidMesh SaveState file.",
      "A SaveState file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
*/

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".igs",
      "IGES geometry data file.",
      "An IGES file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".iges",
      "IGES geometry data file.",
      "An IGES file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".egads",
      "EGADS fgeometry data file.",
      "An EGADS file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".step",
      "STEP geometry data file.",
      "A STEP file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".stp",
      "STEP geometry data file.",
      "A STEP file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".brep",
      "BRep geometry data file.",
      "An OpenCASCADE BRep file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);

/*
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".xmt_txt",
      "ParaSolid geometry data file.",
      "A ParaSolid file contains  geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".prt",
      "UniGraphics geometry data file.",
      "A UniGraphics PRT file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".prt",
      "ProEngineer geometry data file.",
      "A Pro-E PRT file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".asm",
      "ProEngineer geometry data file.",
      "A Pro-E ASM file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".CATPART",
      "CatiaV5 geometry data file.",
      "A Catia CATPART file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".CATPRODUCT",
      "CatiaV5 geometry data file.",
      "A Catia CATPRODUCT file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".sldprt",
      "SolidWorks geometry data file.",
      "A SolidWorks SLDPRT file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".sldasm",
      "SolidWorks geometry data file.",
      "A SolidWorks SLDASM file contains geometry definition data.",
      UG_IO_GEOM_DATA, 1, 0, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".p3d",
      "PLOT3D geometry data file.",
      "A P3D file contains structured geometry definition data.",
      UG_IO_GEOM_DATA, 1, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".xyz",
      "XYZ geometry data file.",
      "An XYZ file contains x,y,z coordinate geometry definition data.",
      UG_IO_GEOM_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
*/
  }

  // set 2D geometry data file types

  if (Set_Geom_Types == 1 && Set_2D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".xy",
      "XY 2D geometry data file.",
      "An XY file contains x,y coordinate \
geometry definition data.",
      UG_IO_2D_GEOM_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
  }

  // set node data file types

  if (Set_Node_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".snode",
      "SNODE 3D source node data file.",
      "An SNODE file contains a list of node coordinates \
and spacing function.",
      UG_IO_NODE_DATA, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".mnode",
      "MNODE 3D metric source node data file.",
      "A MNODE file contains a list of node coordinates \
and symmetric metric.",
      UG_IO_NODE_DATA, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);
  }

  // set 2D node data file types

  if (Set_Node_Types == 1 && Set_2D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".snode2d",
      "SNODE 2D source node data file.",
      "An SNODE file contains a list of node coordinates \
and spacing function.",
      UG_IO_2D_NODE_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".mnode2d",
      "MNODE 2D metric source node data file.",
      "A MNODE file contains a list of node coordinates \
and symmetric metric.",
      UG_IO_2D_NODE_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
  }

  // set tags data file types

  if (Set_Grid_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".tags",
      "TAGS surface tags data file.",
      "A TAGS file contains a list of surface IDs and surface BC properties.",
      UG_IO_TAGS_DATA, 1, 0, 0, 0, 1, UG_IO_Param_Struct_Ptr);
  }

  // set split data file types

  if (Set_Grid_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".split",
      "SPLIT split-face hex-element data file.",
      "A SPLIT file contains a list of hex-elements with 2:1 split faces.",
      UG_IO_SPLIT_DATA, 1, 1, 0, 1, 1, UG_IO_Param_Struct_Ptr);
  }

  // set sns data file types

  if (Set_Grid_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".snsdata",
      "SNS specified normal spacing data file.",
      "An SNS file contains the specified normal spacing data for BL grid generation.", 
      UG_IO_SNS_DATA, 1, 0, 0, 0, 1, UG_IO_Param_Struct_Ptr);
  }

  // set ps data file types

  if (Set_Grid_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".psdata",
      "PSDATA periodic surface definition data file.",
      "A PSDATA file contains the definitions for periodic surface pairs.",
      UG_IO_PS_DATA, 1, 0, 0, 0, 1, UG_IO_Param_Struct_Ptr);
  }

  // set surface grid file types

  if (Set_Grid_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".poly",
      "POLY unstructured b-surf grid file.",
      "A POLY file contains a tria/quad face \
boundary surface grid. This file type is used by TetGen.",
      UG_IO_SURFACE_GRID, 0, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".stl",
      "A 3D stereo-lithography b-surf grid file.",
      "A STL file contains a tria face boundary surface grid.",
      UG_IO_SURFACE_GRID, 1, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".surf",
      "SURF 3D unstructured b-surf grid file.",
      "A SURF file contains a tria/quad face boundary surface grid.",
      UG_IO_SURFACE_GRID, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".tri",
      "Cart3D TRI unstructured b-surf grid file.",
      "A Cart3D TRI file contains a tria face \
boundary surface grid. This file type is \
generated by the Cart3D system.",
      UG_IO_SURFACE_GRID, 1, 1, 0, 1, 1, UG_IO_Param_Struct_Ptr);

    // set surface and/or volume grid file types

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".cfd++",
      "CFD++ grid file set.",
      "A CFD++ grid file set contains a tria/quad \
face boundary surface grid and a \
polyhedral element volume grid. This \
file type uses multiple files for \
coordinates (nodesin.bin), elements \
(cellsin.bin), and surface faces (exbcsin.bin).",
      UG_IO_VOLUME_GRID, 0, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    Check = ug_io_cgns_grid_lib_check ();

    if (Check)
    {
      Input_Option = (Check == 2) ? 0: 1;
      Output_Option = (Check == 1) ? 0: 1;

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".cgns",
        "CGNS data file.",
        "A CGNS data file contains a tria/quad \
face boundary surface grid and \
(optionally) a polyhedral element volume grid.",
        UG_IO_VOLUME_GRID, Input_Option, Output_Option, 0, 0, 0, UG_IO_Param_Struct_Ptr);
    }

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".cobalt.grd",
      "Cobalt grid file.",
      "A Cobalt grid file contains a tria/quad \
face boundary surface grid and a \
polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 0, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".egrid",
      "Ensight Gold grid file.",
      "An Ensight Gold grid file contains a \
tria/quad face boundary surface grid and \
a polyhedral element volume grid. This \
file type writes an additional case file (case_name.case).",
      UG_IO_VOLUME_GRID, 0, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".face",
      "TETGEN 3D unstructured grid file set.",
      "A TETGEN file set contains a tria face \
boundary surface grid and (optionally) \
a tetrahedral volume grid. This file \
type uses multiple files for coordinates \
(.node), elements (.ele), and faces \
(.face). This file type is used by TetGen.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".fgrid",
      "FGRID 3D unstructured grid file.",
      "An FGRID file contains a triangulated \
boundary surface grid and (optionally) \
a tetrahedral volume grid. The FGRID \
file type is derived from the FAST \
(PLOT3D) unstructured grid file type. \
FGRID and FAST files are the same except \
for optional FGRID boundary \
reconnection, boundary condition, and \
initial normal spacing data records.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".fluent.cas",
      "Fluent grid file.",
      "A Fluent grid file contains a tria/quad \
face boundary surface grid and a \
polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 0, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".foam",
      "OpenFOAM polyMesh grid files",
      "A cellShape file contains a volume grid \
that is comprised of points and \
polyhedral elements defined by faces.",
      UG_IO_VOLUME_GRID, 0, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".fvuns",
      "Fieldview frid file.",
      "A Fieldview grid file contains \
boundary surface grid and (optionally) \
a polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 0, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".gambit",
      "GAMBIT (Fluent) neutral file.",
      "A GAMBIT Neutral file contains a tria/quad  \
face boundary surface grid and \
(optionally) a polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 0, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".mcell",
      "NSU3D grid file.",
      "A NSU3D grid file contains a tria/quad \
boundary surface grid and (optionally) \
a polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 1, 1, UG_IO_Param_Struct_Ptr);

    if (check_rmesh || check_wmesh)
    {
      Input_Option = (check_rmesh) ? 1: 0;
      Output_Option = (check_wmesh) ? 1: 0;

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".mesh",
        "MESH 3D unstructured grid file.",
        "A MESH file contains a tria/quad face \
boundary surface grid and (optionally) \
a polyhedral element volume grid. \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_VOLUME_GRID, Input_Option, Output_Option, 0, 0, 1, UG_IO_Param_Struct_Ptr);

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".meshb",
        "Binary MESH 3D unstructured grid file.",
        "A MESH file contains a tria/quad face \
boundary surface grid and (optionally) \
a polyhedral element volume grid. \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_VOLUME_GRID, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);
    }

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".bdf",
      "NASTRAN 3D unstructured grid file.",
      "A NASTRAN file contains a tria/quad face \
boundary surface grid and (optionally) \
a polyhedral element volume grid. \
The suffix .nas and .bdf are equivalent.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".nas",
      "NASTRAN 3D unstructured grid file.",
      "A NASTRAN file contains a tria/quad face \
boundary surface grid and (optionally) \
a polyhedral element volume grid. \
The suffix .nas and .bdf are equivalent.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".ufast",
      "UFAST 3D unstructured grid file.",
      "A UFAST file contains a triangulated \
boundary surface grid and (optionally) \
a tetrahedral volume grid. The UFAST \
file type is identical to the FAST \
(PLOT3D) unstructured grid file type.",
      UG_IO_VOLUME_GRID, 1, 1, 0, 1, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".ugrid",
      "UGRID 3D unstructured grid file.",
      "A UGRID file contains a tria/quad face \
boundary surface grid and (optionally) \
a polyhedral element volume grid.",
      UG_IO_VOLUME_GRID, 1, 1, 1, 1, 1, UG_IO_Param_Struct_Ptr);
  }

  // set 2D b-edge grid file types

  if (Set_Grid_Types == 1 && Set_2D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".bedge",
      "BEDGE 2D B-Edge Grid File.",
      "A BEDGE file contains a boundary edge grid.",
      UG_IO_2D_EDGE_GRID, 1, 0, 0, 0, 0, UG_IO_Param_Struct_Ptr);
  }

  // set 2D grid file types

  if (Set_Grid_Types == 1 && Set_2D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".fgrid",
      "FGRID 2D unstructured grid file.",
      "An FGRID file contains a boundary edge \
grid and (optionally) a tria face planar \
grid. The FGRID 2D file type is derived \
from the 3D FGRID file type. Differences \
include additional boundary edge grid \
data, no volume elements, and all \
z-coordinates are zero.",
      UG_IO_2D_GRID, 1, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);

    if (check_2d_rmesh || check_2d_wmesh)
    {
      Input_Option = (Check == 2) ? 0: 1;
      Output_Option = (Check == 1) ? 0: 1;

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".mesh",
        "MESH 2D unstructured grid file.",
        "A MESH file contains a boundary edge \
grid and (optionally) a tria/quad face planar grid. ; \
This file type is supported by the Gamma Project of INRIA.",
        UG_IO_2D_GRID, Input_Option, Output_Option, 0, 0, 0, UG_IO_Param_Struct_Ptr);

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".meshb",
        "Binary MESH 2D unstructured grid file.",
        "A MESH file contains a boundary edge \
grid and (optionally) a tria/quad face planar grid. ; \
This file type is supported by the Gamma Project of INRIA.",
        UG_IO_2D_GRID, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
    }

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".ugrid",
      "UGRID 2D Unstructured Grid File.",
      "A UGRID file contains a boundary edge \
grid and (optionally) a mixed tria/quad \
face planar grid. The UGRID 2D file type \
is derived from the 3D UGRID file type. \
Differences include additional boundary \
edge grid data, no volume elements, and \
all z-coordinates are zero.",
      UG_IO_2D_GRID, 1, 1, 0, 1, 0, UG_IO_Param_Struct_Ptr);
  }

  // set function file types

  if (Set_Func_Types == 1 && Set_3D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".efunc",
      "Ensight Gold function file.",
      "An Ensight Gold function file contains field function data \
(scalar and/or vector). \
This file type assumes that a \
grid data file will also be written out. \
It also writes to an additional case \
file (case_name.case).",
      UG_IO_FUNCTION_DATA, 0, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".ufunc",
      "UFUNC 3D function file.",
      "A UFUNC file contains field function data \
(scalar and/or vector).",
      UG_IO_FUNCTION_DATA, 1, 1, 1, 1, 1, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".sfunc",
      "SFUNC 3D function file.",
      "An SFUNC file contains field function data \
(scalar, vector, matrix, and/or symmetric metric).",
      UG_IO_FUNCTION_DATA, 1, 1, 1, 1, 1, UG_IO_Param_Struct_Ptr);

    if (check_rsol || check_wsol)
    {
      Input_Option = (check_rsol) ? 1: 0;
      Output_Option = (check_wsol) ? 1: 0;

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".sol",
        "MESH SOL 3D unstructured function file.",
        "A MESH SOL file contains field function data \
(scalar, vector, matrix, and/or symmetric metric). \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_FUNCTION_DATA, Input_Option, Output_Option, 0, 0, 1, UG_IO_Param_Struct_Ptr);

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".solb",
        "Binary MESH SOL 3D unstructured function file.",
        "A MESH SOL file contains field function data \
(scalar, vector, matrix, and/or symmetric metric). \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_FUNCTION_DATA, 1, 1, 0, 0, 1, UG_IO_Param_Struct_Ptr);
    }
  }

  if (Set_Func_Types == 1 && Set_2D_Types == 1)
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".ufunc",
      "UFUNC 2D function file.",
      "A UFUNC file contains field function data \
(scalar and/or vector).",
      UG_IO_2D_FUNCTION_DATA, 1, 1, 1, 1, 0, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
     (".sfunc",
      "SFUNC 2D function file.",
      "An SFUNC file contains field function data \
(scalar, vector, matrix, and/or symmetric metric).",
      UG_IO_2D_FUNCTION_DATA, 1, 1, 1, 1, 0, UG_IO_Param_Struct_Ptr);

    if (check_rsol || check_wsol)
    {
      Input_Option = (check_rsol) ? 1: 0;
      Output_Option = (check_wsol) ? 1: 0;

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".sol",
        "MESH SOL 2D unstructured function file.",
        "A MESH SOL file contains field function data \
(scalar, vector, matrix, and/or symmetric metric). \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_2D_FUNCTION_DATA, Input_Option, Output_Option, 0, 0, 0, UG_IO_Param_Struct_Ptr);

      if (Error_Flag == 0) Error_Flag = ug_io_set_file_type_param_struct
       (".solb",
        "Binary MESH SOL 2D unstructured function file.",
        "A MESH SOL file contains field function data \
(scalar, vector, matrix, and/or symmetric metric). \
This file type is supported by the Gamma \
Project of INRIA.",
        UG_IO_2D_FUNCTION_DATA, 1, 1, 0, 0, 0, UG_IO_Param_Struct_Ptr);
    }
  }

  // set file formats

  if (sizeof (INT_) == sizeof (int))
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     ("",
      "Formatted ASCII file or binary format specific to file type.",
      "", UG_FIO_FORMATTED, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".b8",
      "C Binary double file format with big endian ordering.",
      "", UG_FIO_BINARY_DOUBLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".b4",
      "C Binary float file format with big endian ordering.",
      "", UG_FIO_BINARY_SINGLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".lb8",
      "C Binary double file format with little endian ordering.",
      "", -UG_FIO_BINARY_DOUBLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".lb4",
      "C Binary float file format with little endian ordering.",
      "", -UG_FIO_BINARY_SINGLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".r8",
      "FORTRAN unformatted real*8 file format with big endian ordering.",
      "", UG_FIO_UNFORMATTED_DOUBLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".r4",
      "FORTRAN unformatted real*4 file format with big endian ordering.",
      "", UG_FIO_UNFORMATTED_SINGLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".lr8",
      "FORTRAN unformatted real*8 file format with little endian ordering.",
      "", -UG_FIO_UNFORMATTED_DOUBLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".lr4",
      "FORTRAN unformatted real*4 file format with little endian ordering.",
      "", -UG_FIO_UNFORMATTED_SINGLE, UG_IO_Param_Struct_Ptr);
  }
  else if (sizeof (INT_) == sizeof (LONG_LONG_int))
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     ("",
      "Formatted ASCII file or binary format specific to file type.",
      "Only the binary MESH file type is known to be compatible with 64-bit ints.",
      UG_FIO_FORMATTED, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".b8l",
      "C Binary double file format with 64-bit ints and big endian ordering.",
      "", UG_FIO_BINARY_INT64_DOUBLE, UG_IO_Param_Struct_Ptr);

    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     (".lb8l",
      "C Binary double file format with 64-bit ints and little endian ordering.",
      "", -UG_FIO_BINARY_INT64_DOUBLE, UG_IO_Param_Struct_Ptr);
  }
  else
  {
    if (Error_Flag == 0) Error_Flag = ug_io_set_file_format_param_struct
     ("",
      "Formatted ASCII file or binary format specific to file type.",
      "", UG_FIO_FORMATTED, UG_IO_Param_Struct_Ptr);
  }

  // set file modes

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_mode_param_struct
   ("",
    "Standard file mode.", "",
    UG_FIO_STANDARD_FILE_MODE, UG_IO_Param_Struct_Ptr);

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_mode_param_struct
   (".tmp",
    "Binary TMP file mode.",
    "Binary TMP files are not directly \
accessible and exist only temporarily in \
computer disk scratch space.",
    UG_FIO_TMP_FILE_MODE, UG_IO_Param_Struct_Ptr);
  
  // set file compressions

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_compression_param_struct
   ("", "No file compression.", "", UG_IO_Param_Struct_Ptr);

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_compression_param_struct
   (".bz2", "BZIP2 file compression.", "", UG_IO_Param_Struct_Ptr);

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_compression_param_struct
   (".gz", "GZIP file compression.", "", UG_IO_Param_Struct_Ptr);

  if (Error_Flag == 0) Error_Flag = ug_io_set_file_compression_param_struct
   (".Z", "COMPRESS file compression.", "", UG_IO_Param_Struct_Ptr);

  // return on error

  if (Error_Flag)
    return (Error_Flag);

  return (0);

}
