#include "UG_IO_LIB.h"

void ug_io_free_param
 (UG_IO_Param_Struct * UG_IO_Param_Struct_Ptr)

{

/*
 * Free UG_IO parameter structure arrays.
 * 
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_free_param.c,v 1.9 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ Index;

  if (UG_IO_Param_Struct_Ptr != NULL)
  {
    for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Types; ++Index)
    {
      ug_free (UG_IO_Param_Struct_Ptr->File_Type_Doc[Index]);
    }
    for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Formats; ++Index)
    {
      ug_free (UG_IO_Param_Struct_Ptr->File_Format_Doc[Index]);
    }
    for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Modes; ++Index)
    {
      ug_free (UG_IO_Param_Struct_Ptr->File_Mode_Doc[Index]);
    }
    for (Index = 0; Index < UG_IO_Param_Struct_Ptr->Number_of_File_Compressions; ++Index)
    {
      ug_free (UG_IO_Param_Struct_Ptr->File_Compression_Doc[Index]);
    }

    ug_free (UG_IO_Param_Struct_Ptr->File_Data_Type);
    ug_free (UG_IO_Param_Struct_Ptr->File_Type_Format_Flag);
    ug_free (UG_IO_Param_Struct_Ptr->File_Type_Info);
    ug_free (UG_IO_Param_Struct_Ptr->File_Type_Doc);
    ug_free (UG_IO_Param_Struct_Ptr->File_Type_Suffix);

    ug_free (UG_IO_Param_Struct_Ptr->File_Format);
    ug_free (UG_IO_Param_Struct_Ptr->File_Format_Info);
    ug_free (UG_IO_Param_Struct_Ptr->File_Format_Doc);
    ug_free (UG_IO_Param_Struct_Ptr->File_Format_Suffix);

    ug_free (UG_IO_Param_Struct_Ptr->File_Mode);
    ug_free (UG_IO_Param_Struct_Ptr->File_Mode_Info);
    ug_free (UG_IO_Param_Struct_Ptr->File_Mode_Doc);
    ug_free (UG_IO_Param_Struct_Ptr->File_Mode_Suffix);

    ug_free (UG_IO_Param_Struct_Ptr->File_Compression_Info);
    ug_free (UG_IO_Param_Struct_Ptr->File_Compression_Doc);
    ug_free (UG_IO_Param_Struct_Ptr->File_Compression_Suffix);

    ug_free (UG_IO_Param_Struct_Ptr);
  }

  return;

}
