#include "UG_IO_LIB.h"

INT_ ug_io_find_file
 (char Case_Name[],
  char File_Name[],
  INT_ File_Data_Type_)

{

/*
 * Find file name of an existing (and readable) standard UG file with given case
 * name and data type.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_find_file.c,v 1.30 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_IO_Param_Struct *UG_IO_Param_Struct_Ptr;

  FILE *Data_File;

  CHAR_21 *File_Compression_Suffix, *File_Format_Suffix, *File_Type_Suffix;

  INT_1D *File_Data_Type;

  CHAR_UG_MAX Test_Name;

  INT_ Check, Error_Flag, Error_Mode, File_Compression_Index, File_Data_Type_2_,
       File_Data_Type_Check, File_Format_Index, File_Format_Order, 
       File_Found_Flag, File_Type_Index, Number_of_Checks, Number_of_File_Types,
       Number_of_File_Formats, Number_of_File_Compressions, Test_Name_Length;

  Error_Flag = ug_io_malloc_param (&UG_IO_Param_Struct_Ptr);

  if (Error_Flag == 0)
    Error_Flag = ug_io_initialize_param (1, 1, 1, 1, 1, 1, UG_IO_Param_Struct_Ptr);

  if (Error_Flag)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    return (Error_Flag);
  }

  if (File_Data_Type_ < 0)
  {
    File_Data_Type_ = -File_Data_Type_;
    Error_Mode = 1;
  }
  else
    Error_Mode = 0;

  Test_Name_Length = (INT_) strlen (Case_Name) - 1;
  
  strcpy (Test_Name, "");
  strncat (Test_Name, Case_Name, Test_Name_Length);
  strcat (Test_Name, ".");

  if (strcmp (Test_Name, Case_Name) == 0)
  {
    strcpy (Test_Name, "");
    strncat (Test_Name, Case_Name, Test_Name_Length);
    strcpy (Case_Name, Test_Name);
  }

  Number_of_File_Types = UG_IO_Param_Struct_Ptr->Number_of_File_Types;
  File_Data_Type = UG_IO_Param_Struct_Ptr->File_Data_Type;
  File_Type_Suffix = UG_IO_Param_Struct_Ptr->File_Type_Suffix;

  Number_of_File_Formats = UG_IO_Param_Struct_Ptr->Number_of_File_Formats;
  File_Format_Suffix = UG_IO_Param_Struct_Ptr->File_Format_Suffix;

  Number_of_File_Compressions = UG_IO_Param_Struct_Ptr->Number_of_File_Compressions;
  File_Compression_Suffix = UG_IO_Param_Struct_Ptr->File_Compression_Suffix;

  if (File_Data_Type_ == UG_IO_SURFACE_GRID ||
      File_Data_Type_ == UG_IO_2D_EDGE_GRID)
  {
    File_Data_Type_2_ = File_Data_Type_ + 1;

    File_Format_Order = 1;

    Number_of_Checks = 2;
  }
  else
  {
    File_Format_Order = -1;

    Number_of_Checks = 1;
  }

  File_Found_Flag = 0;

  Check = 1;

  do
  {
    File_Data_Type_Check = (Check == 1) ? File_Data_Type_ : File_Data_Type_2_;

    File_Type_Index = 0;

    do
    {
      if (File_Data_Type_Check == File_Data_Type[File_Type_Index])
      {
        if (File_Format_Order == 1)
          File_Format_Index = 0;
        else
          File_Format_Index = Number_of_File_Formats-1;

        do
        {
          File_Compression_Index = 0;

          do
          {
            strcpy (File_Name, "");
            strcat (File_Name, Case_Name);
            strcat (File_Name, File_Format_Suffix[File_Format_Index]);
            strcat (File_Name, File_Type_Suffix[File_Type_Index]);
            strcat (File_Name, File_Compression_Suffix[File_Compression_Index]);

            Data_File = ug_fopen (File_Name, "r");

            if (Data_File != NULL)
            {
              File_Found_Flag = 1;

              ug_fclose (Data_File);
            }

            ++File_Compression_Index;
          }
          while (File_Compression_Index < Number_of_File_Compressions &&
                 File_Found_Flag == 0);

          if (File_Format_Order == 1)
            ++File_Format_Index;
          else
            --File_Format_Index;
        }
        while (File_Format_Index >= 0 &&
               File_Format_Index < Number_of_File_Formats &&
               File_Found_Flag == 0);
      }

      ++File_Type_Index;
    }
    while (File_Type_Index < Number_of_File_Types && File_Found_Flag == 0);

    ++Check;
  }
  while (Check <= Number_of_Checks && File_Found_Flag == 0);

  ug_io_free_param (UG_IO_Param_Struct_Ptr);

  if (File_Found_Flag == 0 && Error_Mode)
  {
    ug_error_message ("*** ERROR 601 : unable to find file ***");
    return (601);
  }
  else if (File_Found_Flag == 0)
    return (-1);

  return (0);

}
