#include "UG_IO_LIB.h"

INT_ ug_io_file_info
 (char File_Name[],
  char Case_Name[],
  char File_Compression_Suffix_[],
  char File_Format_Suffix_[],
  char File_Mode_Suffix_[],
  char File_Type_Suffix_[],
  INT_ Check_File_Flag,
  INT_ NDim,
  INT_ *File_Data_Type_,
  INT_ *File_Format_,
  INT_ *File_Mode_,
  INT_ *File_Type_Format_Flag_)

{

/*
 * Determine file compression suffix, format suffix, type suffix, data type and
 * extract the case name (with leading path if any) from a standard UG file
 * name.
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_file_info.c,v 1.61 2022/11/21 00:41:36 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_IO_Param_Struct *UG_IO_Param_Struct_Ptr;

  FILE *Data_File;

  CHAR_UG_MAX Name_Text, Text;
  CHAR_21 *File_Type_Suffix;
  CHAR_21 *File_Compression_Suffix, *File_Format_Suffix, *File_Mode_Suffix;

  INT_1D *File_Data_Type, *File_Format, *File_Mode, *File_Type_Format_Flag;

  CHAR_UG_MAX Test_Name;
  CHAR_UG_MAX Try_Name;

  INT_ ASCII_Format_Index, Case_Name_Length, Error_Flag, File_Compression_Index,
       File_Format_Index, File_Found_Flag, File_Mode_Index, File_Name_Length,
       File_Type_Index, Format_Index, Format_Option, INT64_Option, isFound, m,
       Mode_Index, Mode_Option, n, n2, n3, No_Compression_Index,
       Number_of_File_Types, Number_of_File_Formats, Number_of_File_Modes,
       Number_of_File_Compressions, Standard_Mode_Index, Try_Name_Length;

  if (File_Name == NULL || strcmp (File_Name, "") == 0)
  {
    ug_error_message ("*** ERROR 600 : file name is empty ***");
    return (600);
  }

  strcpy (Test_Name, "");
  strncat (Test_Name, File_Name, (INT_) strlen (File_Name) - 1);
  strcat (Test_Name, ".");

  if (strcmp (Test_Name, File_Name) == 0)
  {
    strcpy (Test_Name, "");
    strncat (Test_Name, File_Name, (INT_) strlen (File_Name) - 1);
    strcpy (File_Name, Test_Name);
  }

  Error_Flag = ug_io_malloc_param (&UG_IO_Param_Struct_Ptr);

  if (NDim == 2)
  {
    n2 = 1;
    n3 = 0;
  }
  else if (NDim == 3)
  {
    n2 = 0;
    n3 = 1;
  }
  else
  {
    n2 = 1;
    n3 = 1;
  }

  if (Error_Flag == 0)
    Error_Flag = ug_io_initialize_param (n2, n3, 1, 1, 1, 1, UG_IO_Param_Struct_Ptr);

  if (Error_Flag)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    return (Error_Flag);
  }

  Number_of_File_Types = UG_IO_Param_Struct_Ptr->Number_of_File_Types;
  File_Data_Type = UG_IO_Param_Struct_Ptr->File_Data_Type;
  File_Type_Format_Flag = UG_IO_Param_Struct_Ptr->File_Type_Format_Flag;
  File_Type_Suffix = UG_IO_Param_Struct_Ptr->File_Type_Suffix;

  Number_of_File_Formats = UG_IO_Param_Struct_Ptr->Number_of_File_Formats;
  File_Format = UG_IO_Param_Struct_Ptr->File_Format;
  File_Format_Suffix = UG_IO_Param_Struct_Ptr->File_Format_Suffix;

  Number_of_File_Modes = UG_IO_Param_Struct_Ptr->Number_of_File_Modes;
  File_Mode = UG_IO_Param_Struct_Ptr->File_Mode;
  File_Mode_Suffix = UG_IO_Param_Struct_Ptr->File_Mode_Suffix;

  Number_of_File_Compressions = UG_IO_Param_Struct_Ptr->Number_of_File_Compressions;
  File_Compression_Suffix = UG_IO_Param_Struct_Ptr->File_Compression_Suffix;

  *File_Data_Type_ = 0;

  File_Type_Index = 0;

  File_Name_Length = (INT_) strlen (File_Name);
  do
  {
    strcpy (File_Type_Suffix_, File_Type_Suffix[File_Type_Index]);

    if (strstr (File_Name, File_Type_Suffix_) != NULL)
    {
       strcpy (Try_Name, "");
       strcat (Try_Name, File_Type_Suffix_);
       strcat (Try_Name, ".");

       isFound = 1;

       if (strstr (File_Name, Try_Name) == NULL)
       {
          Try_Name_Length = (INT_) strlen (File_Type_Suffix_);

          m = File_Name_Length-Try_Name_Length;
          n = 0;

          do
          {
             if (File_Type_Suffix_[n] != File_Name[m])
               isFound = 0;

            ++m;
            ++n;
          }
          while (n < Try_Name_Length && isFound == 1);
       }

       if (isFound)
       {
          *File_Data_Type_ = File_Data_Type[File_Type_Index];
          *File_Type_Format_Flag_ = File_Type_Format_Flag[File_Type_Index];
       }
    }

    ++File_Type_Index;
  }
  while (File_Type_Index < Number_of_File_Types && *File_Data_Type_ == 0);

  --File_Type_Index;

  if (*File_Data_Type_ == 0)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    if (Check_File_Flag != 2)
    {
      strcpy (Name_Text, "");
      strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-9);
      snprintf (Text, sizeof(Text), "*** %s ***", Name_Text);
      ug_error_message ("*** ERROR 611 : file has an unknown file type ***");
      ug_error_message (Text);
    }
    return (611);
  }

  ASCII_Format_Index = -1;

  File_Format_Index = 0;

  do
  {
    if (strcmp (File_Format_Suffix[File_Format_Index], "") == 0)
      ASCII_Format_Index = File_Format_Index;

    ++File_Format_Index;
  }
  while (File_Format_Index < Number_of_File_Formats && ASCII_Format_Index== -1);

  strcpy (File_Format_Suffix_, "");

  Format_Index = ASCII_Format_Index;

  *File_Format_ = File_Format[ASCII_Format_Index];

  File_Format_Index = 0;

  do
  {
    if (File_Format_Index != ASCII_Format_Index &&
        strstr (File_Name, File_Format_Suffix[File_Format_Index]) != NULL)
    {
       strcpy (Try_Name, "");
       strcat (Try_Name, File_Format_Suffix[File_Format_Index]);
       strcat (Try_Name, ".");

       isFound = 1;

       if (strstr (File_Name, Try_Name) == NULL)
       {
          Try_Name_Length = (INT_) strlen (File_Format_Suffix[File_Format_Index]);

          m = File_Name_Length-Try_Name_Length;
          n = 0;

          do
          {
             if (File_Format_Suffix[File_Format_Index][n] != File_Name[m])
               isFound = 0;

            ++m;
            ++n;
          }
          while (n < Try_Name_Length && isFound == 1);
       }

       if (isFound)
       {
          strcpy (File_Format_Suffix_, File_Format_Suffix[File_Format_Index]);
          Format_Index = File_Format_Index;
          *File_Format_ = File_Format[File_Format_Index];
       }
    }

    ++File_Format_Index;
  }
  while (File_Format_Index < Number_of_File_Formats &&
         strcmp (File_Format_Suffix_, "") == 0);

  File_Format_Index = Format_Index;

  Standard_Mode_Index = -1;

  File_Mode_Index = 0;

  do
  {
    if (strcmp (File_Mode_Suffix[File_Mode_Index], "") == 0)
      Standard_Mode_Index = File_Mode_Index;

    ++File_Mode_Index;
  }
  while (File_Mode_Index < Number_of_File_Modes && Standard_Mode_Index== -1);

  strcpy (File_Mode_Suffix_, "");

  Mode_Index = Standard_Mode_Index;

  *File_Mode_ = File_Mode[Standard_Mode_Index];

  File_Mode_Index = 0;

  do
  {
    if (File_Mode_Index != Standard_Mode_Index &&
        strstr (File_Name, File_Mode_Suffix[File_Mode_Index]) != NULL)
    {
       strcpy (Try_Name, "");
       strcat (Try_Name, File_Mode_Suffix[File_Mode_Index]);
       strcat (Try_Name, ".");

       isFound = 1;

       if (strstr (File_Name, Try_Name) == NULL)
       {
          Try_Name_Length = (INT_) strlen (File_Mode_Suffix[File_Mode_Index]);

          m = File_Name_Length-Try_Name_Length;
          n = 0;

          do
          {
             if (File_Mode_Suffix[File_Mode_Index][n] != File_Name[m])
               isFound = 0;

            ++m;
            ++n;
          }
          while (n < Try_Name_Length && isFound == 1);
       }

       if (isFound)
       {
          strcpy (File_Mode_Suffix_, File_Mode_Suffix[File_Mode_Index]);
          Mode_Index = File_Mode_Index;
          *File_Mode_ = File_Mode[File_Mode_Index];
       }
    }

    ++File_Mode_Index;
  }
  while (File_Mode_Index < Number_of_File_Modes &&
         strcmp (File_Mode_Suffix_, "") == 0);

  File_Mode_Index = Mode_Index;

  No_Compression_Index = -1;

  File_Compression_Index = 0;

  do
  {
    if (strcmp (File_Compression_Suffix[File_Compression_Index], "") == 0)
      No_Compression_Index = File_Compression_Index;

    ++File_Compression_Index;
  }
  while (File_Compression_Index < Number_of_File_Compressions &&
         No_Compression_Index == -1);

  strcpy (File_Compression_Suffix_, "");

  File_Compression_Index = 0;

  do
  {
    if (File_Compression_Index != No_Compression_Index &&
        strstr (File_Name,
                File_Compression_Suffix[File_Compression_Index]) != NULL)
    {
       strcpy (Try_Name, "");
       strcat (Try_Name, File_Compression_Suffix[File_Compression_Index]);
       strcat (Try_Name, ".");

       isFound = 1;

       if (strstr (File_Name, Try_Name) == NULL)
       {
          Try_Name_Length = (INT_) strlen (File_Compression_Suffix[File_Compression_Index]);

          m = File_Name_Length-Try_Name_Length;
          n = 0;

          do
          {
             if (File_Compression_Suffix[File_Compression_Index][n] != File_Name[m])
               isFound = 0;

            ++m;
            ++n;
          }
          while (n < Try_Name_Length && isFound == 1);
       }

       if (isFound)
       {
          strcpy (File_Compression_Suffix_,
                  File_Compression_Suffix[File_Compression_Index]);
       }
    }

    ++File_Compression_Index;
  }
  while (File_Compression_Index < Number_of_File_Compressions &&
         strcmp (File_Compression_Suffix_, "") == 0);

  --File_Compression_Index;

  Case_Name_Length = (INT_) strlen (File_Name)
                   - (INT_) strlen (File_Mode_Suffix_)
                   - (INT_) strlen (File_Format_Suffix_)
                   - (INT_) strlen (File_Type_Suffix_)
                   - (INT_) strlen (File_Compression_Suffix_);

  strcpy (Case_Name, "");
  strncat (Case_Name, File_Name, Case_Name_Length);

  strcpy (Test_Name, "");
  strcat (Test_Name, Case_Name);
  strcat (Test_Name, File_Mode_Suffix_);
  strcat (Test_Name, File_Format_Suffix_);
  strcat (Test_Name, File_Type_Suffix_);
  strcat (Test_Name, File_Compression_Suffix_);

  if (strcmp (Test_Name, File_Name) != 0)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    strcpy (Name_Text, "");
    strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-9);
    snprintf (Text, sizeof(Text), "*** %s ***", Name_Text);
    ug_error_message ("*** ERROR 633 : file has an unknown file type, format, and/or mode ***");
    ug_error_message (Text);
    return (633);
  }

  INT64_Option = *File_Type_Format_Flag_ / 16;
  Format_Option = (*File_Type_Format_Flag_ - INT64_Option * 16) / 8;
  Mode_Option = (*File_Type_Format_Flag_ - INT64_Option * 16 - Format_Option * 8) / 4;

  if (sizeof (INT_) != sizeof (int) && INT64_Option == 0)
  {
    strcpy (Name_Text, "");
    strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-9);
    snprintf (Text, sizeof(Text), "*** %s ***", Name_Text);
    ug_error_message ("*** ERROR 639 : file type/format is not supported in 64-bit int mode ***");
    ug_error_message (Text);
    return (639);
  }

  if (Format_Option == 0 && *File_Format_ != UG_FIO_FORMATTED)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    snprintf (Text, sizeof(Text), "*** ERROR 634 : %s files must use a fixed file format ***", UG_IO_Param_Struct_Ptr->File_Type_Info[File_Type_Index]);
    ug_error_message (Text);
    return (634);
  }

  if (Mode_Option == 0 && *File_Mode_ != UG_FIO_STANDARD_FILE_MODE)
  {
    ug_io_free_param (UG_IO_Param_Struct_Ptr);
    snprintf (Text, sizeof(Text), "*** ERROR 635 : %s must use standard mode ***", UG_IO_Param_Struct_Ptr->File_Type_Info[File_Type_Index]);
    ug_error_message (Text);
    return (635);
  }

  if (Mode_Option == 1 && *File_Mode_ != UG_FIO_STANDARD_FILE_MODE)
  {
    if (sizeof (INT_) == sizeof (int) && *File_Format_ != UG_FIO_BINARY_DOUBLE)
    {
      ug_io_free_param (UG_IO_Param_Struct_Ptr);
      snprintf (Text, sizeof(Text), "*** ERROR 636 : %s files must use C binary double file format ***", UG_IO_Param_Struct_Ptr->File_Mode_Info[File_Mode_Index]);
      ug_error_message (Text);
      return (636);
    }
    else if (sizeof (INT_) == sizeof (LONG_LONG_int) && *File_Format_ != UG_FIO_BINARY_INT64_DOUBLE)
    {
      ug_io_free_param (UG_IO_Param_Struct_Ptr);
      snprintf (Text, sizeof(Text), "*** ERROR 636 : %s files must use C binary double with 64-bit int file format ***", UG_IO_Param_Struct_Ptr->File_Mode_Info[File_Mode_Index]);
      ug_error_message (Text);
      return (636);
    }
  }

  if (Check_File_Flag && *File_Mode_ == UG_FIO_STANDARD_FILE_MODE)
  {
    File_Found_Flag = 0;

    Data_File = ug_fopen (File_Name, "r");

    if (Data_File != NULL)
    {
      ug_fclose (Data_File);

      File_Found_Flag = 1;
    }

    if (File_Found_Flag == 0 && strcmp (File_Compression_Suffix_, "") == 0)
    {
      File_Compression_Index = 0;

      do
      {
        if (File_Compression_Index != No_Compression_Index)
        {
          strcpy (Test_Name, "");
          strcat (Test_Name, File_Name);

          strcat (Test_Name, File_Compression_Suffix[File_Compression_Index]);

          Data_File = ug_fopen (Test_Name, "r");

          if (Data_File != NULL)
          {
            ug_fclose (Data_File);

            File_Found_Flag = 1;

            strcpy (File_Name, "");
            strcat (File_Name, Test_Name);

            strcpy (File_Compression_Suffix_,
                    File_Compression_Suffix[File_Compression_Index]);
          }
        }

        ++File_Compression_Index;
      }
      while (File_Compression_Index < Number_of_File_Compressions &&
             File_Found_Flag == 0);
    }

    if (File_Found_Flag == 0)
    {
      ug_io_free_param (UG_IO_Param_Struct_Ptr);
      strcpy (Name_Text, "");
      strncat (Name_Text, File_Name, ((INT_) strlen (Name_Text))-9);
      snprintf (Text, sizeof(Text), "*** %s ***", Name_Text);
      ug_error_message ("*** ERROR 637 : unable to open input file ***");
      ug_error_message (Text);
      return (637);
    }
  }

  ug_set_byte_order (*File_Format_);

  ug_io_free_param (UG_IO_Param_Struct_Ptr);

  return (0);

}

