#include "UG_IO_LIB.h"

INT_ ug_io_file_format
 (char File_Name[],
  INT_ *File_Format_)

{

/*
 * Determine file format from a standard UG file name. 
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_file_format.c,v 1.12 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Case_Name;

  CHAR_21 File_Compression_Suffix_, File_Format_Suffix_, File_Mode_Suffix_, File_Type_Suffix_;

  INT_ Error_Flag, File_Data_Type_, File_Mode_, File_Type_Format_Flag_;

  Error_Flag = ug_io_file_info (File_Name, Case_Name, 
                                File_Compression_Suffix_, File_Format_Suffix_,
                                File_Mode_Suffix_, File_Type_Suffix_,
                                0, 0, &File_Data_Type_, File_Format_,
                                &File_Mode_, &File_Type_Format_Flag_);

  return (Error_Flag);

}

