#include "UG_IO_LIB.h"

INT_ ug_io_convert_2d
 (int argc,
  char *argv[])

{

/*
 * Convert 2D UG_IO files
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_convert_2d.c,v 1.47 2021/02/08 18:56:29 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  // declare routine variables

  CHAR_UG_MAX Input_Case_Name, Input_File_Name,
              Output_Case_Name, Output_File_Name, Output_File_Suffix;

  INT_1D *Rm_Surf_ID = NULL;

  INT_ Bnd_Only_Flag, Error_Flag, Mode_Flag, No_Quad_Flag, 
       Renumber_ID_Flag, Separate_by_ID_Flag, Set_Vol_ID_Flag,
       Number_of_Rm_Surf_IDs, Surf_Quad_Flag, Surf_Tria_Flag,
       Vol_Hex_Flag, Vol_Pent_5_Flag, Vol_Pent_6_Flag, Vol_Tet_Flag;
  INT_ Input_File_Data_Type = 0;
  INT_ Output_File_Data_Type = 0;
  INT_ Message_Flag = 1;

  // declare grid data I/O variables

  INT_1D *Bnd_Edge_Grid_BC_Flag = NULL;
  INT_1D *Bnd_Edge_ID_Flag = NULL;

  INT_2D *Bnd_Edge_Connectivity = NULL;

  INT_3D *Tria_Connectivity = NULL;

  INT_4D *Quad_Connectivity = NULL;

  DOUBLE_1D *Initial_Normal_Spacing = NULL;
  DOUBLE_1D *BL_Thickness = NULL;

  DOUBLE_2D *Coordinates = NULL;

  INT_ Number_of_Bnd_Edges, Number_of_Nodes, Number_of_Quads, Number_of_Trias;

  INT_ M_BL_Thickness = 1;
  INT_ M_Initial_Normal_Spacing = 1;
  INT_ M_Bnd_Edge_Grid_BC_Flag = 1;
  INT_ M_Bnd_Edge_ID_Flag = 1;

  // declare node data I/O variables

  DOUBLE_1D *Spacing = NULL;
  DOUBLE_3D *Metric = NULL;

  // declare function data I/O variables

  CHAR_21 *U_Scalar_Labels = NULL;
  CHAR_21 *U_Vector_Labels = NULL;
  CHAR_21 *U_Matrix_Labels = NULL;
  CHAR_21 *U_Metric_Labels = NULL;

  DOUBLE_1D *U_Scalars = NULL;
  DOUBLE_1D *U_Vectors = NULL; // actually _2D
  DOUBLE_1D *U_Matrixes = NULL; // actually _4D
  DOUBLE_1D *U_Metrics = NULL; // actually _3D

  INT_ Number_of_U_Scalars, Number_of_U_Vectors,
       Number_of_U_Matrixes, Number_of_U_Metrics;

  // set input and output file names, list program help, set parameter structure
  // and get input parameters

  Error_Flag = ugc_startup (argc, argv, Input_File_Name, Output_File_Name,
                            &Bnd_Only_Flag, &Mode_Flag,
                            &No_Quad_Flag, &Renumber_ID_Flag,
                            &Separate_by_ID_Flag, &Set_Vol_ID_Flag,
                            &Surf_Quad_Flag, &Surf_Tria_Flag, &Vol_Hex_Flag, 
                            &Vol_Pent_5_Flag, &Vol_Pent_6_Flag, &Vol_Tet_Flag,
                            &Number_of_Rm_Surf_IDs,
                            &Rm_Surf_ID);

  // exit if not in 2D mode

  if (Mode_Flag != 2)
    Error_Flag = -1;

  // exit if file names are empty

  if (Error_Flag == 0 && (strcmp (Input_File_Name, "") == 0 || strcmp (Output_File_Name, "") == 0))
  {
    ug_error_message ("*** ERROR 602 : both input and output file names must be specified ***");
    Error_Flag = 602;
  }

  // if output case name is @ then set output case name to input case name

  if (Error_Flag == 0)
  {
    Error_Flag = ug_io_case_name (Output_File_Name, Output_Case_Name);

    if (Error_Flag == 0 && strcmp (Output_Case_Name, "@") == 0)
    {
      Error_Flag = ug_io_case_name (Input_File_Name, Input_Case_Name);

      if (Error_Flag == 0)
        Error_Flag = ug_io_file_suffix (Output_File_Name, Output_File_Suffix);

      if (Error_Flag == 0)
      {
        strcpy (Output_File_Name, Input_Case_Name);
        strcat (Output_File_Name, Output_File_Suffix);
      }
    }
  }

  // get file types

  if (Error_Flag == 0)
    Error_Flag = ug_io_file_type (Input_File_Name, 2, &Input_File_Data_Type);

  if (Error_Flag == 0)
    Error_Flag = ug_io_file_type (Output_File_Name, 2, &Output_File_Data_Type);

  // check file types

  if (Error_Flag == 0)
  {
    if (Input_File_Data_Type == UG_IO_2D_EDGE_GRID ||
        Input_File_Data_Type == UG_IO_2D_GRID)
    {
      if (Output_File_Data_Type != UG_IO_2D_EDGE_GRID &&
          Output_File_Data_Type != UG_IO_2D_GRID)
      {
        ug_error_message ("*** ERROR 626 : if input is a grid file then output must be also ***");
        Error_Flag = 626;
      }
    }

    else if (Input_File_Data_Type == UG_IO_2D_NODE_DATA)
    {
      if (Output_File_Data_Type != UG_IO_2D_NODE_DATA)
      {
        ug_error_message ("*** ERROR 627 : if input is a node file then output must be also ***");
        Error_Flag = 627;
      }
    }

    else if (Input_File_Data_Type == UG_IO_2D_FUNCTION_DATA)
    {
      if (Output_File_Data_Type != UG_IO_2D_FUNCTION_DATA)
      {
        ug_error_message ("*** ERROR 628 : if input is a function file then output must be also ***");
        Error_Flag = 628;
      }
    }

    else
    {
      ug_error_message ("*** ERROR 629 : file is not a 2d grid, node or function data type ***");
      Error_Flag = 629;
    }
  }

  // check file formats 

  if (Error_Flag == 0)
    Error_Flag = ug_file_format_check (Input_File_Name);

  if (Error_Flag == 0)
    Error_Flag = ug_file_format_check (Output_File_Name);

  // start of section to read and write a grid data file

  if (Input_File_Data_Type == UG_IO_2D_EDGE_GRID ||
      Input_File_Data_Type == UG_IO_2D_GRID)
  {
    // determine grid I/O variables and read grid dimensions

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_2d_grid_file (Input_File_Name,
                                            Message_Flag,
                                            M_BL_Thickness,
                                            M_Initial_Normal_Spacing,
                                            M_Bnd_Edge_Grid_BC_Flag,
                                            M_Bnd_Edge_ID_Flag,
                                            Bnd_Only_Flag,
                                            No_Quad_Flag,
                                            &Number_of_Bnd_Edges,
                                            &Number_of_Nodes,
                                            &Number_of_Quads,
                                            &Number_of_Trias,
                                            &Bnd_Edge_Connectivity,
                                            &Bnd_Edge_Grid_BC_Flag,
                                            &Bnd_Edge_ID_Flag,
                                            &Quad_Connectivity,
                                            &Tria_Connectivity,
                                            &Coordinates,
                                            &Initial_Normal_Spacing,
                                            &BL_Thickness);
 
    // output grid data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_2d_grid_file (Output_File_Name,
                                             Message_Flag,
                                             Number_of_Bnd_Edges,
                                             Number_of_Nodes,
                                             Number_of_Quads,
                                             Number_of_Trias,
                                             Bnd_Edge_Connectivity,
                                             Bnd_Edge_Grid_BC_Flag,
                                             Bnd_Edge_ID_Flag,
                                             Quad_Connectivity,
                                             Tria_Connectivity,
                                             Coordinates,
                                             Initial_Normal_Spacing,
                                             BL_Thickness);

    // free grid data arrays

    ug_io_free_2d_grid (Bnd_Edge_Connectivity, Bnd_Edge_Grid_BC_Flag,
                        Bnd_Edge_ID_Flag, Quad_Connectivity, Tria_Connectivity,
                        Coordinates, Initial_Normal_Spacing, BL_Thickness);
  }

  // start of section to read and write a node data file

  else if (Input_File_Data_Type == UG_IO_2D_NODE_DATA)
  {
    // read node data

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_2d_node_file (Input_File_Name, 
                                            Message_Flag, &Number_of_Nodes,
                                            &Coordinates, &Spacing, &Metric);

    // output node data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_2d_node_file (Output_File_Name, 
                                             Message_Flag, Number_of_Nodes,
                                             Coordinates, Spacing, Metric);

    // free node data arrays

    ug_io_free_2d_node (Coordinates, Spacing, Metric);
  }

  // start of section to read and write a function data file

  else if (Input_File_Data_Type == UG_IO_2D_FUNCTION_DATA)
  {
    // determine function data I/O variables and read data dimensions

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_func_file (Input_File_Name, 
                                         Message_Flag, 2,
                                         &Number_of_Nodes,
                                         &Number_of_U_Scalars,
                                         &Number_of_U_Vectors,
                                         &Number_of_U_Matrixes,
                                         &Number_of_U_Metrics,
                                         &U_Scalar_Labels, &U_Vector_Labels,
                                         &U_Matrix_Labels, &U_Metric_Labels,
                                         &U_Scalars, &U_Vectors,
                                         &U_Matrixes, &U_Metrics);

    // output function data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_func_file (Output_File_Name, 
                                          Message_Flag, 2, Number_of_Nodes,
                                          Number_of_U_Scalars,
                                          Number_of_U_Vectors,
                                          Number_of_U_Matrixes,
                                          Number_of_U_Metrics,
                                          U_Scalar_Labels, U_Vector_Labels,
                                          U_Matrix_Labels, U_Metric_Labels,
                                          U_Scalars, (DOUBLE_1D *) U_Vectors,
                                          (DOUBLE_1D *) U_Matrixes,
                                          (DOUBLE_1D *) U_Metrics);

    // free function data arrays

    ug_io_free_func_flag (U_Scalar_Labels, U_Vector_Labels,
                          U_Matrix_Labels, U_Metric_Labels);

    ug_io_free_func (U_Scalars, (DOUBLE_1D *) U_Vectors,
                     (DOUBLE_1D *) U_Matrixes, (DOUBLE_1D *) U_Metrics);
  }

  return (Error_Flag);

}
