#include "UG_IO_LIB.h"

INT_ ug_io_convert
 (int argc,
  char *argv[])

{

/*
 * Convert UG_IO files
 *
 * UG_IO LIB : Unstructured Grid - Input/Output Routine Library
 * $Id: ug_io_convert.c,v 1.64 2024/11/02 06:01:09 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  // declare routine variables

  CHAR_UG_MAX Input_Case_Name, Input_File_Name,
              Output_Case_Name, Output_File_Name, Output_File_Suffix;

  INT_1D *Rm_Surf_ID = NULL;

  INT_ Bnd_Only_Flag, Error_Flag, Mode_Flag, No_Quad_Flag, 
       Renumber_ID_Flag, Separate_by_ID_Flag, Set_Vol_ID_Flag,
       Number_of_Rm_Surf_IDs, Surf_Quad_Flag, Surf_Tria_Flag,
       Vol_Hex_Flag, Vol_Pent_5_Flag, Vol_Pent_6_Flag, Vol_Tet_Flag;
  INT_ Input_File_Data_Type = 0;
  INT_ Output_File_Data_Type = 0;
  INT_ Message_Flag = 1;

  // declare grid data I/O variables

  INT_1D *Bnd_Edge_ID_Flag = NULL;
  INT_2D *Bnd_Edge_Connectivity = NULL;
  INT_1D *Surf_Grid_BC_Flag = NULL;
  INT_1D *Surf_ID_Flag = NULL;
  INT_1D *Surf_Reconnection_Flag = NULL;
  INT_1D *Vol_ID_Flag = NULL;
  INT_3D *Surf_Tria_Connectivity = NULL;
  INT_4D *Surf_Quad_Connectivity = NULL, *Vol_Tet_Connectivity = NULL;
  INT_5D *Vol_Pent_5_Connectivity = NULL;
  INT_6D *Vol_Pent_6_Connectivity = NULL;
  INT_8D *Vol_Hex_Connectivity = NULL;
  DOUBLE_1D *Initial_Normal_Spacing = NULL, *BL_Thickness = NULL;

  DOUBLE_3D *Coordinates = NULL;

  INT_ Number_of_BL_Vol_Tets, Number_of_Nodes, Number_of_Surf_Quads,
       Number_of_Surf_Trias, Number_of_Vol_Hexs, Number_of_Vol_Pents_5,
       Number_of_Vol_Pents_6, Number_of_Vol_Tets;

  INT_ M_BL_Thickness = 1;
  INT_ M_Initial_Normal_Spacing = 1;
  INT_ M_Surf_Grid_BC_Flag = 1;
  INT_ M_Surf_ID_Flag = 1;
  INT_ M_Surf_Reconnection_Flag = 1;
  INT_ Number_of_Bnd_Edges = 0;

  // declare node data I/O variables

  DOUBLE_1D *Spacing = NULL;
  DOUBLE_6D *Metric = NULL;

  // declare function data I/O variables

  CHAR_21 *U_Scalar_Labels = NULL;
  CHAR_21 *U_Vector_Labels = NULL;
  CHAR_21 *U_Matrix_Labels = NULL;
  CHAR_21 *U_Metric_Labels = NULL;

  DOUBLE_1D *U_Scalars = NULL;
  DOUBLE_1D *U_Vectors = NULL; // actually _3D
  DOUBLE_1D *U_Matrixes = NULL; // actually _9D
  DOUBLE_1D *U_Metrics = NULL; // actually _6D

  INT_ Number_of_U_Scalars, Number_of_U_Vectors,
       Number_of_U_Matrixes, Number_of_U_Metrics;

  // declare split data I/O variables

  INT_1D *ielc8isplit = NULL;
  INT_1D *ielc8fisplit = NULL;
  INT_9D *inisplit = NULL;

  INT_ nsplit = 0;

  // set input and output file names, list program help, set parameter structure
  // and get input parameters

  Error_Flag = ugc_startup (argc, argv, Input_File_Name, Output_File_Name,
                            &Bnd_Only_Flag, &Mode_Flag,
                            &No_Quad_Flag, &Renumber_ID_Flag,
                            &Separate_by_ID_Flag, &Set_Vol_ID_Flag,
                            &Surf_Quad_Flag, &Surf_Tria_Flag, &Vol_Hex_Flag, 
                            &Vol_Pent_5_Flag, &Vol_Pent_6_Flag, &Vol_Tet_Flag,
                            &Number_of_Rm_Surf_IDs,
                            &Rm_Surf_ID);

  // exit if not in 3D mode

  if (Error_Flag == 0 && Mode_Flag != 3)
    Error_Flag = -1;

  // exit if file names are empty

  if (Error_Flag == 0 && (strcmp (Input_File_Name, "") == 0 || strcmp (Output_File_Name, "") == 0))
  {
    ug_error_message ("*** ERROR 602 : both input and output file names must be specified ***");
    Error_Flag = 602;
  }

  // if output case name is @ then set output case name to input case name

  if (Error_Flag == 0)
  {
    Error_Flag = ug_io_case_name (Output_File_Name, Output_Case_Name);

    if (Error_Flag == 0 && strcmp (Output_Case_Name, "@") == 0)
    {
      Error_Flag = ug_io_case_name (Input_File_Name, Input_Case_Name);

      if (Error_Flag == 0)
        Error_Flag = ug_io_file_suffix (Output_File_Name, Output_File_Suffix);

      if (Error_Flag == 0)
      {
        strcpy (Output_File_Name, Input_Case_Name);
        strcat (Output_File_Name, Output_File_Suffix);
      }
    }
  }

  // get file types

  if (Error_Flag == 0)
    Error_Flag = ug_io_file_type (Input_File_Name, 3, &Input_File_Data_Type);

  if (Error_Flag == 0)
    Error_Flag = ug_io_file_type (Output_File_Name, 3, &Output_File_Data_Type);

  // check file types

  if (Error_Flag == 0)
  {
    if (Input_File_Data_Type == UG_IO_SURFACE_GRID ||
         Input_File_Data_Type == UG_IO_VOLUME_GRID)
    {
      if (Output_File_Data_Type != UG_IO_SURFACE_GRID &&
          Output_File_Data_Type != UG_IO_VOLUME_GRID)
      {
        ug_error_message ("*** ERROR 603 : if input is a grid file then output must be also ***");
        Error_Flag = 603;
      }
    }

    else if (Input_File_Data_Type == UG_IO_NODE_DATA)
    {
      if (Output_File_Data_Type != UG_IO_NODE_DATA)
      {
        ug_error_message ("*** ERROR 604 : if input is a node file then output must be also ***");
        Error_Flag = 604;
      }
    }

    else if (Input_File_Data_Type == UG_IO_FUNCTION_DATA)
    {
      if (Output_File_Data_Type != UG_IO_FUNCTION_DATA)
      {
        ug_error_message ("*** ERROR 605 : if input is a function file then output must be also ***");
        Error_Flag = 605;
      }
    }

    else if (Input_File_Data_Type == UG_IO_SPLIT_DATA)
    {
      if (Output_File_Data_Type != UG_IO_SPLIT_DATA)
      {
        ug_error_message ("*** ERROR 605 : if input is a function file then output must be also ***");
        Error_Flag = 605;
      }
    }

    else
    {
      ug_error_message ("*** ERROR 624 : file is not a grid, node or function data type ***");
        Error_Flag = 624;
    }
  }

  // check file formats 

  if (Error_Flag == 0)
    Error_Flag = ug_file_format_check (Input_File_Name);

  if (Error_Flag == 0)
    Error_Flag = ug_file_format_check (Output_File_Name);

  // start of section to read and write a grid data file

  if (Input_File_Data_Type == UG_IO_SURFACE_GRID ||
      Input_File_Data_Type == UG_IO_VOLUME_GRID)
  {
    // read grid data

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_grid_file (Input_File_Name, 
                                         Message_Flag,
                                         M_BL_Thickness,
                                         M_Initial_Normal_Spacing,
                                         M_Surf_Grid_BC_Flag,
                                         M_Surf_ID_Flag,
                                         M_Surf_Reconnection_Flag,
                                         Set_Vol_ID_Flag,
                                         Bnd_Only_Flag,
                                         No_Quad_Flag,
                                         Renumber_ID_Flag,
                                         Separate_by_ID_Flag,
                                         &Number_of_BL_Vol_Tets,
                                         &Number_of_Nodes,
                                         &Number_of_Bnd_Edges,
                                         &Number_of_Surf_Quads,
                                         &Number_of_Surf_Trias,
                                         &Number_of_Vol_Hexs,
                                         &Number_of_Vol_Pents_5,
                                         &Number_of_Vol_Pents_6,
                                         &Number_of_Vol_Tets,
                                         &Bnd_Edge_ID_Flag,
                                         &Bnd_Edge_Connectivity,
                                         &Surf_Grid_BC_Flag,
                                         &Surf_ID_Flag,
                                         &Surf_Reconnection_Flag,
                                         &Surf_Quad_Connectivity,
                                         &Surf_Tria_Connectivity,
                                         &Vol_Hex_Connectivity,
                                         &Vol_ID_Flag,
                                         &Vol_Pent_5_Connectivity,
                                         &Vol_Pent_6_Connectivity,
                                         &Vol_Tet_Connectivity,
                                         &Coordinates,
                                         &Initial_Normal_Spacing,
                                         &BL_Thickness);

    // modify grid data

    if (Error_Flag == 0)
      Error_Flag = ug_io_rm_faces_elems (Number_of_Rm_Surf_IDs,
                                         &Number_of_Nodes,
                                         &Number_of_Surf_Quads,
                                         &Number_of_Surf_Trias,
                                         &Number_of_Vol_Hexs,
                                         &Number_of_Vol_Pents_5,
                                         &Number_of_Vol_Pents_6,
                                         &Number_of_Vol_Tets,
                                         Surf_Quad_Flag,
                                         Surf_Tria_Flag,
                                         Vol_Hex_Flag,
                                         Vol_Pent_5_Flag,
                                         Vol_Pent_6_Flag,
                                         Vol_Tet_Flag,
                                         Rm_Surf_ID,
                                         Surf_Grid_BC_Flag,
                                         Surf_ID_Flag,
                                         Surf_Quad_Connectivity,
                                         Surf_Reconnection_Flag,
                                         Surf_Tria_Connectivity,
                                         Vol_Hex_Connectivity,
                                         Vol_ID_Flag,
                                         Vol_Pent_5_Connectivity,
                                         Vol_Pent_6_Connectivity,
                                         Vol_Tet_Connectivity,
                                         Coordinates,
                                         Initial_Normal_Spacing,
                                         BL_Thickness);

    ug_free (Rm_Surf_ID);

    Rm_Surf_ID = NULL;

    // output grid data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_grid_file (Output_File_Name, 
                                          Message_Flag,
                                          Number_of_BL_Vol_Tets,
                                          Number_of_Nodes,
                                          Number_of_Bnd_Edges,
                                          Number_of_Surf_Quads,
                                          Number_of_Surf_Trias,
                                          Number_of_Vol_Hexs,
                                          Number_of_Vol_Pents_5,
                                          Number_of_Vol_Pents_6,
                                          Number_of_Vol_Tets,
                                          Bnd_Edge_ID_Flag,
                                          Bnd_Edge_Connectivity,
                                          Surf_Grid_BC_Flag, Surf_ID_Flag,
                                          Surf_Reconnection_Flag,
                                          Surf_Quad_Connectivity,
                                          Surf_Tria_Connectivity,
                                          Vol_Hex_Connectivity, Vol_ID_Flag,
                                          Vol_Pent_5_Connectivity,
                                          Vol_Pent_6_Connectivity,
                                          Vol_Tet_Connectivity,
                                          Coordinates,
                                          Initial_Normal_Spacing, BL_Thickness);

    // free grid data arrays

    ug_io_free_grid (Bnd_Edge_ID_Flag, Bnd_Edge_Connectivity,
                     Surf_Grid_BC_Flag, Surf_ID_Flag, Surf_Reconnection_Flag,
                     Surf_Quad_Connectivity, Surf_Tria_Connectivity,
                     Vol_Hex_Connectivity, Vol_ID_Flag,
                     Vol_Pent_5_Connectivity, Vol_Pent_6_Connectivity,
                     Vol_Tet_Connectivity,
                     Coordinates, Initial_Normal_Spacing, BL_Thickness);
  }

  // start of section to read and write a node data file

  else if (Input_File_Data_Type == UG_IO_NODE_DATA)
  {
    // read node data

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_node_file (Input_File_Name, 
                                         Message_Flag, &Number_of_Nodes,
                                         &Coordinates, &Spacing, &Metric);

    // output node data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_node_file (Output_File_Name, 
                                          Message_Flag, Number_of_Nodes,
                                          Coordinates, Spacing, Metric);

    // free node data arrays

    ug_io_free_node (Coordinates, Spacing, Metric);
  }

  // start of section to read and write a function data file

  else if (Input_File_Data_Type == UG_IO_FUNCTION_DATA)
  {
    // determine function data I/O variables and read data dimensions

    if (Error_Flag == 0)
      Error_Flag = ug_io_read_func_file (Input_File_Name, 
                                         Message_Flag, 3,
                                         &Number_of_Nodes,
                                         &Number_of_U_Scalars,
                                         &Number_of_U_Vectors,
                                         &Number_of_U_Matrixes,
                                         &Number_of_U_Metrics,
                                         &U_Scalar_Labels, &U_Vector_Labels,
                                         &U_Matrix_Labels, &U_Metric_Labels,
                                         &U_Scalars, &U_Vectors,
                                         &U_Matrixes, &U_Metrics);

    // output function data

    if (Error_Flag == 0)
      Error_Flag = ug_io_write_func_file (Output_File_Name, 
                                          Message_Flag, 3, Number_of_Nodes,
                                          Number_of_U_Scalars,
                                          Number_of_U_Vectors,
                                          Number_of_U_Matrixes,
                                          Number_of_U_Metrics,
                                          U_Scalar_Labels, U_Vector_Labels,
                                          U_Matrix_Labels, U_Metric_Labels,
                                          U_Scalars,
                                          (DOUBLE_1D *) U_Vectors,
                                          (DOUBLE_1D *) U_Matrixes,
                                          (DOUBLE_1D *) U_Metrics);

    // free function data arrays

    ug_io_free_func_flag (U_Scalar_Labels, U_Vector_Labels,
                          U_Matrix_Labels, U_Metric_Labels);

    ug_io_free_func (U_Scalars, (DOUBLE_1D *) U_Vectors,
                     (DOUBLE_1D *) U_Matrixes, (DOUBLE_1D *) U_Metrics);
  }

  // start of section to read and write a split data files

  else if (Input_File_Data_Type == UG_IO_SPLIT_DATA)
  {
    // read split data

    if (Error_Flag == 0)
      Error_Flag = ug3_read_split_data_file (Input_File_Name,
                                             Message_Flag, &nsplit,
                                             &ielc8isplit, &ielc8fisplit,
                                             &inisplit);
    // output split data

    if (Error_Flag == 0)
      Error_Flag = ug3_write_split_data_file (Output_File_Name,
                                              Message_Flag, nsplit,
                                              ielc8isplit, ielc8fisplit,
                                              inisplit);

    // free split data arrays

    ug_free (ielc8isplit);
    ug_free (ielc8fisplit);
    ug_free (inisplit);
  }

  return (Error_Flag);
}
