#include "../UG_IO_LIB.h"

#ifdef _ENABLE_CGNS_LIB_
#include "../../cgns/cgns_ug_io.h"
#endif

#ifdef _ENABLE_MESH_LIB_
#include "../../mesh_ug_io/mesh_ug_io.h"
#endif

int main
 (int argc,
  char *argv[])

{

/*
 * -----------------------------------------------------------------------------
 * UGC : UG_IO File Conversion Routine
 * -----------------------------------------------------------------------------
 */

  CHAR_81 Compile_Date, Compile_OS, Text, Version_Date, Version_Number;

  INT_ i, Error_Flag, Mode_Flag;

  Error_Flag = ug_rerun (1, argc, argv);

  if (Error_Flag)
    exit ((int) Error_Flag);

  if (argc > 1)
  {
    if (strcmp (argv[1], "-ver") == 0 || strcmp (argv[1], "--ver") == 0)
    {
      ug_io_version (Compile_Date, Compile_OS, Version_Date, Version_Number);
      snprintf (Text, sizeof(Text), "%s", Version_Number);
      ug_message (Text);
      exit (0);
    }

    else if (strcmp (argv[1], "-build") == 0 || strcmp (argv[1], "--build") == 0 || 
             strcmp (argv[1], "-version") == 0 || strcmp (argv[1], "--version") == 0)
    {
      if (strcmp (argv[1], "-build") == 0 ||  strcmp (argv[1], "--build") == 0)
        ug_message ("TURN_OFF_ug_message_OUTPUT");

      ug_version_info ("ug_io", ug_io_version);
#ifndef _DISABLE_UG_CPP_LIB_
      ug_version_info ("ug_cpp", ug_cpp_version);
#endif
      ug_version_info ("ug3", ug3_version);
      ug_version_info ("ug2", ug2_version);
      ug_version_info ("ug", ug_version);
#ifdef _ENABLE_CGNS_LIB_
        ug_version_info ("cgns", cgns_version);
#endif
#ifdef _ENABLE_MESH_LIB_
        ug_version_info ("mesh_ug_io", mesh_ug_io_version);
#endif

      if (strcmp (argv[1], "-build") == 0 ||  strcmp (argv[1], "--build") == 0)
      {
        ug_message ("TURN_ON_ug_message_OUTPUT");

        ug_version_info ("*Build_Number", NULL);
      }
      else
        ug_version_info ("Build_Number", NULL);

      exit (0);
    }
  }

#ifdef _ENABLE_CGNS_LIB_
  ug_io_cgns_register_read_grid (cgns_ug_io_read_grid);
  ug_io_cgns_register_write_grid (cgns_ug_io_write_grid);
#endif

#ifdef _ENABLE_MESH_LIB_
  ug2_mesh_register_read_grid (mesh_ug_io_read_2d_grid);
  ug2_mesh_register_write_grid (mesh_ug_io_write_2d_grid);
  ug3_mesh_register_read_func (mesh_ug_io_read_func);
  ug3_mesh_register_write_func (mesh_ug_io_write_func);
  ug3_mesh_register_read_grid (mesh_ug_io_read_grid);
  ug3_mesh_register_write_grid (mesh_ug_io_write_grid);
#endif

  // set input and output file names and remove from argument vector

  Mode_Flag = 3;

  i = 1;

  while (i < argc)
  {
    if (strcmp (argv[i], "-2") == 0 || strcmp (argv[i], "-2d") == 0)
      Mode_Flag = 2;

    ++i;
  }

  if (Mode_Flag == 3)
    Error_Flag = ug_io_convert (argc, argv);
  else
    Error_Flag = ug_io_convert_2d (argc, argv);
 
  exit ((int) Error_Flag);
 
}
