#include "UG3_LIB.h"

void ug3_write_volrchk (INT_ mmsg,
                        INT_ nelem,
                        INT_ nelemc5,
                        INT_ nelemc6,
                        INT_ ntface,
                        INT_ nqface,
                        INT_6D * initf,
                        INT_7D * iniqf,
                        INT_1D * qlist,
                        INT_1D * qlist5,
                        INT_1D * qlist6,
                        INT_1D * qlist8,
                        double volr_qmin,
                        double volr_qmin2,
                        DOUBLE_1D * vol)
{

/*
 * Check mixed element volume ratios.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_volrchk.c,v 1.22 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ ielem, jelem, itface, iqface;
  INT_ n_sum = 0;
  INT_ n_volr_qmin = 0;
  INT_ n_volr_qmin2 = 0;
  INT_ qvalue = 16;

  double dc0, dc1,
         vol_max, vol_min, volr, volr_avg, volr_max, volr_min, volr_sum;

  dc0 = 0.0;
  dc1 = 1.0;

  if (mmsg)
  {
    ug_message ("");
    ug_message ("UG3      : VOL NEIGHBOR RATIO CHECK");
    ug_message ("UG3      : VOL NEIGHBOR RATIO = VOL_min / VOL_max");
    ug_message ("");
  }

  volr_max = dc0;
  volr_min = dc1;
  volr_sum = dc0;

  for (itface = 1; itface <= ntface; ++itface)
  {
    ielem = initf[itface][3];
    jelem = initf[itface][4];

    if (ielem > 0 && jelem > 0)
    {
      vol_max = MAX (vol[ielem], vol[jelem]);
      vol_min = MIN (vol[ielem], vol[jelem]);

      volr = vol_min / vol_max;

      volr_max = MAX (volr_max, volr);
      volr_min = MIN (volr_min, volr);
      volr_sum = volr_sum + volr;

      ++n_sum;

      if (volr < volr_qmin)
        ++n_volr_qmin;

      if (volr < volr_qmin2)
      {
        ++n_volr_qmin2;

        if (qlist && ielem <= nelem)
          qlist[ielem] = qlist[ielem] + qvalue;
        else if (qlist5 && ielem <= nelem+nelemc5)
          qlist5[ielem-nelem] = qlist5[ielem-nelem] + qvalue;
        else if (qlist6 && ielem <= nelem+nelemc5+nelemc6)
          qlist6[ielem-nelem-nelemc5] = qlist6[ielem-nelem-nelemc5] + qvalue;
        else if (qlist8)
          qlist8[ielem-nelem-nelemc5-nelemc6] = qlist8[ielem-nelem-nelemc5-nelemc6] + qvalue;

        if (qlist && jelem <= nelem)
          qlist[jelem] = qlist[jelem] + qvalue;
        else if (qlist5 && jelem <= nelem+nelemc5)
          qlist5[jelem-nelem] = qlist5[jelem-nelem] + qvalue;
        else if (qlist6 && jelem <= nelem+nelemc5+nelemc6)
          qlist6[jelem-nelem-nelemc5] = qlist6[jelem-nelem-nelemc5] + qvalue;
        else if (qlist8)
          qlist8[jelem-nelem-nelemc5-nelemc6] = qlist8[jelem-nelem-nelemc5-nelemc6] + qvalue;
      }
    }
  }

  for (iqface = 1; iqface <= nqface; ++iqface)
  {
    ielem = iniqf[iqface][4];
    jelem = iniqf[iqface][5];

    if (ielem > 0 && jelem > 0)
    {
      vol_max = MAX (vol[ielem], vol[jelem]);
      vol_min = MIN (vol[ielem], vol[jelem]);

      volr = vol_min / vol_max;

      volr_max = MAX (volr_max, volr);
      volr_min = MIN (volr_min, volr);
      volr_sum = volr_sum + volr;

      ++n_sum;

      if (volr < volr_qmin)
        ++n_volr_qmin;

      if (volr < volr_qmin2)
      {
        ++n_volr_qmin2;

        if (qlist && ielem <= nelem)
          qlist[ielem] = qlist[ielem] + qvalue;
        else if (qlist5 && ielem <= nelem+nelemc5)
          qlist5[ielem-nelem] = qlist5[ielem-nelem] + qvalue;
        else if (qlist6 && ielem <= nelem+nelemc5+nelemc6)
          qlist6[ielem-nelem-nelemc5] = qlist6[ielem-nelem-nelemc5] + qvalue;
        else if (qlist8)
          qlist8[ielem-nelem-nelemc5-nelemc6] = qlist8[ielem-nelem-nelemc5-nelemc6] + qvalue;

        if (qlist && jelem <= nelem)
          qlist[jelem] = qlist[jelem] + qvalue;
        else if (qlist5 && jelem <= nelem+nelemc5)
          qlist5[jelem-nelem] = qlist5[jelem-nelem] + qvalue;
        else if (qlist6 && jelem <= nelem+nelemc5+nelemc6)
          qlist6[jelem-nelem-nelemc5] = qlist6[jelem-nelem-nelemc5] + qvalue;
        else if (qlist8)
          qlist8[jelem-nelem-nelemc5-nelemc6] = qlist8[jelem-nelem-nelemc5-nelemc6] + qvalue;
      }
    }
  }

  if (mmsg)
  {
    volr_avg = volr_sum / ((double) n_sum);

    snprintf (Text, sizeof(Text), "UG3      : Min, Max Vol Ratio=%10.3g%10.3g", volr_min, volr_max);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Average Vol Ratio =%10.3g", volr_avg);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : No. VR<%10.3g =%10i", volr_qmin, (int) n_volr_qmin);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : No. VR<%10.3g =%10i", volr_qmin2, (int) n_volr_qmin2);
    ug_message (Text);
  }

  return;
}
