#include "UG3_LIB.h"

void ug3_write_volchk (INT_ mmsg,
                       INT_ nelem,
                       INT_ nelemc5,
                       INT_ nelemc6,
                       INT_ nelemc8,
                       INT_ task,
                       INT_4D * iniel,
                       INT_5D * inielc5,
                       INT_6D * inielc6,
                       INT_8D * inielc8,
                       INT_1D * qlist,
                       INT_1D * qlist5,
                       INT_1D * qlist6,
                       INT_1D * qlist8,
                       double tol,
                       DOUBLE_3D * x)
{

/*
 * Check mixed element volumes.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_volchk.c,v 1.30 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  static INT_ neg_vol = 0;
  static INT_ neg_vol5 = 0;
  static INT_ neg_vol6 = 0;
  static INT_ neg_vol8 = 0;

  static double vol_min = 0;
  static double vol_sum = 0;
  static double vol5_min = 0;
  static double vol5_sum = 0;
  static double vol6_min = 0;
  static double vol6_sum = 0;
  static double vol8_min = 0;
  static double vol8_sum = 0;

  INT_ i, i1, i2, i3, i4, i5, i6, i7, i8;
  INT_ i_neg_vol = 0;
  INT_ qvalue = 8;

  double dc0, dc1, dc6, dc1d6, vol, vol_avg, vol_total;

  dc0 = 0.0;
  dc1 = 1.0;
  dc6 = 6.0;

  dc1d6 = dc1 / dc6;

  if (task == 1 || task == 3)
  {
    for (i = 1; i <= nelem; ++i)
    {
      i1 = iniel[i][0];
      i2 = iniel[i][1];
      i3 = iniel[i][2];
      i4 = iniel[i][3];

      i_neg_vol = ug3_chk_tet_vol (i1, i2, i3, i4, tol, &vol, x);

      vol = dc1d6 * vol;

      if (i_neg_vol)
      {
        ++neg_vol;

        if (qlist) qlist[i] = qlist[i] + qvalue;
      }

      if (vol_min == dc0  || vol <= vol_min)
        vol_min = vol;

      vol_sum = vol_sum + vol;
    }

    for (i = 1; i <= nelemc5; ++i)
    {
      i1 = inielc5[i][0];
      i2 = inielc5[i][1];
      i3 = inielc5[i][2];
      i4 = inielc5[i][3];
      i5 = inielc5[i][4];

      i_neg_vol = ug3_chk_pyramid_vol (i1, i2, i3, i4, i5, tol, &vol, x);

      vol = dc1d6 * vol;

      if (i_neg_vol)
      {
        ++neg_vol5;

        if (qlist5) qlist5[i] = qlist5[i] + qvalue;
      }

      if (vol5_min == dc0  || vol <= vol5_min)
        vol5_min = vol;

      vol5_sum = vol5_sum + vol;
    }

    for (i = 1; i <= nelemc6; ++i)
    {
      i1 = inielc6[i][0];
      i2 = inielc6[i][1];
      i3 = inielc6[i][2];
      i4 = inielc6[i][3];
      i5 = inielc6[i][4];
      i6 = inielc6[i][5];

      i_neg_vol = ug3_chk_prism_vol (i1, i2, i3, i4, i5, i6, tol, &vol, x);

      vol = dc1d6 * vol;

      if (i_neg_vol)
      {
        ++neg_vol6;

        if (qlist6) qlist6[i] = qlist6[i] + qvalue;
      }

      if (vol6_min == dc0  || vol <= vol6_min)
        vol6_min = vol;

      vol6_sum = vol6_sum + vol;
    }

    for (i = 1; i <= nelemc8; ++i)
    {
      i1 = inielc8[i][0];
      i2 = inielc8[i][1];
      i3 = inielc8[i][2];
      i4 = inielc8[i][3];
      i5 = inielc8[i][4];
      i6 = inielc8[i][5];
      i7 = inielc8[i][6];
      i8 = inielc8[i][7];

      i_neg_vol = ug3_chk_hex_vol (i1, i2, i3, i4, i5, i6, i7, i8, tol, &vol, x);

      vol = dc1d6 * vol;

      if (i_neg_vol)
      {
        ++neg_vol8;

        if (qlist8) qlist8[i] = qlist8[i] + qvalue;
      }

      if (vol8_min == dc0  || vol <= vol8_min)
        vol8_min = vol;

      vol8_sum = vol8_sum + vol;
    }
  }

  if ((task == 2 || task == 3) && mmsg)
  {
    vol_total = vol_sum + vol5_sum + vol6_sum + vol8_sum;

    ug_message ("");
    ug_message ("UG3      : VOL CHECK");
    ug_message ("");
    snprintf (Text, sizeof(Text), "UG3      : Total-Volume      =%10.3g", vol_total);
    ug_message (Text);

    if (nelem)
    {
      vol_avg = vol_sum / ((double) nelem);

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Tet Elems     =%10i", (int) nelem);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min Vol           =%10.3g", vol_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Vol       =%10.3g", vol_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Total-Tet-Vol     =%10.3g", vol_sum);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Vol<TOL       =%10i", (int) neg_vol);
      ug_message (Text);
    }

    if (nelemc5)
    {
      vol_avg = vol5_sum / ((double) nelemc5);

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Pyramid Elems =%10i", (int) nelemc5);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min Vol           =%10.3g", vol5_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Vol       =%10.3g", vol_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Total-Pyramid-Vol =%10.3g", vol5_sum);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Vol<TOL       =%10i", (int) neg_vol5);
      ug_message (Text);
    }

    if (nelemc6)
    {
      vol_avg = vol6_sum / ((double) nelemc6);

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Prism Elems   =%10i", (int) nelemc6);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min Vol           =%10.3g", vol6_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Vol       =%10.3g", vol_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Total-Prism-Vol   =%10.3g", vol6_sum);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Vol<TOL       =%10i", (int) neg_vol6);
      ug_message (Text);
    }

    if (nelemc8)
    {
      vol_avg = vol8_sum / ((double) nelemc8);

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Hex Elems     =%10i", (int) nelemc8);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min Vol           =%10.3g", vol_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Vol       =%10.3g", vol_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Total-Hex-Vol     =%10.3g", vol8_sum);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Vol<TOL       =%10i", (int) neg_vol);
      ug_message (Text);
    }
  }

  if (task == 2 || task == 3)
  {
    neg_vol = 0;
    neg_vol5 = 0;
    neg_vol6 = 0;
    neg_vol8 = 0;

    vol_min = 0;
    vol_sum = 0;
    vol5_min = 0;
    vol5_sum = 0;
    vol6_min = 0;
    vol6_sum = 0;
    vol8_min = 0;
    vol8_sum = 0;
  }

  return;
}
