#include "UG3_LIB.h"

INT_ ug3_write_ugrid (FILE * Grid_File,
                      INT_ File_Format,
                      INT_ Write_Task_Flag,
                      INT_ Number_of_BL_Vol_Tets,
                      INT_ Number_of_Nodes,
                      INT_ Number_of_Surf_Quads,
                      INT_ Number_of_Surf_Trias,
                      INT_ Number_of_Vol_Hexs,
                      INT_ Number_of_Vol_Pents_5,
                      INT_ Number_of_Vol_Pents_6,
                      INT_ Number_of_Vol_Tets,
                      INT_1D * Surf_ID_Flag,
                      INT_4D * Surf_Quad_Connectivity,
                      INT_3D * Surf_Tria_Connectivity,
                      INT_8D * Vol_Hex_Connectivity,
                      INT_1D * Vol_ID_Flag,
                      INT_5D * Vol_Pent_5_Connectivity,
                      INT_6D * Vol_Pent_6_Connectivity,
                      INT_4D * Vol_Tet_Connectivity,
                      DOUBLE_3D * Coordinates)
{

/*
 * Incrementally write grid data to a UGRID volume grid file.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_ugrid.c,v 1.20 2021/02/07 01:45:09 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  static INT_ Previous_Task_Flag = 0;
  static INT_ Number_of_Bytes = 0;
  static INT_ Number_of_Vol_Elems = 0;

  INT_ ID, Index;
  INT_ Write_Flag = 0;

  float TMP_float;

  if (File_Format == UG_FIO_FORMATTED)
  {
    if (Write_Task_Flag == 1 || Write_Task_Flag == -1)
    {
      Number_of_Vol_Elems = Number_of_Vol_Tets + Number_of_Vol_Pents_5 + Number_of_Vol_Pents_6 + Number_of_Vol_Hexs;

      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i %i\n",
                            (int) Number_of_Nodes,
                            (int) Number_of_Surf_Trias,
                            (int) Number_of_Surf_Quads,
                            (int) Number_of_Vol_Tets,
                            (int) Number_of_Vol_Pents_5,
                            (int) Number_of_Vol_Pents_6,
                            (int) Number_of_Vol_Hexs);

      Previous_Task_Flag = 1;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -2))
    {
      for (Index = 1; Index <= Number_of_Nodes; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%.15g %.15g %.15g\n",
                              Coordinates[Index][0],
                              Coordinates[Index][1],
                              Coordinates[Index][2]);
      }

      Previous_Task_Flag = 2;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -3))
    {
      for (Index = 1; Index <= Number_of_Surf_Trias; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%i %i %i\n",
                              (int) Surf_Tria_Connectivity[Index][0],
                              (int) Surf_Tria_Connectivity[Index][1],
                              (int) Surf_Tria_Connectivity[Index][2]);
      }

      if (Write_Flag >= 0)
      {
        for (Index = 1; Index <= Number_of_Surf_Quads; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "%i %i %i %i\n",
                                (int) Surf_Quad_Connectivity[Index][0],
                                (int) Surf_Quad_Connectivity[Index][1],
                                (int) Surf_Quad_Connectivity[Index][2],
                                (int) Surf_Quad_Connectivity[Index][3]);
        }
      }

      if (Write_Flag >= 0)
      {
        for (Index = 1; Index <= Number_of_Surf_Quads+Number_of_Surf_Trias; ++Index)
        {
          Write_Flag = fprintf (Grid_File, "%i\n", (int) Surf_ID_Flag[Index]);
        }
      }

      Previous_Task_Flag = 3;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -4))
    {
      for (Index = 1; Index <= Number_of_Vol_Tets; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%i %i %i %i\n",
                              (int) Vol_Tet_Connectivity[Index][0],
                              (int) Vol_Tet_Connectivity[Index][1],
                              (int) Vol_Tet_Connectivity[Index][2],
                              (int) Vol_Tet_Connectivity[Index][3]);
      }

      Previous_Task_Flag = 4;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -5))
    {
      for (Index = 1; Index <= Number_of_Vol_Pents_5; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%i %i %i %i %i\n",
                              (int) Vol_Pent_5_Connectivity[Index][0],
                              (int) Vol_Pent_5_Connectivity[Index][1],
                              (int) Vol_Pent_5_Connectivity[Index][2],
                              (int) Vol_Pent_5_Connectivity[Index][3],
                              (int) Vol_Pent_5_Connectivity[Index][4]);
      }

      Previous_Task_Flag = 5;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -6))
    {
      for (Index = 1; Index <= Number_of_Vol_Pents_6; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i\n",
                              (int) Vol_Pent_6_Connectivity[Index][0],
                              (int) Vol_Pent_6_Connectivity[Index][1],
                              (int) Vol_Pent_6_Connectivity[Index][2],
                              (int) Vol_Pent_6_Connectivity[Index][3],
                              (int) Vol_Pent_6_Connectivity[Index][4],
                              (int) Vol_Pent_6_Connectivity[Index][5]);
      }

      Previous_Task_Flag = 6;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -7))
    {
      for (Index = 1; Index <= Number_of_Vol_Hexs; ++Index)
      {
        Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i %i %i\n",
                              (int) Vol_Hex_Connectivity[Index][0],
                              (int) Vol_Hex_Connectivity[Index][1],
                              (int) Vol_Hex_Connectivity[Index][2],
                              (int) Vol_Hex_Connectivity[Index][3],
                              (int) Vol_Hex_Connectivity[Index][4],
                              (int) Vol_Hex_Connectivity[Index][5],
                              (int) Vol_Hex_Connectivity[Index][6],
                              (int) Vol_Hex_Connectivity[Index][7]);
      }

      Previous_Task_Flag = 7;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -8))
    {
      if (Number_of_Vol_Elems)
        Write_Flag = fprintf (Grid_File, "%i\n", (int) Number_of_BL_Vol_Tets);

      Previous_Task_Flag = 8;
    }

    if (Write_Flag >= 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -9))
    {
      if (Vol_ID_Flag)
      {
        for (Index = 1; Index <= Number_of_Vol_Tets
                               + Number_of_Vol_Pents_5
                               + Number_of_Vol_Pents_6
                               + Number_of_Vol_Hexs; ++Index)
        {
          ID = Vol_ID_Flag[Index];

          Write_Flag = fprintf (Grid_File, "%i\n", (int) ID);
        }
      }

      Previous_Task_Flag = 9;
    }
  }

  else
  {
    Write_Flag = 0;

    if (Write_Task_Flag == 1 || Write_Task_Flag == -1)
    {
      Number_of_Vol_Elems = Number_of_Vol_Tets + Number_of_Vol_Pents_5 + Number_of_Vol_Pents_6 + Number_of_Vol_Hexs;

      Number_of_Bytes = 7 * ((INT_) (sizeof (INT_)));

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Nodes, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Surf_Trias, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Surf_Quads, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Vol_Tets, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Vol_Pents_5, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Vol_Pents_6, sizeof (INT_), 1, Grid_File);
      Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Vol_Hexs, sizeof (INT_), 1, Grid_File);

      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

      Previous_Task_Flag = 1;

      Number_of_Bytes = 3 * Number_of_Nodes * ((File_Format == UG_FIO_UNFORMATTED_DOUBLE) ? (INT_) (sizeof (double)): (sizeof (float)))
                      + Number_of_Surf_Trias * ((INT_) (sizeof (INT_3D)))
                      + Number_of_Surf_Quads * ((INT_) (sizeof (INT_4D)))
                      + (Number_of_Surf_Quads + Number_of_Surf_Trias) * ((INT_) (sizeof (INT_1D)))
                      + Number_of_Vol_Tets * ((INT_) (sizeof (INT_4D)))
                      + Number_of_Vol_Pents_5 * ((INT_) (sizeof (INT_5D)))
                      + Number_of_Vol_Pents_6 * ((INT_) (sizeof (INT_6D)))
                      + Number_of_Vol_Hexs * ((INT_) (sizeof (INT_8D)));
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -2))
    {
      if (Previous_Task_Flag == 1 && (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE))
        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

      if (File_Format == UG_FIO_UNFORMATTED_SINGLE || File_Format == UG_FIO_BINARY_SINGLE)
      {
        for (Index = 1; Index <= Number_of_Nodes; ++Index)
        {
          TMP_float = (float) Coordinates[Index][0];

          Write_Flag = Write_Flag - 1 + ug_fwrite (&TMP_float, sizeof (float), 1, Grid_File);

          TMP_float = (float) Coordinates[Index][1];

          Write_Flag = Write_Flag - 1 + ug_fwrite (&TMP_float, sizeof (float), 1, Grid_File);

          TMP_float = (float) Coordinates[Index][2];

          Write_Flag = Write_Flag - 1 + ug_fwrite (&TMP_float, sizeof (float), 1, Grid_File);
        }
      }
      else
      {
        Write_Flag = Write_Flag + ug_fwrite (&Coordinates[1][0], sizeof (double), Number_of_Nodes*3, Grid_File);
        Write_Flag = Write_Flag - Number_of_Nodes*3;
      }

      Previous_Task_Flag = 2;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -3))
    {
      Write_Flag = Write_Flag + ug_fwrite (&Surf_Tria_Connectivity[1][0], sizeof (INT_), Number_of_Surf_Trias*3, Grid_File);
      Write_Flag = Write_Flag - Number_of_Surf_Trias*3;
      Write_Flag = Write_Flag + ug_fwrite (&Surf_Quad_Connectivity[1][0], sizeof (INT_), Number_of_Surf_Quads*4, Grid_File);
      Write_Flag = Write_Flag - Number_of_Surf_Quads*4;
      Write_Flag = Write_Flag + ug_fwrite (&Surf_ID_Flag[1], sizeof (INT_), Number_of_Surf_Trias+Number_of_Surf_Quads, Grid_File);
      Write_Flag = Write_Flag - Number_of_Surf_Trias-Number_of_Surf_Quads;

      Previous_Task_Flag = 3;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -4))
    {
      Write_Flag = ug_fwrite (&Vol_Tet_Connectivity[1][0], sizeof (INT_1D), Number_of_Vol_Tets*4, Grid_File);
      Write_Flag = Write_Flag - Number_of_Vol_Tets*4;

      Previous_Task_Flag = 4;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -5))
    {
      Write_Flag = ug_fwrite (&Vol_Pent_5_Connectivity[1][0], sizeof (INT_), Number_of_Vol_Pents_5*5, Grid_File); 
      Write_Flag = Write_Flag - Number_of_Vol_Pents_5*5;

      Previous_Task_Flag = 5;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -6))
    {
      Write_Flag = ug_fwrite (&Vol_Pent_6_Connectivity[1][0], sizeof (INT_), Number_of_Vol_Pents_6*6, Grid_File); 
      Write_Flag = Write_Flag - Number_of_Vol_Pents_6*6;

      Previous_Task_Flag = 6;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -7))
    {
      Write_Flag = ug_fwrite (&Vol_Hex_Connectivity[1][0], sizeof (INT_), Number_of_Vol_Hexs*8, Grid_File); 
      Write_Flag = Write_Flag - Number_of_Vol_Hexs*8;

      Previous_Task_Flag = 7;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -8))
    {
      if (Previous_Task_Flag == 7 && (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE))
        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

      if (Number_of_Vol_Elems)
      {
        Number_of_Bytes = (INT_) (sizeof (INT_));

        if (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE)
          Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_BL_Vol_Tets, sizeof (INT_), 1, Grid_File); 
                                          
        if (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE)
          Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);
      }

      Previous_Task_Flag = 8;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -9))
    {
      if (Vol_ID_Flag)
      {
        Number_of_Bytes = (Number_of_Vol_Tets
                         + Number_of_Vol_Pents_5
                         + Number_of_Vol_Pents_6
                         + Number_of_Vol_Hexs) * ((INT_) (sizeof (INT_)));

        if (Previous_Task_Flag == 8 && (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE))
          Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

        for (Index = 1; Index <= Number_of_Vol_Tets
                               + Number_of_Vol_Pents_5
                               + Number_of_Vol_Pents_6
                               + Number_of_Vol_Hexs; ++Index)
        {
          ID = Vol_ID_Flag[Index];

          Write_Flag = Write_Flag-1 + ug_fwrite (&ID, sizeof (INT_), 1, Grid_File);
        }
      }

      Previous_Task_Flag = 9;
    }

    if (Write_Flag == 0 && (Write_Task_Flag == 1 || Write_Task_Flag == -10))
    {
      if (File_Format == UG_FIO_UNFORMATTED_DOUBLE || File_Format == UG_FIO_UNFORMATTED_SINGLE)
        Write_Flag = Write_Flag - 1 + ug_fwrite (&Number_of_Bytes, sizeof (INT_), 1, Grid_File);

      Previous_Task_Flag = 0;
      Number_of_Bytes = 0;
      Number_of_Vol_Elems = 0;
    }
  }

  if (Write_Flag < 0)
    return (1);

  return (0);

}
