#include "UG3_LIB.h"

INT_ ug3_write_surf_grid_file
 (char File_Name[],
  INT_ Message_Flag,
  INT_ Number_of_Nodes,
  INT_ Number_of_Surf_Quads,
  INT_ Number_of_Surf_Trias,
  INT_1D * Surf_Grid_BC_Flag,
  INT_1D * Surf_ID_Flag,
  INT_4D * Surf_Quad_Connectivity,
  INT_1D * Surf_Reconnection_Flag,
  INT_3D * Surf_Tria_Connectivity,
  DOUBLE_3D * Coordinates)

{

/*
 * Write grid data to a SURF, MESH or MESHB surface grid file.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_surf_grid_file.c,v 1.34 2025/09/08 12:14:00 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX drive, dname, ext, fname, File_Type, Text;
  CHAR_51 Name_Text;

  FILE *Grid_File = NULL;

  INT_1D *Surf_ID_Flag_ = NULL;

  INT_ File_Mode, File_Format, Number_of_Bnd_Nodes;
  INT_ add_type = 1;
  INT_ check_rmesh = 0;
  INT_ check_rsol = 0;
  INT_ check_wmesh = 0;
  INT_ check_wsol = 0;
  INT_ ierr = 0;
  INT_ M_Surf_ID_Flag_ = 0;

  if (strstr (File_Name, ".surf")) {
    if (strcmp (strstr (File_Name, ".surf"), ".surf") == 0) add_type = 0;
  }
  if (add_type && strstr (File_Name, ".meshb")) {
    if (strcmp (strstr (File_Name, ".meshb"), ".meshb") == 0) add_type = 0;
  }
  if (add_type && strstr (File_Name, ".mesh")) {
    if (strcmp (strstr (File_Name, ".mesh"), ".mesh") == 0) add_type = 0;
  }

  if (add_type)
    strcat (File_Name, ".surf");

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  ug_backup_file (File_Name);

  if (ug_file_status_monitor_flag())
  {
    snprintf (Text, sizeof(Text), "ug3_write_surf_grid_file : writing SURF file with File_Name=%s",File_Name);
    ug_message (Text);
  }

  Grid_File = ug_fopen (File_Name, "w");

  if (Grid_File == NULL)
  {
    ug_error_message ("*** ERROR 339 : error writing SURF surface grid file ***");
    return (339);
  }

  if (Message_Flag)
  { 
    ug_message (" ");
    ug_message ("UG3      : OUTPUT GRID");
    ug_message (" ");

    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "UG3      : Surf Grid FileName= %s", Name_Text);
    ug_message (Text);
  }

  if (Surf_ID_Flag == NULL) {

    M_Surf_ID_Flag_ = 1;

    Surf_ID_Flag_ = (INT_1D *) ug_malloc (&ierr, (Number_of_Surf_Quads+Number_of_Surf_Trias+1)*sizeof(INT_1D));

    if (ierr) {
      ug_free (Surf_ID_Flag_);
      ug_error_message ("*** ERROR 100358 : unable to allocate required memory ***");
      return (100358);
    }

    memset (Surf_ID_Flag_, 1,  (Number_of_Surf_Quads+Number_of_Surf_Trias+1)*sizeof(INT_1D));
  }
  else
    Surf_ID_Flag_ = Surf_ID_Flag;

  ug3_check_read_write_mesh_sol (&check_rmesh, &check_rsol, &check_wmesh, &check_wsol);

  if (strcmp (File_Type, ".surf") == 0) {
    ierr = ug3_write_surf (Grid_File,
                           &Number_of_Bnd_Nodes, Number_of_Nodes,
                           Number_of_Surf_Quads, Number_of_Surf_Trias,
                           Surf_Grid_BC_Flag, Surf_ID_Flag_,
                           Surf_Quad_Connectivity, Surf_Reconnection_Flag,
                           Surf_Tria_Connectivity,
                           Coordinates, NULL, NULL);

    ug_fclose (Grid_File);
  }

  else if (strcmp (File_Type, ".mesh") == 0 || strcmp (File_Type, ".meshb") == 0)
  {
    if (check_wmesh)
    {
      ug_fclose (Grid_File);

      ierr = ug3_write_mesh (File_Name, 1,
                             Number_of_Nodes,
                             0, Number_of_Surf_Quads, Number_of_Surf_Trias,
                             0, 0, 0, 0,
                             NULL, NULL, Surf_ID_Flag_,
                             Surf_Quad_Connectivity, Surf_Tria_Connectivity,
                             NULL, NULL, NULL, NULL, NULL,
                             Coordinates);
    }
    else if (strcmp (File_Type, ".mesh") == 0) {
      ierr = ug3_write_mesh0 (Grid_File,
                              Number_of_Nodes,
                              0, Number_of_Surf_Quads, Number_of_Surf_Trias,
                              0, 0, 0, 0,
                              NULL, NULL, Surf_ID_Flag_,
                              Surf_Quad_Connectivity, Surf_Tria_Connectivity,
                              NULL, NULL, NULL, NULL, NULL,
                              Coordinates);

      ug_fclose (Grid_File);
    }

    if (ierr)
    {
      if (M_Surf_ID_Flag_) ug_free (Surf_ID_Flag_);
      ug_error_message ("*** ERROR 339 : error writing MESH/MESHB grid file ***");
      return (339);
    }
  }

  else
  {
    if (M_Surf_ID_Flag_) ug_free (Surf_ID_Flag_);
    ug_error_message ("*** ERROR 339 : illegal grid file type ***");
    if (check_wmesh)
      ug_error_message ("*** only SURF, MESH and MESHB file types are supported ***");
    else
      ug_error_message ("*** only SURF and MESH file types are supported ***");
    return (339);
  }

  if (M_Surf_ID_Flag_) ug_free (Surf_ID_Flag_);

  if (ierr)
    return (339);

  if (Message_Flag)
  { 
    snprintf (Text, sizeof(Text), "UG3      : Quad Surface Faces=%10i", (int) Number_of_Surf_Quads);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Tria Surface Faces=%10i", (int) Number_of_Surf_Trias);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) Number_of_Nodes);
    ug_message (Text);
    ug_message (" ");
  }

  return (0);

}
