#include "UG3_LIB.h"

INT_ ug3_write_split_data_file (char File_Name[],
                                INT_ mmsg,
                                INT_ nsplit,
                                INT_1D * ielc8isplit,
                                INT_1D * ielc8fisplit,
                                INT_9D * inisplit)
{

/*
 * Write hex-element split-face data to a SPLIT data file.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_split_data_file.c,v 1.11 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX drive, dname, ext, fname, File_Type, Text;
  CHAR_51 Name_Text;

  FILE *Data_File;

  INT_ i, File_Mode, File_Format, isplit;
  INT_ ierr = 0;
  INT_ Write_Flag = 1;

  if (nsplit == 0)
    return (0);

  ierr = ug_file_format_check (File_Name);

  if (ierr)
    return (ierr);

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  if (strcmp (File_Type, ".split"))
    return (0);

  ug_splitpath (File_Name, drive, dname, fname, ext);

  strcat (fname, ext);
  strcpy (Name_Text, "");
  strncat (Name_Text, fname, 50);

  if (ug_file_status_monitor_flag())
  {
    snprintf (Text, sizeof(Text), "ug3_write_split_data_file : writing file with File_Name=%s File_Type=%s File_Format=%i", Name_Text, File_Type, (int) File_Format);
    ug_message (Text);
  }

  ug_backup_file (File_Name);

  Data_File = ug_fopen (File_Name, "w");

  if (Data_File == NULL)
  {
    ug_error_message ("*** ERROR 346 : error opening SPLIT data file ***");
    return (346);
  }

  if (mmsg >= 1)
  { 
    ug_message (" ");
    ug_message ("UG3      : OUTPUT SPLIT DATA");
    ug_message (" ");

    snprintf (Text, sizeof(Text), "UG3      : Split File Name   = %s", Name_Text);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Hex-Split-Faces   =%10i", (int) nsplit);
    ug_message (Text);
  }

  if (File_Format == UG_FIO_FORMATTED)
    Write_Flag = fprintf (Data_File, "%i\n", (int) nsplit);
  else
    Write_Flag = ug_fwrite (&nsplit, sizeof (INT_), 1, Data_File);

  isplit = 1;

  while (isplit <= nsplit && Write_Flag > 0)
  {
    if (File_Format == UG_FIO_FORMATTED)
      Write_Flag = fprintf (Data_File, "%i %i %i %i %i %i %i %i %i %i %i\n",
                                       (int) ielc8isplit[isplit],
                                       (int) ielc8fisplit[isplit],
                                       (int) inisplit[isplit][0],
                                       (int) inisplit[isplit][1],
                                       (int) inisplit[isplit][2],
                                       (int) inisplit[isplit][3],
                                       (int) inisplit[isplit][4],
                                       (int) inisplit[isplit][5],
                                       (int) inisplit[isplit][6],
                                       (int) inisplit[isplit][7],
                                       (int) inisplit[isplit][8]);
    else
    {
      Write_Flag = ug_fwrite (&(ielc8isplit[isplit]), sizeof (INT_), 1, Data_File);
      Write_Flag = ug_fwrite (&(ielc8fisplit[isplit]), sizeof (INT_), 1, Data_File);
      for (i = 0; i < 9; ++i)
      {
        Write_Flag = ug_fwrite (&(inisplit[isplit][i]), sizeof (INT_), 1, Data_File);
      }
    }

    ++isplit;
  }

  ug_fclose (Data_File);

  if (Write_Flag <= 0)
  {
    ug_error_message ("*** ERROR 347 : error writing SPLIT data file ***");
    return (347);
  }

  return (0);
}
