#include "UG3_LIB.h"

/*
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_qvrrchk.c,v 1.6 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

void ug3_write_qvrrchk (
  INT_ mmsg,
  INT_ nelem,
  INT_ nelemc5,
  INT_ nelemc6,
  INT_ nelemc8,
  INT_ task,
  INT_4D * iniel,
  INT_5D * inielc5,
  INT_6D * inielc6,
  INT_8D * inielc8,
  INT_1D * qlist,
  INT_1D * qlist5,
  INT_1D * qlist6,
  INT_1D * qlist8,
  double qmin,
  double qmin2,
  DOUBLE_3D * x)
{

  // Check and output mixed element volume to circum-radius cubed function, q.


  CHAR_UG_MAX Text;

  static INT_ n_q_min = 0;
  static INT_ n_q_min2 = 0;
  static INT_ n_q5_min = 0;
  static INT_ n_q5_min2 = 0;
  static INT_ n_q6_min = 0;
  static INT_ n_q6_min2 = 0;
  static INT_ n_q8_min = 0;
  static INT_ n_q8_min2 = 0;

  static double q_max = 0;
  static double q_min = 1;
  static double q_sum = 0;
  static double q5_max = 0;
  static double q5_min = 1;
  static double q5_sum = 0;
  static double q6_max = 0;
  static double q6_min = 1;
  static double q6_sum = 0;
  static double q8_max = 0;
  static double q8_min = 1;
  static double q8_sum = 0;

  INT_ i;

  double q, q_avg, q5_avg, q6_avg, q8_avg;

  if (task == 1 || task == 3) {

    q_max = 0;

    for (i = 1; i <= nelem; i++) {

      q = ug3_tet_qvrr (iniel[i], x);

      q_max = MAX (q_max, q);
      q_min = MIN (q_min, q);
      q_sum = q_sum + q;

      if (q < qmin) n_q_min++;
      if (q < qmin2) n_q_min2++;

      if (q < qmin2 && qlist)  qlist[i] = qlist[i] + 4;
    }

    q_avg = q_sum / ((double) nelem);

    for (i = 1; i <= nelemc5; i++) {

      q = ug3_pyramid_qvrr (inielc5[i], x);

      q5_max = MAX (q5_max, q);
      q5_min = MIN (q5_min, q);
      q5_sum = q5_sum + q;

      if (q < qmin) n_q5_min++;
      if (q < qmin2) n_q5_min2++;

      if (q < qmin2 && qlist5)  qlist5[i] = qlist5[i] + 4;
    }

    q5_avg = q5_sum / ((double) nelemc5);

    q6_max = 0;

    for (i = 1; i <= nelemc6; i++) {

      q = ug3_prism_qvrr (inielc6[i], x);

      q6_max = MAX (q6_max, q);
      q6_min = MIN (q6_min, q);
      q6_sum = q6_sum + q;

      if (q < qmin) n_q6_min++;
      if (q < qmin2) n_q6_min2++;

      if (q < qmin2 && qlist6)  qlist6[i] = qlist6[i] + 4;
    }

    q6_avg = q6_sum / ((double) nelemc6);

    q8_max = 0;

    for (i = 1; i <= nelemc8; i++) {

      q = ug3_hex_qvrr (inielc8[i], x);

      q8_max = MAX (q8_max, q);
      q8_min = MIN (q8_min, q);
      q8_sum = q8_sum + q;

      if (q < qmin) n_q8_min++;
      if (q < qmin2) n_q8_min2++;

      if (q < qmin2 && qlist8)  qlist8[i] = qlist8[i] + 4;
    }

    q8_avg = q8_sum / ((double) nelemc8);
  }

  if ((task == 2 || task == 3) && mmsg) {

    ug_message ("");
    ug_message ("UG3      : Q VOL-CIRCUM_RADIUS-RATIO CHECK");
    ug_message ("                            3");
    ug_message ("UG3      : Q = c * Vol / ( R  )");
    ug_message ("UG3      : 0 <= Q <= 1");
    if (nelemc5 || nelemc6 || nelemc8) {
      ug_message ("UG3      : Note that Q for non-tet elements is minimum Q of tets created by");
      ug_message ("           conversion of non-tet element to tets");
    }

    if (nelem) {

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Tet Elems     =%10i", (int) nelem);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Q        =%10.3g%10.3g", q_min, q_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Q         =%10.3g", q_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin, (int) n_q_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin2, (int) n_q_min2);
      ug_message (Text);
    }

    if (nelemc5) {

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Pyramid Elems =%10i", (int) nelemc5);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Q        =%10.3g%10.3g", q5_min, q5_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Q         =%10.3g", q5_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin, (int) n_q5_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin2, (int) n_q5_min2);
      ug_message (Text);
    }

    if (nelemc6) {

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Prism Elems   =%10i", (int) nelemc6);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Q        =%10.3g%10.3g", q6_min, q6_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Q         =%10.3g", q6_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin, (int) n_q6_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin2, (int) n_q6_min2);
      ug_message (Text);
    }

    if (nelemc8) {

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Hex Elems     =%10i", (int) nelemc8);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Q        =%10.3g%10.3g", q8_min, q8_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Q         =%10.3g", q8_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin, (int) n_q8_min);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Q<%10.3g  =%10i", qmin2, (int) n_q8_min2);
      ug_message (Text);
    }
  }

  if (task == 2 || task == 3) {

    n_q_min = 0;
    n_q_min2 = 0;
    n_q5_min = 0;
    n_q5_min2 = 0;
    n_q6_min = 0;
    n_q6_min2 = 0;
    n_q8_min = 0;
    n_q8_min2 = 0;

    q_max = 0;
    q_min = 1;
    q_sum = 0;
    q5_max = 0;
    q5_min = 1;
    q5_sum = 0;
    q6_max = 0;
    q6_min = 1;
    q6_sum = 0;
    q8_max = 0;
    q8_min = 1;
    q8_sum = 0;
  }

  return;
}
