#include "UG3_LIB.h"

/*
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_mesh0.c,v 1.3 2025/09/08 12:14:00 marcum Exp $
 * Copyright 1994-2021, David L. Marcum 
 */

INT_ ug3_write_mesh0 (
  FILE * Grid_File,
  INT_ nnode,
  INT_ nbedge,
  INT_ nquad,
  INT_ ntria,
  INT_ nelemc8,
  INT_ nelemc5,
  INT_ nelemc6,
  INT_ nelemc4,
  INT_1D * idibe,
  INT_2D * inibe,
  INT_1D * idibf,
  INT_4D * iniq,
  INT_3D * inibf,
  INT_8D * inielc8,
  INT_1D * idiel,
  INT_5D * inielc5,
  INT_6D * iniel6,
  INT_4D * inielc4,
  DOUBLE_3D * x)
{

  // Write grid data to a MESH volume or surface grid file.

  INT_ i, id, Write_Flag;

  Write_Flag = fprintf (Grid_File, "MeshVersionFormatted 2\n");
  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "Dimension\n");
  Write_Flag = fprintf (Grid_File, "3\n");
  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "#MESH FILE GENERATED BY UG3\n");

  Write_Flag = fprintf (Grid_File, "\n");
  Write_Flag = fprintf (Grid_File, "Vertices\n");
  Write_Flag = fprintf (Grid_File, "%i\n", (int) nnode);

  if (Write_Flag >= 0) {
    for (i = 1; i <= nnode; i++) {
      Write_Flag = fprintf (Grid_File, "%.15g %.15g %.15g 0\n",
                            x[i][0], x[i][1], x[i][2]);
    }
  }

  if (Write_Flag >= 0 && ntria > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Triangles\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) ntria);

    for (i = 1; i <= ntria; i++) {
      Write_Flag = fprintf (Grid_File, "%i %i %i %i\n",
                            (int) inibf[i][0],
                            (int) inibf[i][1],
                            (int) inibf[i][2], (int) idibf[i]);
    }
  }

  if (Write_Flag >= 0 && nquad > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Quadrilaterals\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) nquad);

    for (i = 1; i <= nquad; i++) {
      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i\n",
                            (int) iniq[i][0],
                            (int) iniq[i][1],
                            (int) iniq[i][2],
                            (int) iniq[i][3], (int) idibf[ntria+i]);
    }
  }

  if (Write_Flag >= 0 && nelemc4 > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Tetrahedra\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) nelemc4);

    for (i = 1; i <= nelemc4; i++) {
      id = (idiel != NULL) ? idiel[i]: 1;

      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i\n",
                            (int) inielc4[i][0],
                            (int) inielc4[i][1],
                            (int) inielc4[i][2],
                            (int) inielc4[i][3], (int) id);
    }
  }

  if (Write_Flag >= 0 && nelemc8 > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Hexahedra\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) nelemc8);

    for (i = 1; i <= nelemc8; i++) {
      id = (idiel != NULL) ? idiel[nelemc4+nelemc5+nelemc6+i]: 4;

      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i %i %i %i\n",
                            (int) inielc8[i][0],
                            (int) inielc8[i][1],
                            (int) inielc8[i][2],
                            (int) inielc8[i][3],
                            (int) inielc8[i][4],
                            (int) inielc8[i][5],
                            (int) inielc8[i][6],
                            (int) inielc8[i][7], (int) id);
    }
  }

  if (Write_Flag >= 0 && nelemc5 > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Pyramids\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) nelemc5);

    for (i = 1; i <= nelemc5; i++) {
      id = (idiel != NULL) ? idiel[nelemc4+i]: 2;

      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i\n",
                            (int) inielc5[i][0],
                            (int) inielc5[i][3],
                            (int) inielc5[i][4],
                            (int) inielc5[i][1],
                            (int) inielc5[i][2], (int) id);
    }
  }

  if (Write_Flag >= 0 && nelemc6 > 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "Prisms\n");
    Write_Flag = fprintf (Grid_File, "%i\n", (int) nelemc6);

    for (i = 1; i <= nelemc6; i++) {
      id = (idiel != NULL) ? idiel[nelemc4+nelemc5+i]: 3;

      Write_Flag = fprintf (Grid_File, "%i %i %i %i %i %i %i\n",
                            (int) iniel6[i][0],
                            (int) iniel6[i][1],
                            (int) iniel6[i][2],
                            (int) iniel6[i][3],
                            (int) iniel6[i][4],
                            (int) iniel6[i][5], (int) id);
    }
  }

  if (Write_Flag >= 0) {
    Write_Flag = fprintf (Grid_File, "\n");
    Write_Flag = fprintf (Grid_File, "End\n");
  }

  if (Write_Flag < 0) {
    ug_error_message ("*** ERROR : error writing MESH grid file ***");
    return 1;
  }

  return 0;
}
