#include "UG3_LIB.h"

INT_ ug3_write_grid_file2 (char File_Name[],
                           INT_ Message_Flag,
                           INT_ M_Bnd_Data_Flag,
                           INT_ Write_Task_Flag,
                           INT_ Number_of_BL_Vol_Tets,
                           INT_ Number_of_Nodes,
                           INT_ Number_of_Bnd_Edges,
                           INT_ Number_of_Surf_Quads,
                           INT_ Number_of_Surf_Trias,
                           INT_ Number_of_Vol_Hexs,
                           INT_ Number_of_Vol_Pents_5,
                           INT_ Number_of_Vol_Pents_6,
                           INT_ Number_of_Vol_Tets,
                           INT_1D * Bnd_Edge_ID_Flag,
                           INT_2D * Bnd_Edge_Connectivity,
                           INT_1D * Surf_Grid_BC_Flag,
                           INT_1D * Surf_ID_Flag,
                           INT_1D * Surf_Reconnection_Flag,
                           INT_4D * Surf_Quad_Connectivity,
                           INT_3D * Surf_Tria_Connectivity,
                           INT_8D * Vol_Hex_Connectivity,
                           INT_1D * Vol_ID_Flag,
                           INT_5D * Vol_Pent_5_Connectivity,
                           INT_6D * Vol_Pent_6_Connectivity,
                           INT_4D * Vol_Tet_Connectivity,
                           DOUBLE_3D * Coordinates,
                           DOUBLE_1D * Initial_Normal_Spacing,
                           DOUBLE_1D * BL_Thickness)
{

/*
 * Incrementally write grid data to a volume grid file.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_grid_file2.c,v 1.15 2024/11/02 06:00:34 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  static FILE *Grid_File = NULL;

  CHAR_UG_MAX drive, dname, ext, fname, File_Type, Text;
  CHAR_51 Name_Text;

  INT_ File_Mode, File_Format;
  INT_ check_rmesh = 0;
  INT_ check_rsol = 0;
  INT_ check_wmesh = 0;
  INT_ check_wsol = 0;
  INT_ ierr = 0;

  ierr = ug_file_format_check (File_Name);

  if (ierr)
    return (ierr);

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  ug_splitpath (File_Name, drive, dname, fname, ext);

  strcat (fname, ext);
  strcpy (Name_Text, "");
  strncat (Name_Text, fname, 50);

  if (ug_file_status_monitor_flag())
  {
    snprintf (Text, sizeof(Text), "ug3_write_grid_file2: writing file with File_Name=%s File_Type=%s File_Format=%i Write_Task_Flag=%i", Name_Text, File_Type, (int) File_Format, (int) Write_Task_Flag);
    ug_message (Text);
  }

  if ((Write_Task_Flag == 1 || Write_Task_Flag == -1) && Message_Flag >= 1 && File_Mode == UG_FIO_STANDARD_FILE_MODE)
  {
    ug_message (" ");
    ug_message ("UG3      : OUTPUT GRID");
    ug_message (" ");
    snprintf (Text, sizeof(Text), "UG3      : Grid File Name    = %s", Name_Text);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Quad Surface Faces=%10i", (int) Number_of_Surf_Quads);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Tria Surface Faces=%10i", (int) Number_of_Surf_Trias);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Nodes             =%10i", (int) Number_of_Nodes);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Total Elements    =%10i", (int) (Number_of_Vol_Hexs+Number_of_Vol_Pents_5+Number_of_Vol_Pents_6+Number_of_Vol_Tets));
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Hex Elements      =%10i", (int) Number_of_Vol_Hexs);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Pent_5 Elements   =%10i", (int) Number_of_Vol_Pents_5);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Pent_6 Elements   =%10i", (int) Number_of_Vol_Pents_6);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Tet Elements      =%10i", (int) Number_of_Vol_Tets);
    ug_message (Text);
    ug_message (" ");
  }

  ug3_check_read_write_mesh_sol (&check_rmesh, &check_rsol, &check_wmesh, &check_wsol);

  if (strcmp (File_Type, ".ugrid") == 0)
  {
    if (Write_Task_Flag == 1 || Write_Task_Flag == -1)
    {
      if (File_Mode == UG_FIO_TMP_FILE_MODE)
      {
        strcpy (fname, File_Name);
        strcat (fname, "+");

        if (ug_file_status_monitor_flag())
          ug_message ("ug3_write_grid_file2: opening file in TMP file mode");

        Grid_File = ug_fopen (fname, "tmp");
      }
      else
      {
        ug_backup_file (File_Name);

        if (ug_file_status_monitor_flag())
          ug_message ("ug3_write_grid_file2: opening file in STANDARD file mode");

        Grid_File = ug_fopen (File_Name, "w");
      }
    }

    if (Grid_File == NULL)
    {
      ug_error_message ("*** ERROR 340 : error opening grid file ***");
      return (340);
    }

    ierr = ug3_write_ugrid (Grid_File, File_Format, Write_Task_Flag,
                            Number_of_BL_Vol_Tets,
                            Number_of_Nodes,
                            Number_of_Surf_Quads, Number_of_Surf_Trias,
                            Number_of_Vol_Hexs,
                            Number_of_Vol_Pents_5,
                            Number_of_Vol_Pents_6,
                            Number_of_Vol_Tets,
                            Surf_ID_Flag,
                            Surf_Quad_Connectivity, Surf_Tria_Connectivity,
                            Vol_Hex_Connectivity,
                            Vol_ID_Flag,
                            Vol_Pent_5_Connectivity,
                            Vol_Pent_6_Connectivity,
                            Vol_Tet_Connectivity,
                            Coordinates);

    if (ierr == 0 && M_Bnd_Data_Flag)
      ierr = ug3_write_gdata (Grid_File, File_Format,
                              Number_of_Nodes,
                              Number_of_Surf_Quads, Number_of_Surf_Trias,
                              Surf_Grid_BC_Flag, Surf_Reconnection_Flag,
                              Initial_Normal_Spacing, BL_Thickness);

    if (ierr)
    {
      ug_fclose (Grid_File);
      Grid_File = NULL;
      ug_error_message ("*** ERROR 340 : error writing UGRID grid file ***");
      return (340);
    }

    if (Write_Task_Flag == 1 || Write_Task_Flag == -10)
    {
      if (File_Mode == UG_FIO_TMP_FILE_MODE)
        ug_rewind (Grid_File);
      else
        ug_fclose (Grid_File);

      Grid_File = NULL;
    }
  }

  else if (strcmp (File_Type, ".mesh") == 0 || strcmp (File_Type, ".meshb") == 0)
  {
    if (Write_Task_Flag == 1 || Write_Task_Flag == -1)
      ug_backup_file (File_Name);

    if (check_wmesh) {

      ierr = ug3_write_mesh (File_Name,
                             Write_Task_Flag,
                             Number_of_Nodes,
                             Number_of_Bnd_Edges,
                             Number_of_Surf_Quads,
                             Number_of_Surf_Trias,
                             Number_of_Vol_Hexs,
                             Number_of_Vol_Pents_5,
                             Number_of_Vol_Pents_6,
                             Number_of_Vol_Tets,
                             Bnd_Edge_ID_Flag,
                             Bnd_Edge_Connectivity,
                             Surf_ID_Flag,
                             Surf_Quad_Connectivity,
                             Surf_Tria_Connectivity,
                             Vol_Hex_Connectivity,
                             Vol_ID_Flag,
                             Vol_Pent_5_Connectivity,
                             Vol_Pent_6_Connectivity,
                             Vol_Tet_Connectivity,
                             Coordinates);
    }

    else if (strcmp (File_Type, ".mesh") == 0)
    {
      ug_backup_file (File_Name);

      if (ug_file_status_monitor_flag())
        ug_message ("ug3_write_grid_file2: opening file in STANDARD file mode");

      Grid_File = ug_fopen (File_Name, "w");

      if (Grid_File == NULL)
      {
        ug_error_message ("*** ERROR 340 : error opening grid file ***");
        return (340);
      }

      ierr = ug3_write_mesh0 (Grid_File,
                              Number_of_Nodes,
                              Number_of_Bnd_Edges,
                              Number_of_Surf_Quads,
                              Number_of_Surf_Trias,
                              Number_of_Vol_Hexs,
                              Number_of_Vol_Pents_5,
                              Number_of_Vol_Pents_6,
                              Number_of_Vol_Tets,
                              Bnd_Edge_ID_Flag,
                              Bnd_Edge_Connectivity,
                              Surf_ID_Flag,
                              Surf_Quad_Connectivity,
                              Surf_Tria_Connectivity,
                              Vol_Hex_Connectivity,
                              Vol_ID_Flag,
                              Vol_Pent_5_Connectivity,
                              Vol_Pent_6_Connectivity,
                              Vol_Tet_Connectivity,
                              Coordinates);

      ug_fclose (Grid_File);
    }

    if (ierr)
    {
      ug_error_message ("*** ERROR 340 : error writing MESH/MESHB grid file ***");
      return (340);
    }
  }

  else
  {
    ug_error_message ("*** ERROR 340 : illegal grid file type ***");
    if (check_wmesh)
      ug_error_message ("*** only UGRID, MESH and MESHB file types are supported ***");
    else
      ug_error_message ("*** only UGRID and MESH file types are supported ***");
    return (340);
  }

  return (0);

}
