#include "UG3_LIB.h"

INT_ ug3_write_grid_file (char File_Name[],
                          INT_ Message_Flag,
                          INT_ Write_Task_Flag,
                          INT_ Number_of_BL_Vol_Tets,
                          INT_ Number_of_Nodes,
                          INT_ Number_of_Bnd_Edges,
                          INT_ Number_of_Surf_Quads,
                          INT_ Number_of_Surf_Trias,
                          INT_ Number_of_Vol_Hexs,
                          INT_ Number_of_Vol_Pents_5,
                          INT_ Number_of_Vol_Pents_6,
                          INT_ Number_of_Vol_Tets,
                          INT_1D * Bnd_Edge_ID_Flag,
                          INT_2D * Bnd_Edge_Connectivity,
                          INT_1D * Surf_ID_Flag,
                          INT_4D * Surf_Quad_Connectivity,
                          INT_3D * Surf_Tria_Connectivity,
                          INT_8D * Vol_Hex_Connectivity,
                          INT_1D * Vol_ID_Flag,
                          INT_5D * Vol_Pent_5_Connectivity,
                          INT_6D * Vol_Pent_6_Connectivity,
                          INT_4D * Vol_Tet_Connectivity,
                          DOUBLE_3D * Coordinates)
{

/*
 * Incrementally write grid data to a volume grid file.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_grid_file.c,v 1.14 2024/11/02 06:00:34 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *Surf_Grid_BC_Flag = NULL;
  INT_1D *Surf_Reconnection_Flag = NULL;

  DOUBLE_1D *Initial_Normal_Spacing = NULL;
  DOUBLE_1D *BL_Thickness = NULL;

  INT_ ierr;

  ierr = ug3_write_grid_file2 (File_Name, Message_Flag, 0, Write_Task_Flag,
                               Number_of_BL_Vol_Tets,
                               Number_of_Nodes,
                               Number_of_Bnd_Edges,
                               Number_of_Surf_Quads,
                               Number_of_Surf_Trias,
                               Number_of_Vol_Hexs,
                               Number_of_Vol_Pents_5,
                               Number_of_Vol_Pents_6,
                               Number_of_Vol_Tets,
                               Bnd_Edge_ID_Flag,
                               Bnd_Edge_Connectivity,
                               Surf_Grid_BC_Flag,
                               Surf_ID_Flag,
                               Surf_Reconnection_Flag,
                               Surf_Quad_Connectivity,
                               Surf_Tria_Connectivity,
                               Vol_Hex_Connectivity,
                               Vol_ID_Flag,
                               Vol_Pent_5_Connectivity,
                               Vol_Pent_6_Connectivity,
                               Vol_Tet_Connectivity,
                               Coordinates,
                               Initial_Normal_Spacing,
                               BL_Thickness);

  return (ierr);

}
