#include "UG3_LIB.h"

INT_ ug3_write_func_file (char File_Name[],
                          INT_ Message_Flag,
                          INT_ NDim,
                          INT_ Number_of_Nodes,
                          INT_ Number_of_U_Scalars,
                          INT_ Number_of_U_Vectors,
                          INT_ Number_of_U_Matrixes,
                          INT_ Number_of_U_Metrics,
                          CHAR_21 * U_Scalar_Labels,
                          CHAR_21 * U_Vector_Labels,
                          CHAR_21 * U_Matrix_Labels,
                          CHAR_21 * U_Metric_Labels,
                          DOUBLE_1D * U_Scalars,
                          DOUBLE_1D * U_Vectors,
                          DOUBLE_1D * U_Matrixes,
                          DOUBLE_1D * U_Metrics)

{

/*
 * Write function data to a function file.
 *
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_func_file.c,v 1.17 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Func_File = NULL;

  CHAR_UG_MAX drive, dname, ext, fname, File_Type, Text;
  CHAR_51 Name_Text;

  INT_ Close_Flag, Index, File_Mode, File_Format;
  INT_ SFUNC_Flag = 1;
  INT_ ierr = 0;

  // check file format

  ierr = ug_file_format_check (File_Name);

  if (ierr)
    return (ierr);

  // get file info

  ug_file_info (File_Name, File_Type, &File_Format, &File_Mode);

  // output header

  if (Message_Flag >= 1)
  {
    ug_message (" ");
    ug_message ("UG3      : OUTPUT FUNCTION DATA");
    ug_message (" ");
    ug_message ("UG3      : Writing Data");
    ug_message (" ");
  }

  // backup file

  if (File_Mode == UG_FIO_STANDARD_FILE_MODE)
    ug_backup_file (File_Name);

  // open file and set close flag

  if (File_Mode == UG_FIO_TMP_FILE_MODE)
    Func_File = ug_fopen (File_Name, "tmp");
  else
    Func_File = ug_fopen (File_Name, "w");

  if (Func_File == NULL)
  {
    ug_error_message ("*** ERROR 341 : unable to open output function file ***");
    return (341);
  }

  Close_Flag = 1;

  // write function file

  if (strcmp (File_Type, ".ufunc") == 0)
  {
    SFUNC_Flag = 0;

    Number_of_U_Matrixes = 0;
    Number_of_U_Metrics = 0;

    U_Matrix_Labels = NULL;
    U_Metric_Labels = NULL;

    U_Matrixes = NULL;
    U_Metrics = NULL;
  }

  if (strcmp (File_Type, ".ufunc") == 0 ||
      strcmp (File_Type, ".sfunc") == 0)
    ierr = ug3_write_sfunc (Func_File, File_Format, 3,
                            Number_of_Nodes,
                            Number_of_U_Scalars,
                            Number_of_U_Vectors,
                            Number_of_U_Matrixes,
                            Number_of_U_Metrics, SFUNC_Flag,
                            U_Scalar_Labels,
                            U_Vector_Labels,
                            U_Matrix_Labels,
                            U_Metric_Labels,
                            U_Scalars,
                            U_Vectors,
                            U_Matrixes,
                            U_Metrics);

  else if (strcmp (File_Type, ".sol") == 0 ||
           strcmp (File_Type, ".solb") == 0)
  {
    Close_Flag = ug_fclose (Func_File);

    ierr = ug3_write_sol (File_Name, 
                          NDim, Number_of_Nodes,
                          Number_of_U_Scalars, Number_of_U_Vectors,
                          Number_of_U_Matrixes, Number_of_U_Metrics,
                          U_Scalars, U_Vectors, U_Matrixes, U_Metrics);

    Close_Flag = 0;
  } 

  else
  {
    ug_error_message ("*** ERROR 341 : illegal function file type ***");
    ug_error_message ("*** only SFUNC, UFUNC, SOL, SOLB file types are supported ***");
    return (341);
  }

  // close file

  if (Close_Flag)
    Close_Flag = ug_fclose (Func_File);

  if (ierr)
  {
    ug_error_message ("*** ERROR 341 : error writing function file ***");
    return (341);
  }

  // output function data information

  if (Message_Flag >= 1)
  { 
    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "UG3      : Function File Name= %s", Name_Text);
    ug_message (Text);

    snprintf (Text, sizeof(Text), "UG3      : Scalar Variables  =%10i", (int) Number_of_U_Scalars);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Vector Variables  =%10i", (int) Number_of_U_Vectors);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Matrix Variables  =%10i", (int) Number_of_U_Matrixes);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : Metric Variables  =%10i", (int) Number_of_U_Metrics);
    ug_message (Text);

    if (U_Scalar_Labels)
    {
      for (Index = 0; Index < Number_of_U_Scalars; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG3      : Scalar Label %-4i = %s", (int) Index, U_Scalar_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Vector_Labels)
    {
      for (Index = 0; Index < Number_of_U_Vectors; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG3      : Vector Label %-4i = %s", (int) Index, U_Vector_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Matrix_Labels)
    {
      for (Index = 0; Index < Number_of_U_Matrixes; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG3      : Matrix Label %-4i = %s", (int) Index, U_Matrix_Labels[Index]);
        ug_message (Text);
      }
    }

    if (U_Metric_Labels)
    {
      for (Index = 0; Index < Number_of_U_Metrics; ++Index)
      {
        snprintf (Text, sizeof(Text), "UG3      : Metric Label %-4i = %s", (int) Index, U_Metric_Labels[Index]);
        ug_message (Text);
      }
    }

    ug_message (" ");
  }

  return (0);
}
