#include "UG3_LIB.h"

void ug3_write_dxchk (INT_ mmsg,
                      INT_ nelem,
                      INT_ nelemc5,
                      INT_ nelemc6,
                      INT_ nelemc8,
                      INT_ task,
                      INT_4D * iniel,
                      INT_5D * inielc5,
                      INT_6D * inielc6,
                      INT_8D * inielc8,
                      INT_1D * qlist,
                      INT_1D * qlist5,
                      INT_1D * qlist6,
                      INT_1D * qlist8,
                      double tol,
                      DOUBLE_3D * x)
{

/*
 * Check minimum-edge-lengths for tet, prism, pyramid, and/or hex elements.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_dxchk.c,v 1.9 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  static INT_ n_dxmin = 0;
  static INT_ n_dxmin5 = 0;
  static INT_ n_dxmin6 = 0;
  static INT_ n_dxmin8 = 0;

  INT_ i;
  INT_ qvalue = 2;

  double dxmin, dxtol;

  if (task == 1 || task == 3)
  {
    for (i = 1; i <= nelem; ++i)
    {
      if (ug3_tet_dxchk (i, iniel, tol, &dxmin, &dxtol, x))
      {
        ++n_dxmin;

        if (qlist) qlist[i] = qlist[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc5; ++i)
    {
      if (ug3_pyramid_dxchk (i, inielc5, tol, &dxmin, &dxtol, x))
      {
        ++n_dxmin5;

        if (qlist5) qlist5[i] = qlist5[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc6; ++i)
    {
      if (ug3_prism_dxchk (i, inielc6, tol, &dxmin, &dxtol, x))
      {
        ++n_dxmin6;

        if (qlist6) qlist6[i] = qlist6[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc8; ++i)
    {
      if (ug3_hex_dxchk (i, inielc8, tol, &dxmin, &dxtol, x))
      {
        ++n_dxmin8;

        if (qlist8) qlist8[i] = qlist8[i] + qvalue;
      }
    }
  }

  if ((n_dxmin || n_dxmin5 || n_dxmin6 || n_dxmin8) &&
      (task == 2 || task == 3) && mmsg)
  {
    ug_message ("");
    ug_message ("UG3      : MINIMUM-EDGE-LENGTH CHECK");

    if (nelem)
    {
      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Tet Elems     =%10i", (int) nelem);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Tet DX<Tol    =%10i", (int) n_dxmin);
      ug_message (Text);
    }

    if (nelemc5)
    {
      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Pyramid Elems =%10i", (int) nelemc5);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Pyramid DX<Tol=%10i", (int) n_dxmin5);
      ug_message (Text);
    }

    if (nelemc6)
    {
      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Prism Elems   =%10i", (int) nelemc6);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Prism DX<Tol  =%10i", (int) n_dxmin6);
      ug_message (Text);
    }

    if (nelemc8)
    {
      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Hex Elems     =%10i", (int) nelemc8);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Hex DX<Tol    =%10i", (int) n_dxmin8);
      ug_message (Text);
    }
  }

  if (task == 2 || task == 3)
  {
    n_dxmin = 0;
    n_dxmin5 = 0;
    n_dxmin6 = 0;
    n_dxmin8 = 0;
  }

  return;
}
