#include "UG3_LIB.h"

INT_ ug3_write_bgdata_file (char Case_Name[],
                            INT_ mmetbg,
                            INT_ mmsg,
                            INT_ nelbg,
                            INT_ nnbg,
                            INT_4D * ielielbg,
                            INT_4D * inielbg,
                            DOUBLE_1D * dfbg,
                            DOUBLE_6D * metbg,
                            DOUBLE_3D * xbg)
{

/*
 * Write BGDATA background mesh data file.
 * 
 * SD3 LIB : Sub-Domain Utility Library
 * 3D Version : $Id: ug3_write_bgdata_file.c,v 1.10 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  FILE *Data_File = NULL;

  CHAR_UG_MAX drive, dname, ext, fname, File_Name, Text;
  CHAR_51 Name_Text;

  size_t iw = 0;

  ug_set_byte_order (1);

  if (mmsg >= 1)
  {
    ug_message (" ");
    ug_message ("UG3      : OUTPUT BACKGROUND MESH DATA FILE");
    ug_message (" ");

    ug_cpu_message ("");
  }

  strcpy (File_Name, Case_Name);

  if (sizeof (INT_) == sizeof (int))
    strcat (File_Name, ".b8.bgdata");
  else
    strcat (File_Name, ".b8l.bgdata");

  ug_splitpath (File_Name, drive, dname, fname, ext);

  strcat (fname, ext);
  strcpy (Name_Text, "");
  strncat (Name_Text, fname, 50);

  if (mmsg >= 1)
  {
    snprintf (Text, sizeof(Text), "UG3      : BG Data File Name = %s", Name_Text);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : BG Elements       =%10i", (int) nelbg);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG3      : BG Nodes          =%10i", (int) nnbg);
    ug_message (Text);
  }

  ug_backup_file (File_Name);

  Data_File = ug_fopen (File_Name, "w");

  if (Data_File == NULL)
  {
    ug_error_message ("*** ERROR 348 : error opening BG data file ***");
    return (348);
  }

  iw = iw + ug_fwrite (&mmetbg, sizeof (INT_), 1, Data_File);
  iw = iw - 1;
  iw = iw + ug_fwrite (&nelbg, sizeof (INT_), 1, Data_File);
  iw = iw - 1;
  iw = iw + ug_fwrite (&nnbg, sizeof (INT_), 1, Data_File);
  iw = iw - 1;
  iw = iw + ug_fwrite (ielielbg[1], sizeof (INT_4D), nelbg, Data_File);
  iw = iw - nelbg;
  iw = iw + ug_fwrite (inielbg[1], sizeof (INT_4D), nelbg, Data_File);
  iw = iw - nelbg;
  iw = iw + ug_fwrite (&(dfbg[1]), sizeof (DOUBLE_1D), nnbg, Data_File);
  iw = iw - nnbg;
  if (mmetbg)
  {
    iw = iw + ug_fwrite (metbg[1], sizeof (DOUBLE_6D), nnbg, Data_File);
    iw = iw - nnbg;
  }
  iw = iw + ug_fwrite (xbg[1], sizeof (DOUBLE_3D), nnbg, Data_File);
  iw = iw - nnbg;

  ug_fclose (Data_File);

  if (iw != 0)
  {
    ug_error_message ("*** ERROR 349 : error writing BGDATA file ***");
    return (349);
  }

  if (mmsg >= 1)
  {
    ug_message (" ");

    ug_cpu_message ("UG3      :");
  }

  return (0);
}
