#include "UG3_LIB.h"

INT_ ug3_write_arearchk (INT_ nbface,
                         INT_1D * ibcibf,
                         INT_3D * inibf,
                         double arear_qbmin,
                         double arear_qbmin2,
                         DOUBLE_3D * x)
{

/*
 * Check boundary surface tria-face area ratios.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_arearchk.c,v 1.5 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_3D *ibfibf = NULL;

  INT_ ibface, jbface, ibfn;
  INT_ ierr = 0;
  INT_ merr = 0;
  INT_ mmsg = 0;
  INT_ mmultc = 1;
  INT_ mreorder = 0;
  INT_ n_sum = 0;
  INT_ n_arear_qbmin = 0;
  INT_ n_arear_qbmin2 = 0;

  double dc0, dc1,
         area_max, area_min, area1, area2, area3, areai, areaj, areas,
         arear, arear_avg, arear_max, arear_min, arear_sum;

  dc0 = 0.0;
  dc1 = 1.0;

  ug_message ("");
  ug_message ("UG3      : AREA NEIGHBOR RATIO CHECK");
  ug_message ("UG3      : AREA NEIGHBOR RATIO = AREA_min / AREA_max");
  ug_message ("");

  ierr = ug3_ibfibf2 (merr, mmsg, mmultc, mreorder, nbface,
                      ibcibf, inibf, NULL, NULL, &ibfibf, NULL, x);

  if (ierr)
  {
    ug_free (ibfibf);
    return (ierr);
  }

  arear_max = dc0;
  arear_min = dc1;
  arear_sum = dc0;

  for (ibface = 1; ibface <= nbface; ++ibface)
  {
    ug3_face_area (inibf[ibface][0], inibf[ibface][1], inibf[ibface][2], 
                   &area1, &area2, &area3, &areas, x);

    areai = sqrt (areas);

    for (ibfn = 0; ibfn < 4; ++ibfn)
    {
      jbface = ibfibf[ibface][ibfn];
    
      if (ibface > jbface && jbface > 0)
      {
        ug3_face_area (inibf[jbface][0], inibf[jbface][1], inibf[jbface][2], 
                       &area1, &area2, &area3, &areas, x);

        areaj = sqrt (areas);

        area_max = MAX (areai, areaj);
        area_min = MIN (areai, areaj);

        arear = area_min / area_max;

        arear_max = MAX (arear_max, arear);
        arear_min = MIN (arear_min, arear);
        arear_sum = arear_sum + arear;

        ++n_sum;

        if (arear < arear_qbmin)
          ++n_arear_qbmin;

        ++n_sum;

        if (arear < arear_qbmin2)
          ++n_arear_qbmin2;
      }
    }
  }

  arear_avg = arear_sum / ((double) n_sum);

  snprintf (Text, sizeof(Text), "UG3      : Min, Max AreaRatio=%10.3g%10.3g", arear_min, arear_max);
  ug_message (Text);
  snprintf (Text, sizeof(Text), "UG3      : Average AreaRatio =%10.3g", arear_avg);
  ug_message (Text);
  snprintf (Text, sizeof(Text), "UG3      : No. AR<%10.3g =%10i", arear_qbmin, (int) n_arear_qbmin);
  ug_message (Text);
  snprintf (Text, sizeof(Text), "UG3      : No. AR<%10.3g =%10i", arear_qbmin2, (int) n_arear_qbmin2);
  ug_message (Text);

  ug_free (ibfibf);

  return (0);
}
