#include "UG3_LIB.h"

void ug3_write_angchk (INT_ mmsg,
                       INT_ nelem,
                       INT_ nelemc5,
                       INT_ nelemc6,
                       INT_ nelemc8,
                       INT_ task,
                       INT_4D * iniel,
                       INT_5D * inielc5,
                       INT_6D * inielc6,
                       INT_8D * inielc8,
                       INT_1D * qlist,
                       INT_1D * qlist5,
                       INT_1D * qlist6,
                       INT_1D * qlist8,
                       double ang_qmax,
                       double ang_qmax2,
                       DOUBLE_3D * x)
{

/*
 * Check mixed element dihedral angles. If task=1 then routine may be called
 * multiple times with different sets of elements. If task=2 then output is
 * generated for the complete set. If task=3 then everything is done in one
 * call.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_write_angchk.c,v 1.30 2022/11/21 00:25:14 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  static INT_ n_ang_qmax = 0;
  static INT_ n_ang_qmax2 = 0;
  static INT_ n_ang5_qmax = 0;
  static INT_ n_ang5_qmax2 = 0;
  static INT_ n_ang6_qmax = 0;
  static INT_ n_ang6_qmax2 = 0;
  static INT_ n_ang8_qmax = 0;
  static INT_ n_ang8_qmax2 = 0;

  static double ang_max = 0;
  static double ang_min = 180.0;
  static double ang_sum = 0;
  static double ang5_max = 0;
  static double ang5_min = 180.0;
  static double ang5_sum = 0;
  static double ang6_max = 0;
  static double ang6_min = 180.0;
  static double ang6_sum = 0;
  static double ang8_max = 0;
  static double ang8_min = 180.0;
  static double ang8_sum = 0;

  INT_ i, i1, i2, i3, i4, i5, i6, i7, i8;
  INT_ qvalue = 1;

  double ang_cnv, ang_avg, ang_mx,
         ang21, ang31, ang32, ang41, ang42, ang43,
         ang51, ang52, ang53, ang54, ang62, ang63, ang64, ang65,
         ang73, ang76, ang84, ang85, ang87,
         dc1, dc45,
         w21, w31, w32, w41, w42, w43,
         w51, w52, w53, w54, w62, w63, w64, w65,
         w73, w76, w84, w85, w87;

  dc1 = 1.0;
  dc45 = 45.0;

  ang_cnv = dc45 / atan (dc1);

  if (task == 1 || task == 3)
  {
    for (i = 1; i <= nelem; ++i)
    {
      i1 = iniel[i][0];
      i2 = iniel[i][1];
      i3 = iniel[i][2];
      i4 = iniel[i][3];

      ug3_tet_dh_ang_w (i1, i2, i3, i4, &w21, &w31, &w32, &w41, &w42, &w43, x);

      ang21 = ang_cnv * acos (w21);
      ang31 = ang_cnv * acos (w31);
      ang32 = ang_cnv * acos (w32);
      ang41 = ang_cnv * acos (w41);
      ang42 = ang_cnv * acos (w42);
      ang43 = ang_cnv * acos (w43);

      ang_sum = ang_sum + ang21 + ang31 + ang32 + ang41 + ang42 + ang43;

      ang_mx = MAX (ang21, ang31);
      ang_mx = MAX (ang_mx, ang32);
      ang_mx = MAX (ang_mx, ang41);
      ang_mx = MAX (ang_mx, ang42);
      ang_mx = MAX (ang_mx, ang43);

      ang_max = MAX (ang_max, ang_mx);

      ang_min = MIN (ang_min, ang21);
      ang_min = MIN (ang_min, ang31);
      ang_min = MIN (ang_min, ang32);
      ang_min = MIN (ang_min, ang41);
      ang_min = MIN (ang_min, ang42);
      ang_min = MIN (ang_min, ang43);

      if (ang_mx > ang_qmax)
        ++n_ang_qmax;

      if (ang_mx > ang_qmax2)
      {
        ++n_ang_qmax2;

        if (qlist) qlist[i] = qlist[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc5; ++i)
    {
      i1 = inielc5[i][0];
      i2 = inielc5[i][1];
      i3 = inielc5[i][2];
      i4 = inielc5[i][3];
      i5 = inielc5[i][4];

      ug3_pyramid_dh_ang_w (i1, i2, i3, i4, i5, &w21, &w31, &w32, &w41, &w43, &w52, &w53, &w54, x);

      ang21 = ang_cnv * acos (w21);
      ang31 = ang_cnv * acos (w31);
      ang32 = ang_cnv * acos (w32);
      ang41 = ang_cnv * acos (w41);
      ang43 = ang_cnv * acos (w43);
      ang52 = ang_cnv * acos (w52);
      ang53 = ang_cnv * acos (w53);
      ang54 = ang_cnv * acos (w54);

      ang5_sum = ang5_sum + ang21 + ang31 + ang32 + ang41
                          + ang43 + ang52 + ang53 + ang54;

      ang_mx = MAX (ang21, ang31);
      ang_mx = MAX (ang_mx, ang32);
      ang_mx = MAX (ang_mx, ang41);
      ang_mx = MAX (ang_mx, ang43);
      ang_mx = MAX (ang_mx, ang52);
      ang_mx = MAX (ang_mx, ang53);
      ang_mx = MAX (ang_mx, ang54);

      ang5_max = MAX (ang5_max, ang_mx);

      ang5_min = MIN (ang5_min, ang21);
      ang5_min = MIN (ang5_min, ang31);
      ang5_min = MIN (ang5_min, ang32);
      ang5_min = MIN (ang5_min, ang41);
      ang5_min = MIN (ang5_min, ang43);
      ang5_min = MIN (ang5_min, ang52);
      ang5_min = MIN (ang5_min, ang53);
      ang5_min = MIN (ang5_min, ang54);

      if (ang_mx > ang_qmax)
        ++n_ang5_qmax;

      if (ang_mx > ang_qmax2)
      {
        ++n_ang5_qmax2;

        if (qlist5) qlist5[i] = qlist5[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc6; ++i)
    {
      i1 = inielc6[i][0];
      i2 = inielc6[i][1];
      i3 = inielc6[i][2];
      i4 = inielc6[i][3];
      i5 = inielc6[i][4];
      i6 = inielc6[i][5];

      ug3_prism_dh_ang_w (i1, i2, i3, i4, i5, i6, &w21, &w31, &w32, &w41, &w52, &w54, &w63, &w64, &w65, x);

      ang21 = ang_cnv * acos (w21);
      ang31 = ang_cnv * acos (w31);
      ang32 = ang_cnv * acos (w32);
      ang41 = ang_cnv * acos (w41);
      ang52 = ang_cnv * acos (w52);
      ang54 = ang_cnv * acos (w54);
      ang63 = ang_cnv * acos (w63);
      ang64 = ang_cnv * acos (w64);
      ang65 = ang_cnv * acos (w65);

      ang6_sum = ang6_sum + ang21 + ang31 + ang32 + ang41 + ang52
                          + ang54 + ang63 + ang64 + ang65;

      ang_mx = MAX (ang21, ang31);
      ang_mx = MAX (ang_mx, ang32);
      ang_mx = MAX (ang_mx, ang41);
      ang_mx = MAX (ang_mx, ang52);
      ang_mx = MAX (ang_mx, ang54);
      ang_mx = MAX (ang_mx, ang63);
      ang_mx = MAX (ang_mx, ang64);
      ang_mx = MAX (ang_mx, ang65);

      ang6_max = MAX (ang6_max, ang_mx);

      ang6_min = MIN (ang6_min, ang21);
      ang6_min = MIN (ang6_min, ang31);
      ang6_min = MIN (ang6_min, ang32);
      ang6_min = MIN (ang6_min, ang41);
      ang6_min = MIN (ang6_min, ang52);
      ang6_min = MIN (ang6_min, ang54);
      ang6_min = MIN (ang6_min, ang63);
      ang6_min = MIN (ang6_min, ang64);
      ang6_min = MIN (ang6_min, ang65);

      if (ang_mx > ang_qmax)
        ++n_ang6_qmax;

      if (ang_mx > ang_qmax2)
      {
        ++n_ang6_qmax2;

        if (qlist6) qlist6[i] = qlist6[i] + qvalue;
      }
    }

    for (i = 1; i <= nelemc8; ++i)
    {
      i1 = inielc8[i][0];
      i2 = inielc8[i][1];
      i3 = inielc8[i][2];
      i4 = inielc8[i][3];
      i5 = inielc8[i][4];
      i6 = inielc8[i][5];
      i7 = inielc8[i][6];
      i8 = inielc8[i][7];

      ug3_hex_dh_ang_w (i1, i2, i3, i4, i5, i6, i7, i8, &w21, &w32, &w41, &w43, &w51, &w62, &w65, &w73, &w76, &w84, &w85, &w87, x);

      ang21 = ang_cnv * acos (w21);
      ang32 = ang_cnv * acos (w32);
      ang41 = ang_cnv * acos (w41);
      ang43 = ang_cnv * acos (w43);
      ang51 = ang_cnv * acos (w51);
      ang62 = ang_cnv * acos (w62);
      ang65 = ang_cnv * acos (w65);
      ang73 = ang_cnv * acos (w73);
      ang76 = ang_cnv * acos (w76);
      ang84 = ang_cnv * acos (w84);
      ang85 = ang_cnv * acos (w85);
      ang87 = ang_cnv * acos (w87);

      ang8_sum = ang8_sum + ang21 + ang32 + ang41 + ang43 + ang51 + ang62
                          + ang65 + ang73 + ang76 + ang84 + ang85 + ang87;

      ang_mx = MAX (ang21, ang32);
      ang_mx = MAX (ang_mx, ang41);
      ang_mx = MAX (ang_mx, ang43);
      ang_mx = MAX (ang_mx, ang51);
      ang_mx = MAX (ang_mx, ang62);
      ang_mx = MAX (ang_mx, ang65);
      ang_mx = MAX (ang_mx, ang73);
      ang_mx = MAX (ang_mx, ang76);
      ang_mx = MAX (ang_mx, ang84);
      ang_mx = MAX (ang_mx, ang85);
      ang_mx = MAX (ang_mx, ang87);

      ang8_max = MAX (ang8_max, ang_mx);

      ang8_min = MIN (ang8_min, ang21);
      ang8_min = MIN (ang8_min, ang32);
      ang8_min = MIN (ang8_min, ang41);
      ang8_min = MIN (ang8_min, ang43);
      ang8_min = MIN (ang8_min, ang51);
      ang8_min = MIN (ang8_min, ang62);
      ang8_min = MIN (ang8_min, ang65);
      ang8_min = MIN (ang8_min, ang73);
      ang8_min = MIN (ang8_min, ang76);
      ang8_min = MIN (ang8_min, ang84);
      ang8_min = MIN (ang8_min, ang85);
      ang8_min = MIN (ang8_min, ang87);

      if (ang_mx > ang_qmax)
        ++n_ang8_qmax;

      if (ang_mx > ang_qmax2)
      {
        ++n_ang8_qmax2;

        if (qlist8) qlist8[i] = qlist8[i] + qvalue;
      }
    }
  }

  if ((task == 2 || task == 3) && mmsg)
  {
    ug_message ("");
    ug_message ("UG3      : DIHEDRAL ANGLE CHECK");

    if (nelem)
    {
      ang_avg = ang_sum / ((double) (6*nelem));

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Tet Elems     =%10i", (int) nelem);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Ang      =%10.4g%10.4g", ang_min, ang_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Angle     =%10.3g", ang_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang_qmax);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang_qmax2);
      ug_message (Text);
    }

    if (nelemc5)
    {
      ang_avg = ang5_sum / ((double) (8*nelemc5));

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Pyramid Elems =%10i", (int) nelemc5);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Ang      =%10.4g%10.4g", ang5_min, ang5_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Angle     =%10.3g", ang_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang5_qmax);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang5_qmax2);
      ug_message (Text);
    }

    if (nelemc6)
    {
      ang_avg = ang6_sum / ((double) (9*nelemc6));

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Prism Elems   =%10i", (int) nelemc6);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Ang      =%10.4g%10.4g", ang6_min, ang6_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Angle     =%10.3g", ang_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang6_qmax);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang6_qmax2);
      ug_message (Text);
    }

    if (nelemc8)
    {
      ang_avg = ang8_sum / ((double) (12*nelemc8));

      ug_message ("");
      snprintf (Text, sizeof(Text), "UG3      : No. Hex Elems     =%10i", (int) nelemc8);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Min, Max Ang      =%10.4g%10.4g", ang8_min, ang8_max);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : Average Angle     =%10.3g", ang_avg);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang8_qmax);
      ug_message (Text);
      snprintf (Text, sizeof(Text), "UG3      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang8_qmax2);
      ug_message (Text);
    }
  }

  if (task == 2 || task == 3)
  {
    n_ang_qmax = 0;
    n_ang_qmax2 = 0;
    n_ang5_qmax = 0;
    n_ang5_qmax2 = 0;
    n_ang6_qmax = 0;
    n_ang6_qmax2 = 0;
    n_ang8_qmax = 0;
    n_ang8_qmax2 = 0;

    ang_max = 0;
    ang_min = 180.0;
    ang_sum = 0;
    ang5_max = 0;
    ang5_min = 180.0;
    ang5_sum = 0;
    ang6_max = 0;
    ang6_min = 180.0;
    ang6_sum = 0;
    ang8_max = 0;
    ang8_min = 180.0;
    ang8_sum = 0;
  }

  return;
}
