#include "UG3_LIB.h"

INT_ ug3_volrchk (INT_ nelem,
                  INT_4D * ieliel,
                  INT_4D * iniel,
                  INT_1D * madd,
                  double volr_qmin,
                  DOUBLE_3D * x)
{

/*
 * Check tet element volume ratios.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_volrchk.c,v 1.3 2021/02/07 01:45:09 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_ ielem, jelem, ieln;
  INT_ n_volr_qmin = 0;

  double dc0, voli, volj, vol_max, vol_min, w;

  dc0 = 0.0;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    voli = ug3_tet_vol (iniel[ielem][0], iniel[ielem][1],
                        iniel[ielem][2], iniel[ielem][3], x);

    for (ieln = 0; ieln < 4; ++ieln)
    {
      jelem = ieliel[ielem][ieln];
    
      if (ielem > jelem && jelem > 0)
      {
        volj = ug3_tet_vol (iniel[jelem][0], iniel[jelem][1],
                            iniel[jelem][2], iniel[jelem][3], x);

        vol_max = MAX (voli, volj);
        vol_min = MIN (voli, volj);

        w = vol_min - volr_qmin * vol_max;

        if (w < dc0)
        {
          ++n_volr_qmin;

          madd[ielem] = 1;
          madd[jelem] = 1;
        }
      }
    }
  }

  return (n_volr_qmin);
}
