#include "UG3_LIB.h"

INT_ ug3_triaq
 (INT_ mmsg,
  INT_ *nbface,
  INT_ nnode,
  INT_ *nquad,
  INT_1D * ibcibf,
  INT_1D * idibf,
  INT_1D * ierribf,
  INT_3D * inibf,
  INT_4D ** iniq,
  INT_1D * iqibf,
  INT_1D * irfibf,
  DOUBLE_3D * x)

{

/*
 * Replace previously converted tria surface faces with quad surface.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_triaq.c,v 1.14 2023/04/13 22:43:45 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  INT_1D *ibciq = NULL;
  INT_3D *ibfibf = NULL;
  INT_1D *ibfichk = NULL;
  INT_1D *ibfin = NULL;
  INT_1D *idiq = NULL;
  INT_1D *libfin = NULL;
  INT_1D *mchkbf = NULL;

  INT_ ibface, ibfn, ierr, iquad, jbface, jquad, kquad, merr, mmultc, mreorder,
       nbfpnt, nbfpntd;

  merr = (ierribf) ? 1: 0;
  mmultc = (x) ? 1: 0;
  mreorder = 0;
  nbfpntd = 0;

  // return if quad map is not set

  if (iqibf == NULL)
    return (0);

  // initialize quad connectivity

  ug_free (*iniq);

  *iniq = NULL;

  // set number of quads

  *nquad = 0;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    if (iqibf[ibface]) ++(*nquad);
  }

  *nquad = *nquad/2;

  if (*nquad == 0)
    return (0);

  // allocate work arrays and quad connectivity

  ierr = 0;

  ibciq = (INT_1D *) ug_malloc (&ierr, ((*nquad)+1) * sizeof (INT_1D));
  ibfibf = (INT_3D *) ug_malloc (&ierr, (*nbface+1) * sizeof (INT_3D));
  ibfichk = (INT_1D *) ug_malloc (&ierr, (*nbface+1) * sizeof (INT_1D));
  ibfin = (INT_1D *) ug_malloc (&ierr, (nbfpntd+1) * sizeof (INT_1D));
  idiq = (INT_1D *) ug_malloc (&ierr, ((*nquad)+1) * sizeof (INT_1D));
  libfin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbf = (INT_1D *) ug_malloc (&ierr, (*nbface+1) * sizeof (INT_1D));

  *iniq = (INT_4D *) ug_malloc (&ierr, ((*nquad)+1) * sizeof (INT_4D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100329 : unable to allocate required memory ***");
    ierr = 100329;
  }

  // set tria-face per node map

  if (ierr == 0)
    ierr = ug3_ibfin (*nbface, &nbfpntd, nnode, &nbfpnt,
                      inibf, &ibfin, libfin);

  // set tria-face neighbor connectivity map

  if (ierr == 0)
    ierr = ug3_ibfibf (merr, mmsg, mmultc, mreorder, *nbface,
                       ibcibf, ibfin, inibf, irfibf, NULL,
                       libfin, ibfichk, mchkbf, ibfibf, ierribf, x);

  ug_free (ibfin);
  ug_free (libfin);

  // return on error

  if (ierr)
  {
    ug_free (ibciq);
    ug_free (ibfibf);
    ug_free (idiq);
    ug_free (*iniq);
    *iniq = NULL;
    return (ierr);
  }

  // re-form quad faces from tria faces based on the quad face map iqibf

  kquad = 0;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    iquad = iqibf[ibface];

    if (iquad > 0)
    {
      ibfn = 0;

      jquad = 0;

      do
      {
        jbface = ibfibf[ibface][ibfn];

        if (jbface)
          jquad = iqibf[jbface];

        ++ibfn;
      }
      while (ibfn <= 2 && iquad != jquad);

      if (iquad == jquad)
      {
        ++kquad;

        --ibfn;

        ibciq[kquad] = ibcibf[ibface];
        idiq[kquad] = idibf[ibface];

        (*iniq)[kquad][0] = inibf[ibface][ibfn];
        (*iniq)[kquad][1] = (ibfn < 2) ? inibf[ibface][ibfn+1]:
                                         inibf[ibface][0];
        (*iniq)[kquad][2] = (ibfibf[jbface][0] == ibface) ? inibf[jbface][0]:
                            (ibfibf[jbface][1] == ibface) ? inibf[jbface][1]:
                                                            inibf[jbface][2];
        (*iniq)[kquad][3] = (ibfn > 0) ? inibf[ibface][ibfn-1]:
                                         inibf[ibface][2];

        iqibf[ibface] = -kquad;
        iqibf[jbface] = -kquad;
      }
    }
  }

  // reset quad flag

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    iquad = ug_abs (iqibf[ibface]);
  }

  // set BC, ID, and tria connectivity for trias

  jbface = 0;

  for (ibface = 1; ibface <= *nbface; ++ibface)
  {
    if (iqibf[ibface] == 0)
    {
      ++jbface;

      ibcibf[jbface] = ibcibf[ibface];
      idibf[jbface] = idibf[ibface];

      inibf[jbface][0] = inibf[ibface][0];
      inibf[jbface][1] = inibf[ibface][1];
      inibf[jbface][2] = inibf[ibface][2];
    }
  }

  *nbface = jbface;

  // set BC and ID for quads

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    ibface = (*nbface) + iquad;

    ibcibf[ibface] = ibciq[iquad];
    idibf[ibface] = idiq[iquad];
  }

  // free work arrays

  ug_free (ibciq);
  ug_free (ibfibf);
  ug_free (ibfichk);
  ug_free (idiq);
  ug_free (mchkbf);

  return (0);

}
