#include "UG3_LIB.h"

static INT_ nsplit_ = 0;

static INT_1D *ielc8isplit_ = NULL;
static INT_1D *ielc8fisplit_ = NULL;
static INT_9D *inisplit_ = NULL;

/*
 * Routines to save, get and free hex-element split-face data.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug3_split_data.c,v 1.12 2021/02/07 01:45:09 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

void ug3_save_split_data (INT_ nsplit,
                          INT_1D * ielc8isplit,
                          INT_1D * ielc8fisplit,
                          INT_9D * inisplit)
{
  // save hex-element split-face data

  nsplit_ = nsplit;
  ielc8isplit_ = ielc8isplit;
  ielc8fisplit_ = ielc8fisplit;
  inisplit_ = inisplit;

  return;
}

void ug3_get_split_data (INT_ *nsplit,
                         INT_1D ** ielc8isplit,
                         INT_1D ** ielc8fisplit,
                         INT_9D ** inisplit)
{
  // save hex-element split-face data

  *nsplit = nsplit_;
  *ielc8isplit = ielc8isplit_;
  *ielc8fisplit = ielc8fisplit_;
  *inisplit = inisplit_;

  return;
}

void ug3_free_split_data (void)
{
  // free hex-element split-face data

  ug_free (ielc8isplit_);
  ug_free (ielc8fisplit_);
  ug_free (inisplit_);

  nsplit_ = 0;

  ielc8isplit_ = NULL;
  ielc8fisplit_ = NULL;
  inisplit_ = NULL;

  return;
}
